/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.util.Locale;
import org.basex.io.IOFile;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchiveCreate;
import org.basex.query.func.archive.ArchiveOut;
import org.basex.query.func.archive.CreateFromOptions;
import org.basex.query.func.archive.CreateOptions;
import org.basex.query.iter.BasicIter;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

public class ArchiveCreateFrom
extends ArchiveCreate {
    @Override
    public B64 item(QueryContext qc, InputInfo ii) throws QueryException {
        BasicIter<Item> entries;
        IOFile root = new IOFile(this.toPath(this.arg(0), qc).toString());
        if (!root.isDir()) {
            throw QueryError.FILE_NO_DIR_X.get(this.info, root);
        }
        CreateFromOptions options = this.toOptions(this.arg(1), new CreateFromOptions(), true, qc);
        boolean recursive = options.get(CreateFromOptions.RECURSIVE);
        boolean rootDir = options.get(CreateFromOptions.ROOT_DIR);
        if (this.defined(2)) {
            entries = this.arg(2).iter(qc);
        } else {
            TokenList tl = new TokenList();
            if (recursive) {
                for (String file : root.descendants()) {
                    tl.add(file);
                }
            } else {
                for (IOFile file : root.children()) {
                    if (file.isDir()) continue;
                    tl.add(file.name());
                }
            }
            entries = StrSeq.get(tl).iter();
        }
        int level = this.level(options);
        String format = options.get(CreateOptions.FORMAT).toLowerCase(Locale.ENGLISH);
        String dir = rootDir && root.parent() != null ? root.name() + "/" : "";
        ArrayOutput ao = new ArrayOutput();
        try (ArchiveOut out = ArchiveOut.get(format, this.info, ao);){
            out.level(level);
            try {
                Item item;
                while ((item = qc.next(entries)) != null) {
                    IOFile file = new IOFile(root, Token.string(this.checkElemToken(item, qc).string(this.info)));
                    if (!file.exists()) {
                        throw QueryError.FILE_NOT_FOUND_X.get(this.info, file);
                    }
                    if (file.isDir()) {
                        throw QueryError.FILE_IS_DIR_X.get(this.info, file);
                    }
                    this.add(new Item[]{item, B64.get(file.read())}, out, level, dir, qc);
                }
            }
            catch (IOException ex) {
                throw QueryError.ARCHIVE_ERROR_X.get(this.info, ex);
            }
        }
        return B64.get(ao.finish());
    }
}

