/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.archive.ArchiveFn;
import org.basex.query.func.archive.ArchiveOut;
import org.basex.query.func.archive.ArchiveText;
import org.basex.query.func.archive.CreateOptions;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.util.InputInfo;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;

public class ArchiveCreate
extends ArchiveFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        ArrayOutput ao = new ArrayOutput();
        this.create(ao, qc);
        return B64.get(ao.finish());
    }

    public final void create(OutputStream os, QueryContext qc) throws QueryException {
        Map<String, Item[]> map = this.toMap(this.arg(0), this.arg(1), qc);
        CreateOptions options = this.toOptions(this.arg(2), new CreateOptions(), true, qc);
        this.create(map, options, os, qc);
    }

    final void create(Map<String, Item[]> map, CreateOptions opts, OutputStream os, QueryContext qc) throws QueryException {
        String format = opts.get(CreateOptions.FORMAT).toLowerCase(Locale.ENGLISH);
        if (format.equals("gzip") && map.size() > 1) {
            throw QueryError.ARCHIVE_SINGLE_X.get(this.info, format);
        }
        int level = this.level(opts);
        try (ArchiveOut out = ArchiveOut.get(format, this.info, os);){
            out.level(level);
            try {
                for (Item[] entry : map.values()) {
                    this.add(entry, out, level, "", qc);
                }
            }
            catch (IOException ex) {
                throw QueryError.ARCHIVE_ERROR_X.get(this.info, ex);
            }
        }
    }

    final int level(CreateOptions options) throws QueryException {
        int level = 8;
        String format = options.get(CreateOptions.FORMAT);
        String alg = options.get(CreateOptions.ALGORITHM);
        if (alg != null) {
            if (format.equals("zip") && !Strings.eq(alg, "stored", "deflate") || format.equals("gzip") && !Strings.eq(alg, "deflate")) {
                throw QueryError.ARCHIVE_FORMAT_X_X.get(this.info, CreateOptions.ALGORITHM.name(), alg);
            }
            if (Strings.eq(alg, "stored")) {
                level = 0;
            }
        }
        return level;
    }

    final void add(Item[] entry, ArchiveOut out, int level, String root, QueryContext qc) throws QueryException, IOException {
        Item header = entry[0];
        Item content = entry[1];
        String name = Token.string(header.string(this.info));
        if (name.isEmpty()) {
            throw QueryError.ARCHIVE_DESCRIPTOR1.get(this.info, new Object[0]);
        }
        if (Prop.WIN) {
            name = name.replace('\\', '/');
        }
        ZipEntry ze = new ZipEntry(root + name);
        String encoding = "UTF-8";
        byte[] lvl = null;
        if (header instanceof ANode) {
            byte[] ea;
            ANode el = (ANode)header;
            lvl = el.attribute(ArchiveText.Q_LEVEL);
            byte[] mod = el.attribute(ArchiveText.Q_LAST_MODIFIED);
            if (mod != null) {
                try {
                    ze.setTime(this.toMs(new Dtm(mod, this.info), qc));
                }
                catch (QueryException qe) {
                    Util.debug(qe);
                    throw QueryError.ARCHIVE_DESCRIPTOR3_X.get(this.info, new Object[]{mod});
                }
            }
            if ((ea = el.attribute(ArchiveText.Q_ENCODING)) != null && !Charset.isSupported(encoding = Strings.normEncoding(Token.string(ea)))) {
                throw QueryError.ARCHIVE_ENCODE1_X.get(this.info, new Object[]{ea});
            }
        }
        try {
            out.level(lvl == null ? level : Token.toInt(lvl));
        }
        catch (IllegalArgumentException ex) {
            Util.debug(ex);
            throw QueryError.ARCHIVE_DESCRIPTOR2_X.get(this.info, new Object[]{lvl});
        }
        if (content instanceof Bin) {
            out.write(ze, (Bin)content, this.info);
        } else {
            byte[] value = this.toBytes(content);
            out.write(ze, encoding == "UTF-8" ? value : this.encode(value, encoding, qc));
        }
    }

    final Map<String, Item[]> toMap(Expr entries, Expr contents, QueryContext qc) throws QueryException {
        Iter entrs = entries.iter(qc);
        Iter cntnts = contents.iter(qc);
        LinkedHashMap<String, Item[]> map = new LinkedHashMap<String, Item[]>();
        int e = 0;
        int c = 0;
        while (true) {
            Item item = qc.next(entrs);
            Item cn = cntnts.next();
            if (item == null || cn == null) {
                if (cn != null) {
                    do {
                        ++c;
                    } while (cntnts.next() != null);
                }
                if (item != null) {
                    do {
                        ++e;
                    } while (entrs.next() != null);
                }
                if (e == c) break;
                throw QueryError.ARCHIVE_NUMBER_X_X.get(this.info, e, c);
            }
            map.put(Token.string(this.checkElemToken(item, qc).string(this.info)), new Item[]{item, cn});
            ++e;
            ++c;
        }
        return map;
    }
}

