/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.DynFuncCall;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class PartFunc
extends Arr {
    private final StaticContext sc;
    private final int[] holes;

    public PartFunc(InputInfo info, StaticContext sc, Expr[] exprs, int[] holes) {
        super(info, SeqType.FUNCTION_O, exprs);
        this.sc = sc;
        this.holes = holes;
    }

    private Expr body() {
        return this.exprs[this.exprs.length - 1];
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        if (this.allAreValues(false)) {
            return cc.preEval(this);
        }
        Expr body = this.body();
        FuncType ft = body.funcType();
        if (ft != null && ft != SeqType.FUNCTION) {
            int nargs = this.exprs.length + this.holes.length - 1;
            if (ft.argTypes.length != nargs) {
                throw QueryError.INVARITY_X_X_X.get(this.info, QueryError.arguments(nargs), ft.argTypes.length, body);
            }
            SeqType[] args = new SeqType[this.holes.length];
            int hl = this.holes.length;
            for (int h = 0; h < hl; ++h) {
                args[h] = ft.argTypes[this.holes[h]];
            }
            this.exprType.assign(FuncType.get(ft.declType, args).seqType());
        }
        return this;
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        FItem func = this.toFunction(this.body(), qc);
        int hl = this.holes.length;
        int nargs = this.exprs.length + hl - 1;
        if (func.arity() != nargs) {
            throw QueryError.INVARITY_X_X_X.get(this.info, QueryError.arguments(nargs), func.arity(), func);
        }
        FuncType ft = func.funcType();
        Expr[] args = new Expr[nargs];
        VarScope vs = new VarScope(this.sc);
        Var[] params = new Var[hl];
        int a = -1;
        for (int h = 0; h < hl; ++h) {
            while (++a < this.holes[h]) {
                args[a] = this.exprs[a - h].value(qc);
            }
            params[h] = vs.addNew(func.paramName(this.holes[h]), null, false, qc, this.info);
            args[a] = new VarRef(this.info, params[h]);
            SeqType at = ft.argTypes[a];
            if (at == null) continue;
            params[h].refineType(at, null);
        }
        int al = args.length;
        while (++a < al) {
            args[a] = this.exprs[a - hl].value(qc);
        }
        AnnList anns = func.annotations();
        boolean updating = anns.contains(Annotation.UPDATING);
        DynFuncCall expr = new DynFuncCall(this.info, this.sc, updating, false, (Expr)func, args);
        FuncType type = FuncType.get(anns, ft.declType, params);
        return new FuncItem(this.sc, anns, null, params, type, expr, vs.stackSize(), this.info, qc.focus.copy());
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(Arrays.copyOf(this.exprs, this.exprs.length - 1));
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new PartFunc(this.info, this.sc, PartFunc.copyAll((CompileContext)cc, vm, (Expr[])this.exprs), (int[])this.holes.clone()));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof PartFunc && Arrays.equals(this.holes, ((PartFunc)obj).holes) && super.equals(obj);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.body()).token('(');
        int p = -1;
        int el = this.exprs.length;
        int hs = this.holes.length;
        for (int i = 0; i < hs; ++i) {
            while (++p < this.holes[i]) {
                if (p > 0) {
                    qs.token(", ");
                }
                qs.token(this.exprs[p - i]);
            }
            if (p > 0) {
                qs.token(", ");
            }
            qs.token('?');
        }
        while (++p < el + hs - 1) {
            qs.token(", ").token(this.exprs[p - hs]);
        }
        qs.token(')');
    }
}

