/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.ann.Ann;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Cast;
import org.basex.query.expr.Expr;
import org.basex.query.func.Closure;
import org.basex.query.func.FuncDefinition;
import org.basex.query.func.FuncLit;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.TypedFunc;
import org.basex.query.func.java.JavaCall;
import org.basex.query.util.Flag;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.hash.QNmMap;
import org.basex.query.util.list.AnnList;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.QNm;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.ListType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.IntList;
import org.basex.util.similarity.Levenshtein;

public final class Functions {
    public static final ArrayList<FuncDefinition> DEFINITIONS = new ArrayList();
    private static final TokenObjMap<QNm> CACHE = new TokenObjMap();
    private static final TokenSet URIS = new TokenSet();

    private Functions() {
    }

    private static Type getCast(QNm name, long arity, InputInfo ii) throws QueryException {
        Enum type = ListType.find(name);
        if (type == null) {
            type = AtomType.find(name, false);
        }
        if (type == null) {
            throw QueryError.WHICHFUNC_X.get(ii, new Object[]{AtomType.similar(name)});
        }
        if (type.oneOf(AtomType.NOTATION, AtomType.ANY_ATOMIC_TYPE)) {
            throw QueryError.ABSTRACTFUNC_X.get(ii, new Object[]{name.prefixId()});
        }
        if (arity != 1L) {
            throw QueryError.FUNCARITY_X_X_X.get(ii, name.string(), QueryError.arguments(arity), 1);
        }
        return type;
    }

    static FuncDefinition builtIn(QNm name) {
        int id = CACHE.id(name.internal());
        return id != 0 ? DEFINITIONS.get(id - 1) : null;
    }

    public static boolean staticURI(byte[] uri) {
        for (byte[] u : URIS) {
            if (!Token.eq(uri, u)) continue;
            return true;
        }
        return false;
    }

    public static QueryException wrongArity(FuncDefinition fd, int arity, InputInfo ii) {
        IntList arities = new IntList();
        if (!fd.variadic()) {
            int min = fd.minMax[0];
            int max = fd.minMax[1];
            for (int m = min; m <= max; ++m) {
                arities.add(m);
            }
        }
        return Functions.wrongArity(fd, arity, arities, ii);
    }

    public static QueryException wrongArity(Object function, int arity, IntList arities, InputInfo ii) {
        int as = arities.ddo().size();
        if (as == 0) {
            return QueryError.FUNCARITY_X_X.get(ii, function, QueryError.arguments(arity));
        }
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int a = 0; a < as; ++a) {
            int m = arities.get(a);
            if (m < min) {
                min = m;
            }
            if (m <= max) continue;
            max = m;
        }
        TokenBuilder ext = new TokenBuilder();
        if (as > 2 && max - min + 1 == as) {
            ext.addInt(min).add(45).addInt(max);
        } else {
            for (int a = 0; a < as; ++a) {
                if (a != 0) {
                    ext.add(a + 1 < as ? ", " : " or ");
                }
                ext.addInt(arities.get(a));
            }
        }
        return QueryError.FUNCARITY_X_X_X.get(ii, function, QueryError.arguments(arity), ext);
    }

    private static StandardFunc builtIn(QNm name, Expr[] args, QNmMap<Expr> keywords, StaticContext sc, InputInfo ii) throws QueryException {
        FuncDefinition fd = Functions.builtIn(name);
        if (fd == null) {
            return null;
        }
        int arity = args.length;
        int min = fd.minMax[0];
        int max = fd.minMax[1];
        if (arity <= max) {
            if (keywords != null) {
                ExprList list = (ExprList)new ExprList().add(args);
                for (QNm qnm : keywords) {
                    int i = fd.indexOf(qnm);
                    if (i == -1) {
                        throw QueryError.KEYWORDUNKNOWN_X_X.get(ii, fd, qnm);
                    }
                    if (list.get(i) != null) {
                        throw QueryError.ARGTWICE_X_X.get(ii, fd, qnm);
                    }
                    list.set(i, keywords.get(qnm));
                }
                for (int l = list.size() - 1; l >= 0; --l) {
                    if (list.get(l) != null) continue;
                    if (l < min) {
                        throw QueryError.ARGMISSING_X_X.get(ii, fd, fd.names[l].prefixString());
                    }
                    list.set(l, Empty.UNDEFINED);
                }
                return fd.get(sc, ii, (Expr[])list.finish());
            }
            if (arity >= min) {
                return fd.get(sc, ii, args);
            }
        }
        throw Functions.wrongArity(fd, arity, ii);
    }

    private static Expr closureOrFItem(AnnList anns, QNm name, Var[] params, FuncType ft, Expr expr, VarScope vs, InputInfo ii, boolean runtime, boolean updating) {
        return runtime ? new FuncItem(vs.sc, anns, name, params, ft, expr, vs.stackSize(), ii) : new Closure(ii, name, updating ? SeqType.EMPTY_SEQUENCE_Z : ft.declType, params, expr, anns, null, vs);
    }

    public static Expr getLiteral(QNm name, int arity, QueryContext qc, StaticContext sc, InputInfo ii, boolean runtime) throws QueryException {
        if (Token.eq(name.uri(), QueryText.XS_URI)) {
            Type type = Functions.getCast(name, arity, ii);
            VarScope vs = new VarScope(sc);
            Var[] params = new Var[]{vs.addNew(new QNm("item", ""), SeqType.ANY_ATOMIC_TYPE_ZO, true, qc, ii)};
            SeqType st = SeqType.get(type, Occ.ZERO_OR_ONE);
            Cast expr = new Cast(sc, ii, new VarRef(ii, params[0]), st);
            AnnList anns = new AnnList();
            FuncType ft = FuncType.get(anns, ((Expr)expr).seqType(), params);
            return Functions.closureOrFItem(anns, name, params, ft, expr, vs, ii, runtime, false);
        }
        FuncDefinition fd = Functions.builtIn(name);
        if (fd != null) {
            if (arity < fd.minMax[0] || arity > fd.minMax[1]) {
                throw Functions.wrongArity(fd, arity, ii);
            }
            AnnList anns = new AnnList();
            VarScope vs = new VarScope(sc);
            FuncType ft = fd.type(arity, anns);
            QNm[] names = fd.paramNames(arity);
            Var[] params = new Var[arity];
            Expr[] args = new Expr[arity];
            for (int i = 0; i < arity; ++i) {
                params[i] = vs.addNew(names[i], ft.argTypes[i], true, qc, ii);
                args[i] = new VarRef(ii, params[i]);
            }
            StandardFunc sf = fd.get(sc, ii, args);
            boolean upd = sf.has(Flag.UPD);
            if (upd) {
                anns.add(new Ann(ii, Annotation.UPDATING, (Value)Empty.VALUE));
                qc.updating();
            }
            return sf.has(Flag.CTX) ? new FuncLit(anns, name, params, sf, ft.seqType(), vs, ii) : Functions.closureOrFItem(anns, name, params, fd.type(arity, anns), sf, vs, ii, runtime, upd);
        }
        StaticFunc sf = qc.functions.get(name, arity);
        if (sf != null) {
            FuncType ft = sf.funcType();
            VarScope vs = new VarScope(sc);
            Var[] params = new Var[arity];
            Expr[] args = new Expr[arity];
            for (int a = 0; a < arity; ++a) {
                params[a] = vs.addNew(sf.paramName(a), ft.argTypes[a], true, qc, ii);
                args[a] = new VarRef(ii, params[a]);
            }
            boolean upd = sf.updating;
            TypedFunc tf = qc.functions.undeclaredFuncCall(sf.name, args, sc, ii);
            Expr func = Functions.closureOrFItem(tf.anns, sf.name, params, ft, tf.func, vs, ii, runtime, upd);
            if (upd) {
                qc.updating();
            }
            return func;
        }
        Object[] sts = new SeqType[arity];
        Arrays.fill(sts, SeqType.ITEM_ZM);
        AnnList anns = new AnnList();
        SeqType st = FuncType.get(anns, SeqType.ITEM_ZM, (SeqType[])sts).seqType();
        VarScope vs = new VarScope(sc);
        Var[] params = new Var[arity];
        Expr[] args = new Expr[arity];
        int vl = params.length;
        for (int v = 0; v < vl; ++v) {
            params[v] = vs.addNew(new QNm("arg" + (v + 1), ""), null, true, qc, ii);
            args[v] = new VarRef(ii, params[v]);
        }
        JavaCall jf = JavaCall.get(name, args, qc, sc, ii);
        return jf == null ? null : new FuncLit(anns, name, params, jf, st, vs, ii);
    }

    public static FuncItem getUser(StaticFunc sf, QueryContext qc, StaticContext sc, InputInfo ii) throws QueryException {
        FuncType ft = sf.funcType();
        VarScope vs = new VarScope(sc);
        int arity = sf.params.length;
        Var[] args = new Var[arity];
        int al = args.length;
        Expr[] calls = new Expr[al];
        for (int a = 0; a < al; ++a) {
            args[a] = vs.addNew(sf.paramName(a), ft.argTypes[a], true, qc, ii);
            calls[a] = new VarRef(ii, args[a]);
        }
        TypedFunc tf = qc.functions.undeclaredFuncCall(sf.name, calls, sc, ii);
        return new FuncItem(sc, tf.anns, sf.name, args, ft, tf.func, vs.stackSize(), ii);
    }

    public static Expr get(QNm name, Expr[] args, QNmMap<Expr> keywords, QueryContext qc, StaticContext sc, InputInfo ii) throws QueryException {
        if (keywords == null && Token.eq(name.uri(), QueryText.XS_URI)) {
            Type type = Functions.getCast(name, args.length, ii);
            SeqType st = SeqType.get(type, Occ.ZERO_OR_ONE);
            return new Cast(sc, ii, args[0], st);
        }
        StandardFunc sf = Functions.builtIn(name, args, keywords, sc, ii);
        if (sf != null) {
            if (sf.updating()) {
                qc.updating();
            }
            return sf;
        }
        if (keywords == null) {
            TypedFunc tf = qc.functions.funcCall(name, args, sc, ii);
            if (tf != null) {
                if (tf.anns.contains(Annotation.UPDATING)) {
                    qc.updating();
                }
                return tf.func;
            }
            JavaCall jf = JavaCall.get(name, args, qc, sc, ii);
            if (jf != null) {
                return jf;
            }
        } else if (!NSGlobal.reserved(name.uri())) {
            throw QueryError.KEYWORDSUPPORT_X.get(ii, new Object[]{name.prefixString()});
        }
        return qc.functions.undeclaredFuncCall((QNm)name, (Expr[])args, (StaticContext)sc, (InputInfo)ii).func;
    }

    static byte[] similar(QNm qname) {
        ArrayList<QNm> qnames = new ArrayList<QNm>(CACHE.size());
        for (QNm qnm : CACHE.values()) {
            qnames.add(qnm);
        }
        byte[] local = Token.lc(qname.local());
        byte[] uri = qname.uri();
        Object similar = Levenshtein.similar(qname.local(), qnames.toArray(), o -> Token.eq(uri, ((QNm)o).uri()) ? ((QNm)o).local() : null);
        for (QNm qnm : qnames) {
            if (similar != null || !Token.eq(Token.lc(qnm.local()), local)) continue;
            similar = qnm;
        }
        for (QNm qnm : qnames) {
            if (similar != null || !Token.eq(uri, qnm.uri()) || !Token.startsWith(Token.lc(qnm.local()), local)) continue;
            similar = qnm;
        }
        return QueryError.similar(qname.prefixString(), similar != null ? ((QNm)similar).prefixString() : null);
    }

    static {
        Function.init(DEFINITIONS);
        Class<?> clz = Reflect.find("org.basex.query.func.ApiFunction");
        Method mth = Reflect.method(clz, "init", ArrayList.class);
        if (mth != null) {
            Reflect.invoke(mth, null, DEFINITIONS);
        }
        for (FuncDefinition fd : DEFINITIONS) {
            URIS.add(fd.uri);
            QNm qnm = new QNm(fd.local(), fd.uri());
            CACHE.put(qnm.internal(), qnm);
        }
    }
}

