/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import java.util.ArrayList;
import java.util.Arrays;
import org.basex.data.Data;
import org.basex.query.expr.path.Test;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.TokenBuilder;

public final class UnionTest
extends Test {
    final Test[] tests;

    UnionTest(NodeType type, Test[] tests) {
        super(type);
        this.tests = tests;
    }

    @Override
    public Test optimize(Data data) {
        ArrayList<Test> list = new ArrayList<Test>();
        for (Test test : this.tests) {
            Test t = test.optimize(data);
            if (t == null) continue;
            list.add(t);
        }
        return this.tests.length != list.size() ? UnionTest.get((Test[])list.toArray(Test[]::new)) : this;
    }

    @Override
    public boolean matches(ANode node) {
        for (Test test : this.tests) {
            if (!test.matches(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean matches(SeqType seqType) {
        Type tp = seqType.type;
        if (tp.intersect(this.type) == null) {
            return Boolean.FALSE;
        }
        Test test = seqType.test();
        return tp == this.type && test instanceof UnionTest && this.equals(test) ? Boolean.TRUE : null;
    }

    @Override
    public Test copy() {
        return this;
    }

    @Override
    public boolean instanceOf(Test test) {
        for (Test t : this.tests) {
            if (t.instanceOf(test)) continue;
            return false;
        }
        return true;
    }

    boolean instance(Test test) {
        for (Test t : this.tests) {
            if (!test.instanceOf(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Test intersect(Test test) {
        ArrayList<Test> list = new ArrayList<Test>(this.tests.length);
        for (Test t : this.tests) {
            Test t2 = t.intersect(test);
            if (t2 == null) continue;
            list.add(t2);
        }
        return UnionTest.get((Test[])list.toArray(Test[]::new));
    }

    public boolean equals(Object obj) {
        return obj instanceof UnionTest && Arrays.equals(this.tests, ((UnionTest)obj).tests);
    }

    @Override
    public String toString(boolean full) {
        TokenBuilder tb = new TokenBuilder();
        for (Test test : this.tests) {
            if (!tb.isEmpty()) {
                tb.add(124);
            }
            tb.add(test.toString(full));
        }
        return tb.toString();
    }
}

