/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import org.basex.data.Data;
import org.basex.query.expr.path.KindTest;
import org.basex.query.expr.path.NamePart;
import org.basex.query.expr.path.Test;
import org.basex.query.expr.path.UnionTest;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class NameTest
extends Test {
    public final QNm qname;
    public final NamePart part;
    public final byte[] local;
    private final byte[] defaultNs;
    private boolean simple;

    public NameTest(QNm name) {
        this(name, NamePart.FULL, NodeType.ELEMENT, null);
    }

    public NameTest(QNm qname, NamePart part, NodeType type, byte[] defaultNs) {
        super(type);
        this.qname = qname;
        this.part = part;
        this.defaultNs = defaultNs != null ? defaultNs : Token.EMPTY;
        this.local = qname.local();
    }

    @Override
    public Test optimize(Data data) {
        if (data == null) {
            return this;
        }
        byte[] dataNs = data.defaultNs();
        if (dataNs == null) {
            return this;
        }
        if (this.part == NamePart.FULL && !this.qname.hasURI()) {
            if (this.type != NodeType.ATTRIBUTE && !Token.eq(dataNs, this.defaultNs)) {
                return null;
            }
            this.simple = true;
        }
        return this.type == NodeType.PROCESSING_INSTRUCTION || this.part() != NamePart.LOCAL || (this.type == NodeType.ELEMENT ? data.elemNames : data.attrNames).contains(this.local) ? this : null;
    }

    @Override
    public Test copy() {
        return this;
    }

    @Override
    public boolean matches(ANode node) {
        if (node.type != this.type) {
            return false;
        }
        switch (this.part()) {
            case LOCAL: {
                return Token.eq(this.local, Token.local(node.name()));
            }
            case URI: {
                return Token.eq(this.qname.uri(), node.qname().uri());
            }
        }
        return this.qname.eq(node.qname());
    }

    public boolean matches(QNm qName) {
        switch (this.part()) {
            case LOCAL: {
                return Token.eq(this.local, qName.local());
            }
            case URI: {
                return Token.eq(this.qname.uri(), qName.uri());
            }
        }
        return this.qname.eq(qName);
    }

    @Override
    public Boolean matches(SeqType seqType) {
        Type tp = seqType.type;
        if (tp.intersect(this.type) == null) {
            return Boolean.FALSE;
        }
        Test test = seqType.test();
        if (tp == this.type && test instanceof NameTest) {
            NameTest np = (NameTest)test;
            if (np.part == NamePart.FULL || np.part == this.part) {
                return this.matches(np.qname);
            }
        }
        return null;
    }

    public NamePart part() {
        return this.simple ? NamePart.LOCAL : this.part;
    }

    @Override
    public boolean instanceOf(Test test) {
        if (test instanceof NameTest) {
            NameTest nt = (NameTest)test;
            return this.type == nt.type && this.part == nt.part && this.qname.eq(nt.qname);
        }
        return super.instanceOf(test);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Test intersect(Test test) {
        if (test instanceof NameTest) {
            NameTest nt = (NameTest)test;
            if (this.type != nt.type) return null;
            if (this.part == nt.part || this.part == NamePart.FULL) {
                if (!nt.matches(this.qname)) return null;
                return this;
            }
            if (nt.part == NamePart.FULL) {
                return test.intersect(this);
            }
            boolean lcl = this.part == NamePart.LOCAL;
            QNm qnm = new QNm(lcl ? this.local : nt.local, lcl ? nt.qname.uri() : this.qname.uri());
            return new NameTest(qnm, NamePart.FULL, this.type, this.defaultNs);
        }
        if (test instanceof KindTest) {
            if (!this.type.instanceOf(test.type)) return null;
            return this;
        }
        if (!(test instanceof UnionTest)) return null;
        return test.intersect(this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NameTest)) {
            return false;
        }
        NameTest nt = (NameTest)obj;
        return this.type == nt.type && this.part == nt.part && this.qname.eq(nt.qname);
    }

    @Override
    public String toString(boolean full) {
        boolean pi = this.type == NodeType.PROCESSING_INSTRUCTION;
        TokenBuilder tb = new TokenBuilder();
        byte[] prefix = this.qname.prefix();
        byte[] uri = this.qname.uri();
        if (this.part == NamePart.LOCAL && !pi) {
            if (!full || this.type != NodeType.ATTRIBUTE) {
                tb.add("*:");
            }
        } else if (prefix.length > 0) {
            tb.add(prefix).add(58);
        } else if (uri.length != 0) {
            tb.add("Q{").add(uri).add(125);
        }
        if (this.part == NamePart.URI) {
            tb.add(42);
        } else {
            tb.add(this.qname.local());
        }
        String test = tb.toString();
        return full || pi ? this.type.toString(test) : test;
    }
}

