/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import org.basex.query.iter.BasicNodeIter;
import org.basex.query.value.node.ANode;
import org.basex.util.Util;

public enum Axis {
    ANCESTOR_OR_SELF("ancestor-or-self", false){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.ancestorOrSelfIter();
        }
    }
    ,
    ANCESTOR("ancestor", false){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.ancestorIter();
        }
    }
    ,
    ATTRIBUTE("attribute", true){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.attributeIter();
        }
    }
    ,
    CHILD("child", true){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.childIter();
        }
    }
    ,
    DESCENDANT_OR_SELF("descendant-or-self", true){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.descendantOrSelfIter();
        }
    }
    ,
    DESCENDANT("descendant", true){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.descendantIter();
        }
    }
    ,
    FOLLOWING_SIBLING("following-sibling", false){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.followingSiblingIter();
        }
    }
    ,
    FOLLOWING("following", false){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.followingIter();
        }
    }
    ,
    PARENT("parent", false){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.parentIter();
        }
    }
    ,
    PRECEDING_SIBLING("preceding-sibling", false){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.precedingSiblingIter();
        }
    }
    ,
    PRECEDING("preceding", false){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.precedingIter();
        }
    }
    ,
    SELF("self", true){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.selfIter();
        }
    };

    public static final Axis[] VALUES;
    public final String name;
    public final boolean down;

    private Axis(String name, boolean down) {
        this.name = name;
        this.down = down;
    }

    abstract BasicNodeIter iter(ANode var1);

    public String toString() {
        return this.name;
    }

    public final Axis invert() {
        switch (this) {
            case ANCESTOR: {
                return DESCENDANT;
            }
            case ANCESTOR_OR_SELF: {
                return DESCENDANT_OR_SELF;
            }
            case ATTRIBUTE: 
            case CHILD: {
                return PARENT;
            }
            case DESCENDANT: {
                return ANCESTOR;
            }
            case DESCENDANT_OR_SELF: {
                return ANCESTOR_OR_SELF;
            }
            case FOLLOWING_SIBLING: {
                return PRECEDING_SIBLING;
            }
            case FOLLOWING: {
                return PRECEDING;
            }
            case PARENT: {
                return CHILD;
            }
            case PRECEDING_SIBLING: {
                return FOLLOWING_SIBLING;
            }
            case PRECEDING: {
                return FOLLOWING;
            }
            case SELF: {
                return SELF;
            }
        }
        throw Util.notExpected();
    }

    static {
        VALUES = Axis.values();
    }
}

