/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.iter.FTIter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.node.FTNode;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public abstract class FTExpr
extends ParseExpr {
    public final FTExpr[] exprs;

    FTExpr(InputInfo info, FTExpr ... exprs) {
        super(info, SeqType.BOOLEAN_O);
        this.exprs = exprs;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.exprs);
    }

    @Override
    public FTExpr compile(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        for (int e = 0; e < el; ++e) {
            this.exprs[e] = this.exprs[e].compile(cc);
        }
        return this;
    }

    @Override
    public FTExpr optimize(CompileContext cc) throws QueryException {
        return this;
    }

    @Override
    public abstract FTIter iter(QueryContext var1) throws QueryException;

    @Override
    public Value value(QueryContext qc) {
        throw Util.notExpected();
    }

    @Override
    public abstract FTNode item(QueryContext var1, InputInfo var2) throws QueryException;

    @Override
    public boolean has(Flag ... flags) {
        for (FTExpr expr : this.exprs) {
            if (!expr.has(flags)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        for (FTExpr expr : this.exprs) {
            if (((Expr)expr).inlineable(ic)) continue;
            return false;
        }
        return true;
    }

    @Override
    public VarUsage count(Var var) {
        return VarUsage.sum(var, this.exprs);
    }

    @Override
    public FTExpr inline(InlineContext ic) throws QueryException {
        return ic.inline(this.exprs) ? this.optimize(ic.cc) : null;
    }

    @Override
    public abstract FTExpr copy(CompileContext var1, IntObjMap<Var> var2);

    public boolean usesExclude() {
        for (FTExpr expr : this.exprs) {
            if (!expr.usesExclude()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return FTExpr.visitAll(visitor, this.exprs);
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (FTExpr expr : this.exprs) {
            size += ((Expr)expr).exprSize();
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof FTExpr && Array.equals(this.exprs, ((FTExpr)obj).exprs);
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), this.exprs);
    }
}

