/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Cast;
import org.basex.query.expr.Expr;
import org.basex.query.expr.constr.CAttr;
import org.basex.query.expr.constr.CComm;
import org.basex.query.expr.constr.CPI;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public abstract class CNode
extends Arr {
    final StaticContext sc;
    final boolean computed;

    CNode(StaticContext sc, InputInfo info, SeqType seqType, boolean computed, Expr ... exprs) {
        super(info, seqType, exprs);
        this.sc = sc;
        this.computed = computed;
    }

    @Override
    public abstract Item item(QueryContext var1, InputInfo var2) throws QueryException;

    final void optValue(CompileContext cc) throws QueryException {
        this.exprs = this.simplifyAll(CompileContext.Simplify.STRING, cc);
        if (this.allAreValues(true) && (this.exprs.length != 1 || !(this.exprs[0] instanceof Str))) {
            this.exprs = new Expr[]{Str.get(this.atomValue(cc.qc, true))};
        }
    }

    final byte[] atomValue(QueryContext qc, boolean empty) throws QueryException {
        TokenBuilder tb = null;
        for (Expr expr : this.exprs) {
            Item item;
            boolean space = false;
            Iter iter = expr.atomIter(qc, this.info);
            while ((item = qc.next(iter)) != null) {
                if (tb == null) {
                    tb = new TokenBuilder();
                } else if (space) {
                    tb.add(32);
                }
                tb.add(item.string(this.info));
                space = true;
            }
        }
        return tb != null ? tb.finish() : (byte[])(empty ? Token.EMPTY : null);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        SeqType st1;
        SeqType st = null;
        if (this.exprs.length == 1 && !(this instanceof CPI) && !(this instanceof CAttr) && (st1 = this.exprs[0].seqType()).zeroOrOne() && st1.instanceOf(SeqType.ANY_ATOMIC_TYPE_ZO) && !this.has(Flag.NDT)) {
            if (mode == CompileContext.Simplify.STRING) {
                st = SeqType.STRING_ZO;
            } else if (mode.oneOf(CompileContext.Simplify.DATA, CompileContext.Simplify.NUMBER)) {
                st = this instanceof CComm ? SeqType.STRING_ZO : SeqType.UNTYPED_ATOMIC_ZO;
            }
        }
        return cc.simplify(this, st != null ? new Cast(cc.sc(), this.info, this.exprs[0], st).optimize(cc) : this, mode);
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.CNS.in(flags) || super.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        return !ic.expr.has(Flag.CNS) && super.inlineable(ic);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof CNode && this.computed == ((CNode)obj).computed && super.equals(obj);
    }

    @Override
    public final String description() {
        return Strings.concat(((NodeType)this.seqType().type).qname().local(), " constructor");
    }

    protected void toString(QueryString qs, String kind) {
        if (kind != null) {
            qs.token(kind);
        }
        qs.token("{");
        if (this.exprs.length > 0) {
            qs.tokens(this.exprs, ", ", false);
        }
        qs.token(" }");
    }
}

