/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import java.util.Arrays;
import java.util.function.Predicate;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.expr.constr.CAttr;
import org.basex.query.expr.constr.CName;
import org.basex.query.expr.constr.CNode;
import org.basex.query.expr.constr.CTxt;
import org.basex.query.expr.constr.Constr;
import org.basex.query.expr.path.Test;
import org.basex.query.util.NSContext;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.Atts;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class CElem
extends CName {
    private final Atts nspaces;

    public CElem(StaticContext sc, InputInfo info, boolean computed, Expr name, Atts nspaces, Expr ... exprs) {
        super(sc, info, SeqType.ELEMENT_O, computed, name, exprs);
        this.nspaces = nspaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        int s = this.addNS();
        try {
            Expr expr = super.compile(cc);
            return expr;
        }
        finally {
            this.sc.ns.size(s);
        }
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.name = this.name.simplifyFor(CompileContext.Simplify.STRING, cc);
        if (this.name instanceof Value) {
            QNm nm = this.qname(true, cc.qc);
            this.name = nm;
            this.exprType.assign(SeqType.get(NodeType.ELEMENT, Occ.EXACTLY_ONE, Test.get(NodeType.ELEMENT, nm, null)));
        }
        Predicate<Expr> atomic = arg -> arg.seqType().instanceOf(SeqType.ANY_ATOMIC_TYPE_ZM);
        Predicate<Expr> text = arg -> arg instanceof CTxt && arg.arg(0) instanceof Item;
        TokenBuilder tb = new TokenBuilder();
        ExprList list = new ExprList(this.exprs.length);
        for (Expr expr : this.exprs) {
            boolean more;
            if (expr instanceof List && ((Checks<Expr>)arg -> text.test((Expr)arg) || arg instanceof Value && atomic.test((Expr)arg)).all((Expr[])expr.args())) {
                more = false;
                for (Expr arg2 : expr.args()) {
                    if (text.test(arg2)) {
                        tb.add(((Item)arg2.arg(0)).string(this.info));
                        more = false;
                        continue;
                    }
                    for (Item item : (Value)arg2) {
                        if (more) {
                            tb.add(32);
                        }
                        tb.add(item.string(this.info));
                        more = true;
                    }
                }
                list.add(Str.get(tb.next()));
                continue;
            }
            if (expr instanceof Seq && atomic.test(expr)) {
                more = false;
                for (Item item : (Seq)expr) {
                    if (more) {
                        tb.add(32);
                    }
                    tb.add(item.string(this.info));
                    more = true;
                }
                list.add(Str.get(tb.next()));
                continue;
            }
            if (expr instanceof Empty) continue;
            list.add(expr);
        }
        this.exprs = (Expr[])list.next();
        if (this.exprs.length > 1 || this.exprs.length == 1 && !(this.exprs[0] instanceof Str)) {
            for (Expr expr : this.exprs) {
                if (expr instanceof Item && atomic.test(expr)) {
                    tb.add(((Item)expr).string(this.info));
                    continue;
                }
                if (text.test(expr)) {
                    tb.add(((Item)expr.arg(0)).string(this.info));
                    continue;
                }
                if (!tb.isEmpty()) {
                    list.add(Str.get(tb.next()));
                }
                list.add(expr);
            }
            if (!tb.isEmpty()) {
                list.add(Str.get(tb.finish()));
            }
            this.exprs = (Expr[])list.finish();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FNode item(QueryContext qc, InputInfo ii) throws QueryException {
        int s = this.addNS();
        try {
            QNm nm = this.qname(true, qc);
            byte[] nmPrefix = nm.prefix();
            byte[] nmUri = nm.uri();
            if (Token.eq(nmPrefix, Token.XML) ^ Token.eq(nmUri, QueryText.XML_URI)) {
                throw QueryError.CEXML.get(this.info, nmPrefix, nmUri);
            }
            if (Token.eq(nmUri, QueryText.XMLNS_URI)) {
                throw QueryError.CEINV_X.get(this.info, new Object[]{nmUri});
            }
            if (Token.eq(nmPrefix, Token.XMLNS)) {
                throw QueryError.CEINV_X.get(this.info, new Object[]{nmPrefix});
            }
            if (!nm.hasURI() && nm.hasPrefix()) {
                throw QueryError.NOQNNAMENS_X.get(this.info, new Object[]{nmPrefix});
            }
            FBuilder elem = FElem.build(nm);
            Constr constr = new Constr(elem, this.info, this.sc, qc).add(this.exprs);
            if (constr.errAtt != null) {
                throw QueryError.NOATTALL_X.get(this.info, constr.errAtt);
            }
            if (constr.errNS != null) {
                throw QueryError.NONSALL_X.get(this.info, constr.errNS);
            }
            if (constr.duplAtt != null) {
                throw QueryError.CATTDUPL_X.get(this.info, constr.duplAtt);
            }
            if (constr.duplNS != null) {
                throw QueryError.DUPLNSCONS_X.get(this.info, new Object[]{constr.duplNS});
            }
            constr.namespaces(this.nspaces, nm);
            FNode fNode = elem.finish();
            return fNode;
        }
        finally {
            this.sc.ns.size(s);
        }
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new CElem(this.sc, this.info, this.computed, this.name.copy(cc, vm), new Atts(this.nspaces), CElem.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    private int addNS() {
        NSContext nsContext = this.sc.ns;
        int size = nsContext.size();
        int ns = this.nspaces.size();
        for (int n = 0; n < ns; ++n) {
            nsContext.add(this.nspaces.name(n), this.nspaces.value(n));
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof CElem && this.nspaces.equals(((CElem)obj).nspaces) && super.equals(obj);
    }

    @Override
    public void toString(QueryString qs) {
        if (this.computed) {
            this.toString(qs, "element");
        } else {
            byte[] nm = ((QNm)this.name).string();
            qs.token('<').token(nm);
            int el = this.exprs.length;
            for (int e = 0; e < el; ++e) {
                Expr expr = this.exprs[e];
                if (!(expr instanceof CAttr) || ((CAttr)expr).computed) {
                    int f;
                    qs.token('>');
                    boolean constr = false;
                    for (f = e; f < el && !constr; ++f) {
                        constr = this.exprs[f] instanceof CNode ? ((CNode)this.exprs[f]).computed : !(this.exprs[f] instanceof Str);
                    }
                    if (constr) {
                        qs.token('{').tokens(Arrays.copyOfRange(this.exprs, e, el), ", ").token("}");
                    } else {
                        for (f = e; f < el; ++f) {
                            if (this.exprs[f] instanceof Str) {
                                qs.value(((Str)this.exprs[f]).string());
                                continue;
                            }
                            qs.token(this.exprs[f]);
                        }
                    }
                    qs.token('<').token('/').token(nm).token('>');
                    return;
                }
                qs.token(expr);
            }
            qs.token('/').token('>');
        }
    }
}

