/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.ArrayList;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.If;
import org.basex.query.expr.Instance;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.TypeCheck;
import org.basex.query.expr.TypeswitchGroup;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class Typeswitch
extends ParseExpr {
    private TypeswitchGroup[] groups;
    private Expr cond;

    public Typeswitch(InputInfo info, Expr cond, TypeswitchGroup[] groups) {
        super(info, SeqType.ITEM_ZM);
        this.cond = cond;
        this.groups = groups;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.cond);
        int gl = this.groups.length;
        Expr[] tmp = new Expr[gl];
        for (int g = 0; g < gl; ++g) {
            tmp[g] = this.groups[g].expr;
        }
        this.checkAllUp(tmp);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        this.cond = this.cond.compile(cc);
        for (TypeswitchGroup group : this.groups) {
            group.compile(cc);
        }
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        boolean opt;
        if (this.cond instanceof Value) {
            Value value = (Value)this.cond;
            for (TypeswitchGroup group : this.groups) {
                if (!group.match(value, null)) continue;
                group.inline(value, cc);
                return cc.replaceWith(this, group.expr);
            }
        }
        SeqType ct = this.cond.seqType();
        ArrayList<SeqType> types = new ArrayList<SeqType>();
        ArrayList<TypeswitchGroup> newGroups = new ArrayList<TypeswitchGroup>(this.groups.length);
        for (TypeswitchGroup group : this.groups) {
            if (!group.removeTypes(ct, types, cc)) continue;
            newGroups.add(group);
        }
        this.groups = (TypeswitchGroup[])newGroups.toArray(TypeswitchGroup[]::new);
        this.exprType.assign(SeqType.union(this.groups, true)).data(this.groups);
        Expr expr = this;
        TypeswitchGroup tg = null;
        int gl = this.groups.length;
        for (int g = 0; g < gl - 1; ++g) {
            ArrayList<SeqType> matching = this.groups[g].matchingTypes(ct);
            if (matching.isEmpty()) continue;
            boolean branch = false;
            block3: for (int h = 0; !branch && h < g; ++h) {
                for (SeqType st : this.groups[h].seqTypes) {
                    if (!((Checks<SeqType>)st::instanceOf).any(matching)) continue;
                    branch = true;
                    continue block3;
                }
            }
            if (branch) break;
            tg = this.groups[g];
            break;
        }
        if (tg == null) {
            opt = true;
            for (int g = 0; opt && g < gl - 1; ++g) {
                opt = this.groups[g].noMatches(ct);
            }
            if (opt) {
                tg = this.groups[gl - 1];
            }
        }
        if (tg == null) {
            opt = true;
            for (int g = 1; opt && g < gl; ++g) {
                opt = this.groups[0].expr.equals(this.groups[g].expr);
            }
            if (opt) {
                tg = this.groups[0];
            }
        }
        if (tg != null) {
            expr = tg.rewrite(this.cond, cc);
        } else if (gl < 3 && this.groups[0].seqTypes.length == 1 && !this.cond.has(Flag.NDT)) {
            Expr iff = new Instance(this.info, this.cond, this.groups[0].seqTypes[0]).optimize(cc);
            Expr thn = this.groups[0].rewrite(this.cond, cc);
            Expr els = this.groups[1].rewrite(this.cond, cc);
            expr = new If(this.info, iff, thn, els).optimize(cc);
        }
        return cc.replaceWith(this, expr);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        boolean changed = false;
        for (TypeswitchGroup group : this.groups) {
            changed |= group.simplifyFor(mode, cc) == null;
        }
        return changed ? this.optimize(cc) : super.simplifyFor(mode, cc);
    }

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.group(qc).iter(qc);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.group(qc).value(qc);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.group(qc).item(qc, this.info);
    }

    private TypeswitchGroup group(QueryContext qc) throws QueryException {
        Value value = this.cond.value(qc);
        for (TypeswitchGroup group : this.groups) {
            if (!group.match(value, qc)) continue;
            return group;
        }
        throw Util.notExpected();
    }

    @Override
    public boolean vacuous() {
        return ((Checks<TypeswitchGroup>)group -> group.expr.vacuous()).all((TypeswitchGroup[])this.groups);
    }

    @Override
    public boolean ddo() {
        return ((Checks<TypeswitchGroup>)group -> group.expr.ddo()).all((TypeswitchGroup[])this.groups);
    }

    @Override
    public boolean has(Flag ... flags) {
        for (TypeswitchGroup group : this.groups) {
            if (!group.has(flags)) continue;
            return true;
        }
        return this.cond.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        for (TypeswitchGroup group : this.groups) {
            if (group.inlineable(ic)) continue;
            return false;
        }
        return this.cond.inlineable(ic);
    }

    @Override
    public VarUsage count(Var var) {
        return this.cond.count(var).plus(VarUsage.maximum(var, this.groups));
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        boolean changed = ic.inline(this.groups, true);
        Expr inlined = this.cond.inline(ic);
        if (inlined != null) {
            changed = true;
            this.cond = inlined;
        }
        return changed ? this.optimize(ic.cc) : null;
    }

    @Override
    public Expr typeCheck(TypeCheck tc, CompileContext cc) throws QueryException {
        boolean changed = false;
        for (TypeswitchGroup group : this.groups) {
            changed = group.typeCheck(tc, cc) != null;
        }
        return changed ? this.optimize(cc) : this;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Typeswitch(this.info, this.cond.copy(cc, vm), (TypeswitchGroup[])Arr.copyAll((CompileContext)cc, vm, (Expr[])this.groups)));
    }

    @Override
    public void markTailCalls(CompileContext cc) {
        for (TypeswitchGroup group : this.groups) {
            group.markTailCalls(cc);
        }
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.cond.accept(visitor) && Typeswitch.visitAll(visitor, this.groups);
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (TypeswitchGroup group : this.groups) {
            size += ((Expr)group).exprSize();
        }
        return size + this.cond.exprSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Typeswitch)) {
            return false;
        }
        Typeswitch ts = (Typeswitch)obj;
        return this.cond.equals(ts.cond) && Array.equals(this.groups, ts.groups);
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), new Object[]{this.cond, this.groups});
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("typeswitch").paren(this.cond).tokens(this.groups);
    }
}

