/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryException;
import org.basex.query.QueryFunction;
import org.basex.query.QueryString;
import org.basex.query.expr.Arith;
import org.basex.query.expr.Arr;
import org.basex.query.expr.CachedMap;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Cast;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.DualIterMap;
import org.basex.query.expr.DualMap;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.If;
import org.basex.query.expr.ItemMap;
import org.basex.query.expr.IterMap;
import org.basex.query.expr.List;
import org.basex.query.expr.Range;
import org.basex.query.expr.path.AxisPath;
import org.basex.query.expr.path.Path;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.fn.ContextFn;
import org.basex.query.func.fn.FnData;
import org.basex.query.func.fn.FnReplicate;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public abstract class SimpleMap
extends Arr {
    SimpleMap(InputInfo info, Expr ... exprs) {
        super(info, SeqType.ITEM_ZM, exprs);
    }

    public static Expr get(CompileContext cc, InputInfo ii, Expr ... exprs) throws QueryException {
        int el = exprs.length;
        return el > 1 ? new CachedMap(ii, exprs).optimize(cc) : (el > 0 ? exprs[0] : Empty.VALUE);
    }

    @Override
    public final void checkUp() throws QueryException {
        int el = this.exprs.length;
        for (int e = 0; e < el - 1; ++e) {
            this.checkNoUp(this.exprs[e]);
        }
        this.exprs[el - 1].checkUp();
    }

    @Override
    public boolean vacuous() {
        return this.exprs[this.exprs.length - 1].vacuous();
    }

    @Override
    public final Expr compile(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        for (int e = 0; e < el; ++e) {
            Expr expr = cc.compileOrError(this.exprs[e], e == 0);
            if (e == 0) {
                cc.pushFocus(expr);
            } else {
                cc.updateFocus(expr);
            }
            this.exprs[e] = expr;
        }
        cc.removeFocus();
        return this.optimize(cc);
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        boolean dual;
        Expr ex = this.flattenMaps(cc);
        if (ex == null) {
            ex = this.mergePaths(cc);
        }
        if (ex == null) {
            ex = this.mergeOps(cc);
        }
        if (ex == null) {
            ex = this.dropOps(cc);
        }
        if (ex != null) {
            return ex;
        }
        boolean cached = false;
        boolean item = true;
        for (Expr expr : this.exprs) {
            cached = cached || expr.has(Flag.POS);
            item = item && expr.seqType().zeroOrOne();
        }
        boolean dualiter = this.exprs.length == 2;
        boolean bl = dual = dualiter && this.exprs[1].seqType().zeroOrOne();
        return this.copyType(cached ? new CachedMap(this.info, this.exprs) : (item ? new ItemMap(this.info, this.exprs) : (dual ? new DualMap(this.info, this.exprs) : (dualiter ? new DualIterMap(this.info, this.exprs) : new IterMap(this.info, this.exprs)))));
    }

    private Expr flattenMaps(CompileContext cc) throws QueryException {
        ExprList list = new ExprList();
        for (Expr expr : this.exprs) {
            if (expr instanceof SimpleMap && !(expr instanceof CachedMap)) {
                list.add(expr.args());
                cc.info("flatten nested %: %", expr, this::description);
                continue;
            }
            list.add(expr);
        }
        return list.size() != this.exprs.length ? SimpleMap.get(cc, this.info, (Expr[])list.finish()) : null;
    }

    private Expr merge(Expr expr, Expr next, CompileContext cc) throws QueryException {
        long size = expr.size();
        if (!expr.has(Flag.NDT) && !next.has(Flag.POS)) {
            InlineContext ic;
            if (!next.has(Flag.CTX)) {
                Expr count = null;
                if (size != -1L) {
                    count = Int.get(size);
                } else if (expr instanceof Range && expr.arg(0) == Int.ONE && expr.arg(1).seqType().instanceOf(SeqType.INTEGER_O)) {
                    count = expr.arg(1);
                }
                if (count != null) {
                    return cc.replicate(next, count, this.info);
                }
            }
            if (next instanceof StandardFunc && !next.has(Flag.NDT)) {
                Expr[] args = next.args();
                if (Function.REPLICATE.is(next) && ((FnReplicate)next).singleEval(true) && args[0] instanceof ContextValue && !args[1].has(Flag.CTX)) {
                    if (Function.REPLICATE.is(expr) && ((FnReplicate)expr).singleEval(true)) {
                        Expr cnt = new Arith(this.info, expr.arg(1), args[1], Calc.MULT).optimize(cc);
                        return cc.function(Function.REPLICATE, this.info, expr.arg(0), cnt);
                    }
                    if (expr instanceof SingletonSeq && ((SingletonSeq)expr).singleItem()) {
                        return cc.function(Function.REPLICATE, this.info, expr, args[1]);
                    }
                } else if (Function.ITEMS_AT.is(next) && !args[0].has(Flag.CTX) && args[1] instanceof ContextValue) {
                    if (expr instanceof RangeSeq) {
                        RangeSeq seq = (RangeSeq)expr;
                        long[] range = seq.range(false);
                        Expr func = cc.function(Function._UTIL_RANGE, this.info, args[0], Int.get(range[0]), Int.get(range[1]));
                        return seq.asc ? func : cc.function(Function.REVERSE, this.info, func);
                    }
                    if (expr instanceof Range) {
                        return cc.function(Function._UTIL_RANGE, this.info, args[0], expr.arg(0), expr.arg(1));
                    }
                    if (expr.seqType().instanceOf(SeqType.INTEGER_ZM)) {
                        return cc.function(Function.ITEMS_AT, this.info, args[0], expr);
                    }
                } else {
                    if (Function.DATA.is(next) && (((FnData)next).contextAccess() || args[0] instanceof ContextValue)) {
                        return cc.function(Function.DATA, this.info, expr);
                    }
                    if (Function.STRING_TO_CODEPOINTS.is(expr) && Function.CODEPOINTS_TO_STRING.is(next) && args[0] instanceof ContextValue) {
                        return cc.function(Function.CHARACTERS, this.info, expr.args());
                    }
                }
            }
            if (expr instanceof RangeSeq && next instanceof Arith) {
                boolean minus;
                Arith arith = (Arith)next;
                boolean plus = arith.calc == Calc.PLUS;
                boolean bl = minus = arith.calc == Calc.MINUS;
                if ((plus || minus) && next.arg(0) instanceof ContextValue && next.arg(1) instanceof Int) {
                    RangeSeq seq = (RangeSeq)expr;
                    long diff = ((Int)next.arg(1)).itr();
                    return RangeSeq.get(seq.range(true)[0] + (plus ? diff : -diff), seq.size(), seq.asc);
                }
            }
            Expr input = expr;
            if (Function.REPLICATE.is(expr) && ((FnReplicate)expr).singleEval(true)) {
                input = expr.arg(0);
            } else if (expr instanceof SingletonSeq && ((SingletonSeq)expr).singleItem()) {
                input = ((SingletonSeq)expr).itemAt(0L);
            }
            if (input.size() == 1L && (ic = new InlineContext(null, input, cc)).inlineable(next)) {
                Expr ex;
                try {
                    ex = ic.inline(next);
                }
                catch (QueryException qe) {
                    ex = cc.error(qe, next);
                }
                return expr == input ? ex : cc.replicate(ex, Int.get(size), this.info);
            }
            ExprList unroll = cc.unroll(expr, false);
            if (unroll != null) {
                ExprList results = new ExprList(unroll.size());
                for (Expr ex : unroll) {
                    Expr nxt = (long)results.size() == size - 1L ? next : next.copy(cc, new IntObjMap<Var>());
                    results.add(SimpleMap.get(cc, this.info, ex, nxt));
                }
                return List.get(cc, this.info, (Expr[])results.finish());
            }
        }
        if (expr.seqType().zeroOrOne()) {
            boolean inline = false;
            if (next instanceof Cast) {
                Cast cast = (Cast)next;
                inline = cast.expr instanceof ContextValue && cast.seqType.occ == Occ.ZERO_OR_ONE;
            } else if (next instanceof ContextFn) {
                inline = ((ContextFn)next).inlineable();
            }
            if (inline) {
                try {
                    return new InlineContext(null, expr, cc).inline(next);
                }
                catch (QueryException qe) {
                    return cc.error(qe, next);
                }
            }
        }
        if (next instanceof Filter) {
            Filter filter = (Filter)next;
            if (filter.root instanceof ContextValue && !filter.mayBePositional()) {
                return Filter.get(cc, this.info, expr, filter.exprs);
            }
        }
        if (next instanceof If) {
            If iff = (If)next;
            if (iff.exprs[1] == Empty.VALUE && !iff.exprs[0].has(Flag.POS) && !iff.cond.seqType().mayBeNumber()) {
                return SimpleMap.get(cc, this.info, Filter.get(cc, this.info, expr, iff.cond), iff.exprs[0]);
            }
        }
        return null;
    }

    private Expr mergePaths(CompileContext cc) throws QueryException {
        if (!this.exprs[0].ddo()) {
            return null;
        }
        Expr root = this.exprs[0];
        ExprList steps = (ExprList)new ExprList().add(new Expr[0]);
        if (root instanceof AxisPath) {
            AxisPath ap = (AxisPath)root;
            root = ap.root;
            steps.add(ap.steps);
        }
        int el = this.exprs.length;
        int e = 0;
        while (++e < el && this.exprs[e] instanceof AxisPath) {
            AxisPath path2 = (AxisPath)this.exprs[e];
            if (path2.root != null || !path2.simple()) break;
            steps.add(path2.steps);
        }
        if (e == 1) {
            return null;
        }
        Expr path = Path.get(cc, this.info, root, (Expr[])steps.finish());
        if (e == el) {
            return path;
        }
        ExprList list = (ExprList)((Object)new ExprList(el - e + 1).add(path));
        while (e < el) {
            list.add(this.exprs[e]);
            ++e;
        }
        return SimpleMap.get(cc, this.info, (Expr[])list.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expr mergeOps(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        ExprList list = (ExprList)((Object)new ExprList(el).add(this.exprs[0]));
        boolean pushed = false;
        try {
            for (int e = 1; e < el; ++e) {
                Expr merged = this.merge((Expr)list.peek(), this.exprs[e], cc);
                if (merged != null) {
                    list.set(list.size() - 1, merged);
                } else {
                    list.add(this.exprs[e]);
                }
                if (list.size() <= 1) continue;
                Expr expr = (Expr)list.get(list.size() - 2);
                if (pushed) {
                    cc.updateFocus(expr);
                    continue;
                }
                cc.pushFocus(expr);
                pushed = true;
            }
        }
        finally {
            if (pushed) {
                cc.removeFocus();
            }
        }
        for (int n = list.size() - 1; n > 0; --n) {
            if (!(list.get(n) instanceof ContextValue)) continue;
            list.remove(n);
        }
        int ls = list.size();
        if (ls == el) {
            return null;
        }
        if (ls == 1) {
            return cc.replaceWith(this, (Expr)list.peek());
        }
        cc.info("simplify %: %", this::description, this);
        return SimpleMap.get(cc, this.info, (Expr[])list.finish());
    }

    private Expr dropOps(CompileContext cc) throws QueryException {
        int ls;
        ExprList list = new ExprList(this.exprs.length);
        long min = 1L;
        long max = 1L;
        for (Expr expr : this.exprs) {
            if (max == 0L) break;
            list.add(expr);
            long es = expr.size();
            if (es == 0L) {
                min = 0L;
                max = 0L;
                continue;
            }
            if (es > 0L) {
                min *= es;
                if (max == -1L) continue;
                max *= es;
                continue;
            }
            Occ o = expr.seqType().occ;
            if (o.min == 0L) {
                min = 0L;
            }
            if (o.max <= 1L) continue;
            max = -1L;
        }
        if ((ls = list.size()) != this.exprs.length) {
            cc.info("simplify %: %", this::description, this);
            return SimpleMap.get(cc, this.info, (Expr[])list.finish());
        }
        this.exprType.assign(this.exprs[ls - 1], new long[]{min, max});
        return this.size() == 0L && !this.has(Flag.NDT, Flag.HOF) ? cc.emptySeq(this) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expr toPath(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        ExprList steps = new ExprList();
        int el = this.exprs.length;
        QueryFunction<Integer, Expr> simplify = e -> {
            Expr expr = this.exprs[e];
            return mode == CompileContext.Simplify.DISTINCT || e + 1 == el ? expr.simplifyFor(mode, cc) : expr;
        };
        Expr root = simplify.apply(0);
        cc.pushFocus(root);
        if (root instanceof AxisPath) {
            AxisPath path = (AxisPath)root;
            root = path.root;
            steps.add(path.steps);
        }
        try {
            for (int e2 = 1; e2 < el; ++e2) {
                Expr expr = simplify.apply(e2);
                if (!(expr instanceof AxisPath)) {
                    SimpleMap simpleMap = this;
                    return simpleMap;
                }
                AxisPath path = (AxisPath)expr;
                if (path.root != null) {
                    SimpleMap simpleMap = this;
                    return simpleMap;
                }
                steps.add(path.steps);
                cc.updateFocus(expr);
            }
        }
        finally {
            cc.removeFocus();
        }
        return Path.get(cc, this.info, root, (Expr[])steps.finish());
    }

    @Override
    public final Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr lst;
        Expr expr = this;
        int el = this.exprs.length;
        Expr last = this.exprs[el - 1];
        Expr prev = this.exprs[el - 2];
        if (mode.oneOf(CompileContext.Simplify.DATA, CompileContext.Simplify.NUMBER, CompileContext.Simplify.STRING, CompileContext.Simplify.COUNT, CompileContext.Simplify.DISTINCT) && (lst = cc.get(prev, () -> last.simplifyFor(mode, cc))) != last) {
            expr = SimpleMap.get(cc, this.info, (Expr[])((ExprList)((ExprList)new ExprList(el).add(this.exprs)).set(el - 1, lst)).finish());
        }
        if (expr == this && mode.oneOf(CompileContext.Simplify.EBV, CompileContext.Simplify.PREDICATE, CompileContext.Simplify.DISTINCT)) {
            expr = mode != CompileContext.Simplify.DISTINCT && this.seqType().zeroOrOne() && prev.seqType().type instanceof NodeType && last instanceof Bln ? (last == Bln.FALSE ? Bln.FALSE : SimpleMap.get(cc, this.info, Arrays.copyOf(this.exprs, el - 1))) : this.toPath(mode, cc);
        }
        return cc.simplify(this, expr, mode);
    }

    @Override
    public final boolean has(Flag ... flags) {
        if (Flag.FCS.in(flags) || Flag.CTX.in(flags) && this.exprs[0].has(Flag.CTX) || Flag.POS.in(flags) && this.exprs[0].has(Flag.POS)) {
            return true;
        }
        Flag[] flgs = Flag.POS.remove(Flag.CTX.remove(flags));
        return flgs.length != 0 && super.has(flgs);
    }

    @Override
    public final boolean accept(ASTVisitor visitor) {
        visitor.enterFocus();
        if (!SimpleMap.visitAll(visitor, this.exprs)) {
            return false;
        }
        visitor.exitFocus();
        return true;
    }

    @Override
    public final VarUsage count(Var var) {
        VarUsage uses = VarUsage.NEVER;
        if (var != null) {
            int el = this.exprs.length;
            for (int e = 1; e < el && (uses = uses.plus(this.exprs[e].count(var))) != VarUsage.MORE_THAN_ONCE; ++e) {
            }
        }
        return uses == VarUsage.NEVER ? this.exprs[0].count(var) : VarUsage.MORE_THAN_ONCE;
    }

    @Override
    public final boolean inlineable(InlineContext ic) {
        if (ic.expr instanceof ContextValue && ic.var != null) {
            int el = this.exprs.length;
            for (int e = 1; e < el; ++e) {
                if (!this.exprs[e].uses(ic.var)) continue;
                return false;
            }
        }
        return this.exprs[0].inlineable(ic);
    }

    @Override
    public final Expr inline(InlineContext ic) throws QueryException {
        boolean changed = false;
        CompileContext cc = ic.cc;
        int el = ic.var == null ? 1 : this.exprs.length;
        for (int e = 0; e < el; ++e) {
            Expr inlined;
            try {
                inlined = this.exprs[e].inline(ic);
            }
            catch (QueryException qe) {
                inlined = cc.error(qe, this.exprs[e]);
            }
            if (inlined != null) {
                this.exprs[e] = inlined;
                changed = true;
            } else {
                inlined = this.exprs[e];
            }
            if (e == 0) {
                cc.pushFocus(inlined);
                continue;
            }
            cc.updateFocus(inlined);
        }
        cc.removeFocus();
        return changed ? this.optimize(cc) : null;
    }

    @Override
    public void markTailCalls(CompileContext cc) {
        int el = this.exprs.length - 1;
        for (int e = 0; e < el; ++e) {
            if (this.exprs[e].seqType().zeroOrOne()) continue;
            return;
        }
        this.exprs[el].markTailCalls(cc);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof SimpleMap && super.equals(obj);
    }

    @Override
    public String description() {
        return "simple map";
    }

    @Override
    public void toString(QueryString qs) {
        qs.tokens(this.exprs, " ! ");
    }
}

