/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.And;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.Logical;
import org.basex.query.expr.Union;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.Path;
import org.basex.query.expr.path.Step;
import org.basex.query.expr.path.Test;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeIter;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.Util;

abstract class Set
extends Arr {
    boolean iterative;

    Set(InputInfo info, Expr[] exprs) {
        super(info, SeqType.NODE_ZM, exprs);
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        Expr expr = this.opt(cc);
        if (expr == null) {
            int el = this.exprs.length;
            if (el == 0) {
                return Empty.VALUE;
            }
            if (el == 1) {
                return cc.function(Function._UTIL_DDO, this.info, this.exprs[0]);
            }
            expr = this.mergePaths(cc);
            if (expr == null) {
                expr = this.mergeFilters(cc);
            }
        }
        if (expr != null) {
            return cc.replaceWith(this, expr);
        }
        this.iterative = ((Checks<Expr>)Expr::ddo).all((Expr[])this.exprs);
        return this;
    }

    abstract Expr opt(CompileContext var1) throws QueryException;

    @Override
    public final Iter iter(QueryContext qc) throws QueryException {
        return this.iterative ? this.iterate(qc) : this.nodes(qc).iter();
    }

    @Override
    public final Value value(QueryContext qc) throws QueryException {
        return this.iterative ? this.iterate(qc).value(qc, this) : this.nodes(qc);
    }

    final Iter[] iters(QueryContext qc) throws QueryException {
        int el = this.exprs.length;
        Iter[] iters = new Iter[el];
        for (int e = 0; e < el; ++e) {
            iters[e] = this.exprs[e].iter(qc);
        }
        return iters;
    }

    abstract Value nodes(QueryContext var1) throws QueryException;

    abstract Iter iterate(QueryContext var1) throws QueryException;

    private Expr mergePaths(CompileContext cc) throws QueryException {
        Step step;
        int s;
        Expr root = null;
        Axis axis = null;
        Test test = null;
        Object[] preds = null;
        ArrayList<Step> steps = new ArrayList<Step>(this.exprs.length);
        for (Expr expr : this.exprs) {
            if (!(expr instanceof Path)) {
                return null;
            }
            Path path = (Path)expr;
            if (path.steps.length != 1 || !(path.steps[0] instanceof Step)) {
                return null;
            }
            Step step2 = (Step)path.steps[0];
            if (steps.isEmpty()) {
                root = path.root;
                axis = step2.axis;
                if (root != null && root.has(Flag.CNS, Flag.NDT)) {
                    return null;
                }
            } else if (!Objects.equals(root, path.root) || axis != step2.axis) {
                return null;
            }
            steps.add(step2);
        }
        int sl = steps.size();
        if (this instanceof Union) {
            ArrayList<Test> tests = new ArrayList<Test>(sl);
            s = -1;
            while (++s < sl && !(step = (Step)steps.get(s)).mayBePositional()) {
                if (preds == null) {
                    preds = step.exprs;
                } else if (!Arrays.equals(preds, step.exprs)) break;
                tests.add(step.test);
            }
            if (s == sl) {
                test = Test.get((Test[])tests.toArray(Test[]::new));
            }
        }
        if (test == null) {
            Object[] objectArray;
            ExprList list = new ExprList(sl);
            s = -1;
            while (++s < sl && !(step = (Step)steps.get(s)).mayBePositional()) {
                if (test == null) {
                    test = step.test;
                } else if (!test.equals(step.test)) break;
                list.add(this.newPredicate(step.exprs, cc));
            }
            Expr merged = cc.get(root, () -> this.mergePredicates((Expr[])list.finish(), cc).optimize(cc));
            if (s == sl) {
                Expr[] exprArray = new Expr[1];
                objectArray = exprArray;
                exprArray[0] = merged;
            } else {
                objectArray = preds = null;
            }
        }
        if (test == null || preds == null) {
            return null;
        }
        Expr step3 = Step.get(cc, root, this.info, axis, test, preds);
        return Path.get(cc, this.info, root, step3);
    }

    private Expr mergeFilters(CompileContext cc) throws QueryException {
        Expr root = null;
        ExprList list = new ExprList();
        Expr[] exprArray = this.exprs;
        int n = exprArray.length;
        for (int i = 0; i < n; ++i) {
            Expr expr;
            Expr rt = expr = exprArray[i];
            Expr[] preds = new Expr[]{};
            if (expr instanceof Filter) {
                Filter filter = (Filter)expr;
                if (filter.mayBePositional()) {
                    return null;
                }
                rt = filter.root;
                preds = filter.exprs;
            }
            if (root == null ? (root = rt).has(Flag.CNS, Flag.NDT) || !(root.seqType().type instanceof NodeType) : !root.equals(rt)) {
                return null;
            }
            list.add(this.newPredicate(preds, cc));
        }
        Expr pred = this.mergePredicates((Expr[])list.finish(), cc).optimize(cc);
        return Filter.get(cc, this.info, root, pred);
    }

    private Expr newPredicate(Expr[] preds, CompileContext cc) throws QueryException {
        int el = preds.length;
        if (el == 0) {
            return Bln.TRUE;
        }
        if (el == 1) {
            return preds[0];
        }
        return new And(this.info, preds).optimize(cc);
    }

    abstract Logical mergePredicates(Expr[] var1, CompileContext var2) throws QueryException;

    @Override
    public final boolean ddo() {
        return true;
    }

    @Override
    public final void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "iterative", this.iterative), this.exprs);
    }

    @Override
    public final void toString(QueryString qs) {
        qs.tokens(this.exprs, " " + Util.className(this).toLowerCase(Locale.ENGLISH) + " ", true);
    }

    abstract class SetIter
    extends NodeIter {
        private final QueryContext qc;
        final Iter[] iter;
        ANode[] nodes;

        SetIter(QueryContext qc, Iter[] iter) {
            this.qc = qc;
            this.iter = iter;
        }

        final boolean next(int i) throws QueryException {
            Item item = this.qc.next(this.iter[i]);
            if (item == null) {
                this.nodes[i] = null;
                return false;
            }
            this.nodes[i] = Set.this.toNode(item);
            return true;
        }
    }
}

