/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.Arrays;
import java.util.function.Predicate;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryBiFunction;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryFocus;
import org.basex.query.QueryFunction;
import org.basex.query.QueryString;
import org.basex.query.QuerySupplier;
import org.basex.query.expr.And;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.IntPos;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.SimpleMap;
import org.basex.query.expr.ft.FTContains;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.Path;
import org.basex.query.expr.path.SingleIterPath;
import org.basex.query.expr.path.Step;
import org.basex.query.expr.path.Test;
import org.basex.query.func.Function;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public abstract class Preds
extends Arr {
    protected Preds(InputInfo info, SeqType seqType, Expr ... preds) {
        super(info, seqType, preds);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        Expr root = this.type(cc.qc.focus.value);
        int el = this.exprs.length;
        if (el != 0) {
            cc.get(this, () -> {
                long size;
                if (root != null && (size = root.size()) != -1L) {
                    cc.qc.focus.size = size;
                }
                for (int e = 0; e < el; ++e) {
                    this.exprs[e] = cc.compileOrError(this.exprs[e], false);
                    cc.qc.focus.size = 1L;
                }
                return null;
            });
        }
        return this.optimize(cc);
    }

    protected abstract Expr type(Expr var1);

    private boolean exprType(Expr root) {
        boolean exact;
        long max = root.size();
        boolean bl = exact = max != -1L;
        if (!exact) {
            max = Long.MAX_VALUE;
        }
        for (Expr expr : this.exprs) {
            if (expr instanceof Int || Function.LAST.is(expr)) {
                max = Math.min(max, 1L);
                continue;
            }
            if (expr instanceof IntPos) {
                IntPos pos = (IntPos)expr;
                if (max != Long.MAX_VALUE) {
                    max = Math.max(0L, max - pos.min + 1L);
                }
                max = Math.min(max, pos.max - pos.min + 1L);
                continue;
            }
            exact = false;
        }
        boolean empty = max == 0L;
        SeqType st = root.seqType();
        st = max == 1L ? st.with(Occ.ZERO_OR_ONE) : st.union(Occ.ZERO);
        this.exprType.assign(st, exact || empty ? max : -1L);
        return empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean match(Item item, QueryContext qc) throws QueryException {
        QueryFocus qf = qc.focus;
        Value qv = qf.value;
        qf.value = item;
        try {
            for (Expr expr : this.exprs) {
                if (expr.test(qc, this.info) != null) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            qf.value = qv;
        }
    }

    protected final boolean simplify(CompileContext cc, Expr root) throws QueryException {
        return cc.ok(root, () -> {
            ExprList list = new ExprList(this.exprs.length);
            for (Expr expr : this.exprs) {
                this.simplify(expr, list, root, cc);
            }
            this.exprs = (Expr[])list.finish();
            return this.optimizeEbv(false, true, cc);
        }) || this.exprType(root);
    }

    private void simplify(Expr pred, ExprList list, Expr root, CompileContext cc) throws QueryException {
        Axis axis;
        Expr[] mexprs;
        Expr expr = pred.simplifyFor(CompileContext.Simplify.PREDICATE, cc);
        SeqType rst = root.seqType();
        Predicate<Expr> first = f -> f instanceof ContextValue || root.equals(f) && root.isSimple() && rst.one();
        if (expr instanceof SimpleMap && first.test((mexprs = ((SimpleMap)expr).exprs)[0]) && !mexprs[1].has(Flag.POS)) {
            expr = SimpleMap.get(cc, expr.info(), Arrays.copyOfRange(mexprs, 1, mexprs.length));
        }
        if (expr instanceof Path && rst.type instanceof NodeType) {
            Path path = (Path)expr;
            if (first.test(path.root) && !path.steps[0].has(Flag.POS)) {
                expr = Path.get(cc, expr.info(), null, path.steps);
            }
        }
        if (root instanceof Item && !(rst.type instanceof NodeType)) {
            try {
                expr = new InlineContext(null, root, cc).inline(expr);
            }
            catch (QueryException ex) {
                expr = cc.error(ex, expr);
            }
        }
        if (expr instanceof SingleIterPath) {
            Step predStep = (Step)((Path)expr).steps[0];
            if (predStep.axis == Axis.SELF && !predStep.mayBePositional() && root instanceof Step && !this.mayBePositional()) {
                Step rootStep = (Step)root;
                Test test = rootStep.test.intersect(predStep.test);
                if (test != null) {
                    cc.info("merge: %", predStep);
                    rootStep.test = test;
                    rootStep.exprType.assign(Step.seqType(rootStep.axis, rootStep.test, rootStep.exprs));
                    list.add(predStep.exprs);
                    expr = Bln.TRUE;
                }
            }
        }
        if (root instanceof Step && ((axis = ((Step)root).axis) == Axis.SELF || axis == Axis.PARENT)) {
            if (expr instanceof Int) {
                expr = Bln.get(((Int)expr).itr() == 1L);
            } else if (expr instanceof IntPos) {
                expr = Bln.get(((IntPos)expr).min == 1L);
            }
        }
        if (expr instanceof And && !expr.has(Flag.POS)) {
            cc.info("rewrite to predicate: %", expr);
            for (Expr ex : expr.args()) {
                boolean numeric = ex.seqType().mayBeNumber();
                this.simplify(numeric ? cc.function(Function.BOOLEAN, this.info, ex) : ex, list, root, cc);
            }
            expr = Bln.TRUE;
        }
        if (expr != Bln.TRUE) {
            list.add(cc.simplify(pred, expr, CompileContext.Simplify.PREDICATE));
        }
    }

    public final Expr flattenEbv(Expr root, boolean ebv, CompileContext cc) throws QueryException {
        Expr expr;
        ParseExpr cmp;
        SeqType rst = root.seqType();
        int el = this.exprs.length;
        if (el == 0 || this.mayBePositional() || ebv && !(rst.type instanceof NodeType)) {
            return this;
        }
        Expr last = this.exprs[el - 1];
        QuerySupplier<Expr> createRoot = () -> root instanceof Path ? ((Path)root).removePredicate(cc) : (el > 1 ? Filter.get(cc, this.info, root, Arrays.copyOfRange(this.exprs, 0, el - 1)) : root);
        QueryFunction<Expr, Expr> createSimpleMap = rhs -> SimpleMap.get(cc, this.info, (Expr)createRoot.get(), rhs);
        QueryBiFunction<Expr, Boolean, Expr> createExpr = (rhs, compare) -> rhs instanceof ContextValue ? (Expr)createRoot.get() : (rhs instanceof Path ? Path.get(cc, this.info, (Expr)createRoot.get(), rhs) : (compare != false ? (Expr)createSimpleMap.apply((Expr)rhs) : this));
        if (last instanceof Cmp) {
            Expr expr2;
            cmp = (Cmp)last;
            Expr op1 = ((Cmp)cmp).exprs[0];
            Expr op2 = ((Cmp)cmp).exprs[1];
            SeqType st1 = op1.seqType();
            SeqType st2 = op2.seqType();
            Type type1 = st1.type;
            Type type2 = st2.type;
            if ((cmp instanceof CmpG || cmp instanceof CmpV && st1.zeroOrOne() && st2.zeroOrOne() && (type1 == type2 || type1.isStringOrUntyped() && type2.isStringOrUntyped())) && !op2.has(Flag.CTX) && (expr2 = createExpr.apply(op1, true)) != this) {
                return new CmpG(((Cmp)cmp).info, expr2, op2, ((Cmp)cmp).opG(), ((Cmp)cmp).coll, ((Cmp)cmp).sc).optimize(cc);
            }
        }
        if (last instanceof FTContains) {
            Expr expr3;
            cmp = (FTContains)last;
            FTExpr ftexpr = ((FTContains)cmp).ftexpr;
            if (!ftexpr.has(Flag.CTX) && (expr3 = createExpr.apply(((FTContains)cmp).expr, true)) != this) {
                return new FTContains(expr3, ftexpr, ((FTContains)cmp).info).optimize(cc);
            }
        }
        if (rst.type instanceof NodeType && (expr = createExpr.apply(last, false)) != this) {
            return expr;
        }
        if (rst.zeroOrOne()) {
            return createSimpleMap.apply(last);
        }
        return this;
    }

    protected static boolean numeric(Expr expr) {
        SeqType st = expr.seqType();
        return st.type.isNumber() && st.zeroOrOne() && expr.isSimple();
    }

    public boolean mayBePositional() {
        for (Expr expr : this.exprs) {
            if (!Preds.mayBePositional(expr)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        if (ic.expr instanceof ContextValue && ic.var != null) {
            for (Expr expr : this.exprs) {
                if (!expr.uses(ic.var)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void toString(QueryString qs) {
        for (Expr expr : this.exprs) {
            qs.bracket(expr);
        }
    }
}

