/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arith;
import org.basex.query.expr.Calc;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.IntPos;
import org.basex.query.expr.Range;
import org.basex.query.expr.SimplePos;
import org.basex.query.expr.Single;
import org.basex.query.func.Function;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

final class Pos
extends Single {
    private Pos(InputInfo info, Expr expr) {
        super(info, expr, SeqType.BOOLEAN_O);
    }

    static Expr get(Expr pos, CmpV.OpV op, InputInfo ii, CompileContext cc, boolean create) throws QueryException {
        Expr ps = pos.optimizePos(op, cc);
        if (ps instanceof Bln) {
            return ps;
        }
        Expr ex = IntPos.get(ps, op, ii);
        if (ex != null) {
            return ex;
        }
        if (op == CmpV.OpV.EQ && ps instanceof Range) {
            if (((Range)ps).ints) {
                if (ps.isSimple()) {
                    return new SimplePos(ii, ps.args());
                }
                if (create) {
                    return new Pos(ii, ps);
                }
            }
            return null;
        }
        Expr[] minMax = null;
        SeqType st = ps.seqType();
        Type type = st.type;
        if (st.one() && type.isNumberOrUntyped()) {
            switch (op) {
                case EQ: {
                    minMax = new Expr[]{ps, ps};
                    break;
                }
                case GE: {
                    minMax = new Expr[]{ps, Int.MAX};
                    break;
                }
                case GT: {
                    minMax = new Expr[]{new Arith(ii, type.instanceOf(AtomType.INTEGER) ? ps : cc.function(Function.FLOOR, ii, ps), (Expr)Int.ONE, Calc.PLUS).optimize(cc), Int.MAX};
                    break;
                }
                case LE: {
                    minMax = new Expr[]{Int.ONE, ps};
                    break;
                }
                case LT: {
                    minMax = new Expr[]{Int.ONE, new Arith(ii, type.instanceOf(AtomType.INTEGER) ? ps : cc.function(Function.CEILING, ii, ps), (Expr)Int.ONE, Calc.MINUS).optimize(cc)};
                    break;
                }
            }
        }
        if (minMax == null) {
            return null;
        }
        if (ps.isSimple()) {
            return new SimplePos(ii, minMax);
        }
        if (minMax[0] == minMax[1]) {
            return create ? new Pos(ii, minMax[0]) : null;
        }
        return type.instanceOf(AtomType.INTEGER) ? Pos.get(new Range(ii, minMax).optimize(cc), CmpV.OpV.EQ, ii, cc, create) : null;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.expr = this.expr.simplifyFor(CompileContext.Simplify.NUMBER, cc);
        Expr ex = Pos.get(this.expr, CmpV.OpV.EQ, this.info, cc, false);
        return ex != null ? cc.replaceWith(this, ex) : this;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        this.ctxValue(qc);
        Value value = this.expr.value(qc);
        if (value.isEmpty()) {
            return Bln.FALSE;
        }
        long pos = qc.focus.pos;
        long vs = value.size();
        double min = this.toDouble(value.itemAt(0L));
        double max = vs == 1L ? min : this.toDouble(value.itemAt(vs - 1L));
        return Bln.get((double)pos >= min && (double)pos <= max);
    }

    @Override
    public Pos copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Pos(this.info, this.expr.copy(cc, vm)));
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.POS.in(flags) || Flag.CTX.in(flags) || super.has(flags);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        return cc.simplify(this, mode == CompileContext.Simplify.PREDICATE && this.expr.seqType().instanceOf(SeqType.NUMERIC_O) ? this.expr : this, mode);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Pos && super.equals(obj);
    }

    @Override
    public String description() {
        return "positional access";
    }

    @Override
    public void toString(QueryString qs) {
        qs.function(Function.POSITION, new Object[0]).token("=").token(this.expr);
    }
}

