/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.expr.path.NameTest;
import org.basex.query.func.XQFunctionExpr;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.ExprType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public abstract class ParseExpr
extends Expr {
    public final ExprType exprType;
    protected InputInfo info;

    protected ParseExpr(InputInfo info, SeqType seqType) {
        this.info = info;
        this.exprType = new ExprType(seqType);
    }

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.item(qc, this.info);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.value(qc).item(qc, this.info);
    }

    @Override
    public final Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        return this.value(qc).atomValue(qc, this.info);
    }

    @Override
    public final Item ebv(QueryContext qc, InputInfo ii) throws QueryException {
        Item next;
        if (this.seqType().zeroOrOne()) {
            Item item = this.item(qc, this.info);
            return item.isEmpty() ? Bln.FALSE : item;
        }
        Iter iter = this.iter(qc);
        Item item = iter.next();
        if (item == null) {
            return Bln.FALSE;
        }
        if (!(item instanceof ANode) && (next = iter.next()) != null) {
            throw QueryError.ebvError(ValueBuilder.concat(item, next, qc), this.info);
        }
        return item;
    }

    @Override
    public final Item test(QueryContext qc, InputInfo ii) throws QueryException {
        Item item = this.ebv(qc, this.info);
        return (item instanceof ANum ? item.dbl(this.info) == (double)qc.focus.pos : item.bool(this.info)) ? item : null;
    }

    @Override
    public final SeqType seqType() {
        return this.exprType.seqType();
    }

    @Override
    public final long size() {
        return this.exprType.size();
    }

    @Override
    public Data data() {
        return this.exprType.data();
    }

    @Override
    public final void refineType(Expr expr) {
        this.exprType.refine(expr);
    }

    @Override
    public InputInfo info() {
        return this.info;
    }

    public final <T extends Expr> T copyType(T expr) {
        if (expr instanceof ParseExpr) {
            ((ParseExpr)expr).exprType.assign(this);
        }
        return expr;
    }

    public final ParseExpr adoptType(Expr expr) {
        this.exprType.assign(expr);
        return this;
    }

    protected final <T extends XQFunctionExpr> T checkUp(T expr, boolean updating, StaticContext sc) throws QueryException {
        if (!sc.mixUpdates && updating != expr.annotations().contains(Annotation.UPDATING)) {
            if (!updating) {
                throw QueryError.FUNCUP_X.get(this.info, expr);
            }
            if (!expr.vacuousBody()) {
                throw QueryError.FUNCNOTUP_X.get(this.info, expr);
            }
        }
        return expr;
    }

    protected final void checkNoUp(Expr expr) throws QueryException {
        if (expr == null) {
            return;
        }
        expr.checkUp();
        if (expr.has(Flag.UPD)) {
            throw QueryError.UPNOT_X.get(this.info, this.description());
        }
    }

    protected final void checkNoneUp(Expr ... exprs) throws QueryException {
        if (exprs == null) {
            return;
        }
        this.checkAllUp(exprs);
        for (Expr expr : exprs) {
            if (!expr.has(Flag.UPD)) continue;
            throw QueryError.UPNOT_X.get(this.info, this.description());
        }
    }

    protected final void checkAllUp(Expr ... exprs) throws QueryException {
        int state = 0;
        for (Expr expr : exprs) {
            expr.checkUp();
            if (expr.vacuous()) continue;
            boolean updating = expr.has(Flag.UPD);
            if (updating ? state == -1 : state == 1) {
                throw QueryError.UPALL.get(this.info, new Object[0]);
            }
            state = updating ? 1 : -1;
        }
    }

    protected final Value ctxValue(QueryContext qc) throws QueryException {
        Value value = qc.focus.value;
        if (value != null) {
            return value;
        }
        throw QueryError.NOCTX_X.get(this.info, this);
    }

    protected final byte[] toToken(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        if (item.isEmpty()) {
            throw QueryError.EMPTYFOUND_X.get(this.info, AtomType.STRING);
        }
        return this.toToken(item);
    }

    protected final byte[] toZeroToken(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return item.isEmpty() ? Token.EMPTY : this.toToken(item);
    }

    protected final byte[] toTokenOrNull(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return item.isEmpty() ? null : this.toToken(item);
    }

    protected final byte[] toToken(Item item) throws QueryException {
        Type type = item.type;
        if (type.isStringOrUntyped()) {
            return item.string(this.info);
        }
        throw item instanceof FItem ? QueryError.FIATOMIZE_X.get(this.info, item) : QueryError.typeError(item, AtomType.STRING, this.info);
    }

    protected final String toString(Expr expr, QueryContext qc) throws QueryException {
        return Token.string(this.toToken(expr, qc));
    }

    protected final String toString(Item item) throws QueryException {
        return Token.string(this.toToken(item));
    }

    protected final String toStringOrNull(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return item.isEmpty() ? null : this.toString(item);
    }

    protected final boolean toBoolean(Expr expr, QueryContext qc) throws QueryException {
        return this.toBoolean(expr.atomItem(qc, this.info));
    }

    protected final boolean toBooleanOrFalse(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return !item.isEmpty() && this.toBoolean(item);
    }

    protected final boolean toBoolean(Item item) throws QueryException {
        Type type = this.checkNoEmpty((Item)item, (Type)AtomType.BOOLEAN).type;
        if (type == AtomType.BOOLEAN) {
            return item.bool(this.info);
        }
        if (type.isUntyped()) {
            return Bln.parse(item, this.info);
        }
        throw QueryError.typeError(item, AtomType.BOOLEAN, this.info);
    }

    protected final double toDouble(Expr expr, QueryContext qc) throws QueryException {
        return this.toDouble(expr.atomItem(qc, this.info));
    }

    protected final double toDouble(Item item) throws QueryException {
        if (this.checkNoEmpty((Item)item, (Type)AtomType.DOUBLE).type.isNumberOrUntyped()) {
            return item.dbl(this.info);
        }
        throw QueryError.numberError(this, item);
    }

    protected final ANum toNumberOrNull(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return item.isEmpty() ? null : this.toNumber(item);
    }

    protected final ANum toNumber(Item item) throws QueryException {
        if (item.type.isUntyped()) {
            return Dbl.get(item.dbl(this.info));
        }
        if (item instanceof ANum) {
            return (ANum)item;
        }
        throw QueryError.numberError(this, item);
    }

    protected final float toFloat(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        if (this.checkNoEmpty((Item)item, (Type)AtomType.FLOAT).type.isNumberOrUntyped()) {
            return item.flt(this.info);
        }
        throw QueryError.numberError(this, item);
    }

    protected final long toLong(Expr expr, QueryContext qc) throws QueryException {
        return this.toLong(expr.atomItem(qc, this.info));
    }

    protected final long toLong(Item item) throws QueryException {
        Type type = this.checkNoEmpty((Item)item, (Type)AtomType.INTEGER).type;
        if (type.instanceOf(AtomType.INTEGER) || type.isUntyped()) {
            return item.itr(this.info);
        }
        throw QueryError.typeError(item, AtomType.INTEGER, this.info);
    }

    protected final ANode toNode(Expr expr, QueryContext qc) throws QueryException {
        return this.toNode(this.checkNoEmpty(expr.item(qc, this.info), NodeType.NODE));
    }

    protected final ANode toNodeOrNull(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.item(qc, this.info);
        return item.isEmpty() ? null : this.toNode(item);
    }

    protected final ANode toNode(Item item) throws QueryException {
        if (item instanceof ANode) {
            return (ANode)item;
        }
        throw QueryError.typeError(item, NodeType.NODE, this.info);
    }

    protected final Item toItem(Expr expr, QueryContext qc) throws QueryException {
        return this.checkNoEmpty(expr.item(qc, this.info));
    }

    protected final Item toItem(Expr expr, QueryContext qc, Type type) throws QueryException {
        return this.checkNoEmpty(expr.item(qc, this.info), type);
    }

    protected final Item toAtomItem(Expr expr, QueryContext qc) throws QueryException {
        return this.checkNoEmpty(expr.atomItem(qc, this.info));
    }

    protected final ANode toElem(Expr expr, QueryContext qc) throws QueryException {
        return (ANode)this.checkType(expr.item(qc, this.info), NodeType.ELEMENT);
    }

    protected final ANode toElem(Expr expr, QNm name, QueryContext qc, QueryError error) throws QueryException {
        ANode node = this.toElem(expr, qc);
        if (new NameTest(name).matches(node)) {
            return node;
        }
        throw error.get(this.info, name.prefixId(), node.type, node);
    }

    protected final Bin toBin(Expr expr, QueryContext qc) throws QueryException {
        return this.toBin(expr.atomItem(qc, this.info));
    }

    protected final Bin toBin(Item item) throws QueryException {
        if (this.checkNoEmpty(item) instanceof Bin) {
            return (Bin)item;
        }
        throw QueryError.BINARY_X.get(this.info, item.type);
    }

    protected final byte[] toBytes(Expr expr, QueryContext qc) throws QueryException {
        return this.toBytes(expr.atomItem(qc, this.info));
    }

    protected final B64 toB64(Expr expr, QueryContext qc) throws QueryException {
        return this.toB64(expr.atomItem(qc, this.info));
    }

    protected final B64 toB64OrNull(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return item.isEmpty() ? null : this.toB64(item);
    }

    protected final B64 toB64(Item item) throws QueryException {
        return (B64)this.checkType(item, AtomType.BASE64_BINARY);
    }

    protected final byte[] toBytes(Item item) throws QueryException {
        if (this.checkNoEmpty((Item)item).type.isStringOrUntyped()) {
            return item.string(this.info);
        }
        if (item instanceof Bin) {
            return ((Bin)item).binary(this.info);
        }
        throw QueryError.STRBIN_X_X.get(this.info, item.type, item);
    }

    protected final QNm toQNmOrNull(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return item.isEmpty() ? null : this.toQNm(item);
    }

    protected final QNm toQNm(Item item) throws QueryException {
        Type type = this.checkNoEmpty((Item)item, (Type)AtomType.QNAME).type;
        if (type == AtomType.QNAME) {
            return (QNm)item;
        }
        if (type.isUntyped()) {
            throw QueryError.NSSENS_X_X.get(this.info, type, AtomType.QNAME);
        }
        throw QueryError.typeError(item, AtomType.QNAME, this.info);
    }

    protected final FItem toFunction(Expr expr, QueryContext qc) throws QueryException {
        return (FItem)this.checkType(this.toItem(expr, qc, SeqType.FUNCTION), SeqType.FUNCTION);
    }

    protected final XQMap toMap(Expr expr, QueryContext qc) throws QueryException {
        return this.toMap(this.toItem(expr, qc, SeqType.MAP));
    }

    protected final XQMap toMap(Item item) throws QueryException {
        if (item instanceof XQMap) {
            return (XQMap)item;
        }
        throw QueryError.typeError(item, SeqType.MAP, this.info);
    }

    protected final XQMap toRecord(Item item, AStr ... keys) throws QueryException {
        XQMap map = this.toMap(item);
        for (AStr key : keys) {
            if (map.contains(key, this.info)) continue;
            throw QueryError.INVCONVERT_X_X_X.get(this.info, item.type, "record()", item);
        }
        return map;
    }

    protected final XQArray toArray(Expr expr, QueryContext qc) throws QueryException {
        return this.toArray(this.toItem(expr, qc, SeqType.ARRAY));
    }

    protected final XQArray toArray(Item item) throws QueryException {
        if (item instanceof XQArray) {
            return (XQArray)item;
        }
        throw QueryError.typeError(item, SeqType.ARRAY, this.info);
    }

    protected final Item checkType(Expr expr, AtomType type, QueryContext qc) throws QueryException {
        return this.checkType(expr.atomItem(qc, this.info), type);
    }

    protected final Item checkType(Item item, Type type) throws QueryException {
        if (this.checkNoEmpty((Item)item, (Type)type).type.instanceOf(type)) {
            return item;
        }
        throw QueryError.typeError(item, type, this.info);
    }

    protected final Item checkNoEmpty(Item item) throws QueryException {
        if (item.isEmpty()) {
            throw QueryError.EMPTYFOUND.get(this.info, new Object[0]);
        }
        return item;
    }

    protected final Item checkNoEmpty(Item item, Type type) throws QueryException {
        if (item.isEmpty()) {
            throw QueryError.EMPTYFOUND_X.get(this.info, type);
        }
        return item;
    }
}

