/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Logical;
import org.basex.query.expr.Union;
import org.basex.query.util.index.IndexCosts;
import org.basex.query.util.index.IndexInfo;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Or
extends Logical {
    public Or(InputInfo info, Expr ... exprs) {
        super(info, exprs);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.flatten(cc);
        return this.optimize(cc, true);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        for (Expr expr : this.exprs) {
            if (!expr.ebv(qc, this.info).bool(this.info)) continue;
            return Bln.TRUE;
        }
        return Bln.FALSE;
    }

    @Override
    public Or copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Or(this.info, Or.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public boolean indexAccessible(IndexInfo ii) throws QueryException {
        IndexCosts costs = IndexCosts.ZERO;
        ExprList list = new ExprList(this.exprs.length);
        for (Expr expr : this.exprs) {
            if (!expr.indexAccessible(ii)) {
                return false;
            }
            if (ii.costs.results() == 0) continue;
            costs = IndexCosts.add(costs, ii.costs);
            list.add(ii.expr);
        }
        ii.costs = costs;
        ii.expr = list.size() == 1 ? (Expr)list.get(0) : new Union(this.info, (Expr[])list.finish()).optimize(ii.cc);
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Or && super.equals(obj);
    }

    @Override
    public void toString(QueryString qs) {
        qs.tokens(this.exprs, " or ", true);
    }
}

