/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryBiFunction;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.SimpleMap;
import org.basex.query.expr.gflwor.For;
import org.basex.query.expr.gflwor.GFLWOR;
import org.basex.query.func.DynFuncCall;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.XQData;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.util.InputInfo;
import org.basex.util.XMLToken;
import org.basex.util.hash.IntObjMap;

public final class Lookup
extends Arr {
    public static final Str WILDCARD = Str.get(new byte[]{42});

    public Lookup(InputInfo info, Expr ... expr) {
        super(info, SeqType.ITEM_ZM, expr);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.exprs[1] = this.exprs[1].simplifyFor(CompileContext.Simplify.DATA, cc);
        Expr inputs = this.exprs[0];
        long is = inputs.size();
        if (is == 0L) {
            return cc.replaceWith(this, inputs);
        }
        FuncType ft = inputs.funcType();
        boolean map = ft instanceof MapType;
        boolean array = ft instanceof ArrayType;
        if (!map && !array) {
            return this;
        }
        Expr expr = this.opt(cc);
        if (expr != this) {
            return cc.replaceWith(this, expr);
        }
        Expr keys = this.exprs[1];
        SeqType st = ft.declType;
        SeqType kt = keys.seqType();
        Occ occ = st.occ;
        if (inputs.size() != 1L || keys == WILDCARD || !kt.one() || kt.mayBeArray()) {
            occ = occ.union(Occ.ZERO_OR_MORE);
        } else if (map) {
            occ = occ.union(Occ.ZERO);
        }
        this.exprType.assign(st.type, occ);
        return this;
    }

    private Expr opt(CompileContext cc) throws QueryException {
        long ks;
        Expr input = this.exprs[0];
        Expr keys = this.exprs[1];
        long l = ks = keys.seqType().mayBeArray() || keys.has(Flag.NDT) ? -1L : keys.size();
        if (ks == 0L) {
            return keys;
        }
        long is = input.size();
        QueryBiFunction<Expr, Expr, Expr> rewrite = (in, arg) -> keys == WILDCARD ? cc.function(input.funcType() instanceof MapType ? Function._MAP_VALUES : Function._ARRAY_VALUES, this.info, (Expr)in) : new DynFuncCall(this.info, cc.sc(), (Expr)in, (Expr)arg).optimize(cc);
        if (ks == 1L) {
            if (is == 1L) {
                return rewrite.apply(input, keys);
            }
            Expr ex = cc.get(input, () -> (Expr)rewrite.apply(ContextValue.get(cc, this.info), keys));
            return SimpleMap.get(cc, this.info, input, ex);
        }
        if (ks != -1L && (input instanceof Value || input instanceof VarRef)) {
            if (is == 1L) {
                Expr ex = cc.get(keys, () -> (Expr)rewrite.apply(input, ContextValue.get(cc, this.info)));
                return SimpleMap.get(cc, this.info, keys, ex);
            }
            Var var = cc.vs().addNew(new QNm("_"), null, false, cc.qc, this.info);
            For fr = new For(var, input).optimize(cc);
            Expr ex = cc.get(keys, () -> (Expr)rewrite.apply(new VarRef(this.info, var).optimize(cc), ContextValue.get(cc, this.info)));
            return new GFLWOR(this.info, fr, SimpleMap.get(cc, this.info, keys, ex)).optimize(cc);
        }
        return this;
    }

    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        return new Iter(){
            final Iter iter;
            Iter ir;
            {
                this.iter = Lookup.this.exprs[0].iter(qc);
            }

            @Override
            public Item next() throws QueryException {
                Item item;
                while (this.ir == null || (item = qc.next(this.ir)) == null) {
                    item = qc.next(this.iter);
                    if (item == null) {
                        return null;
                    }
                    this.ir = Lookup.this.add(item, new ValueBuilder(qc), qc).value(Lookup.this).iter();
                }
                return item;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Item item;
        ValueBuilder vb = new ValueBuilder(qc);
        Iter iter = this.exprs[0].iter(qc);
        while ((item = qc.next(iter)) != null) {
            this.add(item, vb, qc);
        }
        return vb.value(this);
    }

    private ValueBuilder add(Item item, ValueBuilder vb, QueryContext qc) throws QueryException {
        if (!(item instanceof XQData)) {
            throw QueryError.LOOKUP_X.get(this.info, item);
        }
        Expr keys = this.exprs[1];
        if (keys == WILDCARD) {
            if (item instanceof XQMap) {
                ((XQMap)item).values(vb);
            } else {
                for (Value member : ((XQArray)item).members()) {
                    vb.add(member);
                }
            }
        } else {
            Item key;
            FItem fitem = (FItem)item;
            Iter ir = keys.atomIter(qc, this.info);
            while ((key = ir.next()) != null) {
                vb.add(fitem.invoke(qc, this.info, key));
            }
        }
        return vb;
    }

    @Override
    public Lookup copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Lookup(this.info, Lookup.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Lookup && super.equals(obj);
    }

    @Override
    public void toString(QueryString qs) {
        long l;
        qs.token(this.exprs[0]).token('?');
        Expr keys = this.exprs[1];
        Object key = null;
        if (keys == WILDCARD) {
            key = WILDCARD.string();
        } else if (keys instanceof Str) {
            Str str = (Str)keys;
            if (XMLToken.isNCName(str.string())) {
                key = str.toJava();
            }
        } else if (keys instanceof Int && (l = ((Int)keys).itr()) >= 0L) {
            key = l;
        }
        if (key != null) {
            qs.token(key);
        } else {
            qs.paren(keys);
        }
    }
}

