/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class Concat
extends Arr {
    public Concat(InputInfo info, Expr ... exprs) {
        super(info, SeqType.STRING_O, exprs);
    }

    @Override
    public Str item(QueryContext qc, InputInfo ii) throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        for (Expr expr : this.exprs) {
            Item item = expr.atomItem(qc, this.info);
            if (item.isEmpty()) continue;
            tb.add(item.string(this.info));
        }
        return Str.get(tb.finish());
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        int ls;
        int el = this.exprs.length;
        ExprList list = new ExprList(el);
        TokenBuilder tb = new TokenBuilder();
        for (Expr expr : this.exprs) {
            if (expr instanceof Value) {
                Item item = expr.atomItem(cc.qc, this.info);
                if (item.isEmpty()) continue;
                tb.add(item.string(this.info));
                continue;
            }
            if (!tb.isEmpty()) {
                list.add(Str.get(tb.next()));
            }
            list.add(expr);
        }
        if (list.isEmpty()) {
            return cc.replaceWith(this, Str.get(tb.finish()));
        }
        if (!tb.isEmpty()) {
            list.add(Str.get(tb.finish()));
        }
        if ((ls = list.size()) == 1) {
            return cc.replaceWith(this, cc.function(Function.STRING, this.info, (Expr)list.peek()));
        }
        if (ls != el) {
            cc.info("merge: %", this);
        }
        this.exprs = (Expr[])list.finish();
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Concat && super.equals(obj);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Concat(this.info, Concat.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public void toString(QueryString qs) {
        qs.tokens(this.exprs, " || ", true);
    }
}

