/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.function.Predicate;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.Expr;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class CmpV
extends Cmp {
    private OpV opV;

    public CmpV(InputInfo info, Expr expr1, Expr expr2, OpV opV, Collation coll, StaticContext sc) {
        super(info, expr1, expr2, coll, SeqType.BOOLEAN_ZO, sc);
        this.opV = opV;
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        Expr expr;
        this.exprs = this.simplifyAll(CompileContext.Simplify.STRING, cc);
        if (this.allAreValues(false)) {
            return cc.preEval(this);
        }
        if (this.swap()) {
            cc.info("swap operands: %", this);
            this.opV = this.opV.swap();
        }
        if ((expr = this.emptyExpr()) == this) {
            expr = this.toGeneral(cc, true);
        }
        if (expr == this) {
            expr = this.opt(cc);
        }
        if (expr == this) {
            SeqType st1 = this.exprs[0].seqType();
            SeqType st2 = this.exprs[1].seqType();
            if (st1.oneOrMore() && !st1.mayBeArray() && st2.oneOrMore() && !st2.mayBeArray()) {
                this.exprType.assign(Occ.EXACTLY_ONE);
            }
        }
        return cc.replaceWith(this, expr);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        return cc.simplify(this, mode.oneOf(CompileContext.Simplify.EBV, CompileContext.Simplify.PREDICATE) ? this.toGeneral(cc, false) : this, mode);
    }

    private Expr toGeneral(CompileContext cc, boolean single) throws QueryException {
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        SeqType st1 = expr1.seqType();
        SeqType st2 = expr2.seqType();
        Predicate<SeqType> p = st -> single ? st.one() : st.zeroOrOne();
        if (p.test(st1) && p.test(st2) && CmpG.compatible(st1, st2, this.opV == OpV.EQ || this.opV == OpV.NE)) {
            return new CmpG(this.info, expr1, expr2, CmpG.OpG.get(this.opV), this.coll, this.sc).optimize(cc);
        }
        return this;
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item1 = this.exprs[0].atomItem(qc, this.info);
        if (item1.isEmpty()) {
            return Empty.VALUE;
        }
        Item item2 = this.exprs[1].atomItem(qc, this.info);
        if (item2.isEmpty()) {
            return Empty.VALUE;
        }
        if (item1.comparable(item2)) {
            return Bln.get(this.opV.eval(item1, item2, this.coll, this.sc, this.info));
        }
        throw QueryError.diffError(item1, item2, this.info);
    }

    @Override
    public Expr invert() {
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        SeqType st1 = expr1.seqType();
        SeqType st2 = expr2.seqType();
        return st1.one() && !st1.mayBeArray() && st2.one() && !st2.mayBeArray() ? new CmpV(this.info, expr1, expr2, this.opV.invert(), this.coll, this.sc) : null;
    }

    @Override
    public OpV opV() {
        return this.opV;
    }

    @Override
    public CmpG.OpG opG() {
        return this.opV.general();
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new CmpV(this.info, this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm), this.opV, this.coll, this.sc));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof CmpV && this.opV == ((CmpV)obj).opV && super.equals(obj);
    }

    @Override
    public String description() {
        return "'" + this.opV + "' comparison";
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "op", this.opV.name), this.exprs);
    }

    @Override
    public void toString(QueryString qs) {
        qs.tokens(this.exprs, " " + this.opV + " ", true);
    }

    public static enum OpV {
        LE("le"){

            @Override
            public boolean eval(Item item1, Item item2, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
                int v = item1.diff(item2, coll, ii);
                return v != Integer.MIN_VALUE && v <= 0;
            }

            @Override
            public OpV swap() {
                return GE;
            }

            @Override
            public OpV invert() {
                return GT;
            }

            @Override
            public CmpG.OpG general() {
                return CmpG.OpG.LE;
            }
        }
        ,
        LT("lt"){

            @Override
            public boolean eval(Item item1, Item item2, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
                int v = item1.diff(item2, coll, ii);
                return v != Integer.MIN_VALUE && v < 0;
            }

            @Override
            public OpV swap() {
                return GT;
            }

            @Override
            public OpV invert() {
                return GE;
            }

            @Override
            public CmpG.OpG general() {
                return CmpG.OpG.LT;
            }
        }
        ,
        GE("ge"){

            @Override
            public boolean eval(Item item1, Item item2, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
                return item1.diff(item2, coll, ii) >= 0;
            }

            @Override
            public OpV swap() {
                return LE;
            }

            @Override
            public OpV invert() {
                return LT;
            }

            @Override
            public CmpG.OpG general() {
                return CmpG.OpG.GE;
            }
        }
        ,
        GT("gt"){

            @Override
            public boolean eval(Item item1, Item item2, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
                return item1.diff(item2, coll, ii) > 0;
            }

            @Override
            public OpV swap() {
                return LT;
            }

            @Override
            public OpV invert() {
                return LE;
            }

            @Override
            public CmpG.OpG general() {
                return CmpG.OpG.GT;
            }
        }
        ,
        EQ("eq"){

            @Override
            public boolean eval(Item item1, Item item2, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
                return item1.eq(item2, coll, sc, ii);
            }

            @Override
            public OpV swap() {
                return EQ;
            }

            @Override
            public OpV invert() {
                return NE;
            }

            @Override
            public CmpG.OpG general() {
                return CmpG.OpG.EQ;
            }
        }
        ,
        NE("ne"){

            @Override
            public boolean eval(Item item1, Item item2, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
                return !item1.eq(item2, coll, sc, ii);
            }

            @Override
            public OpV swap() {
                return NE;
            }

            @Override
            public OpV invert() {
                return EQ;
            }

            @Override
            public CmpG.OpG general() {
                return CmpG.OpG.NE;
            }
        };

        public static final OpV[] VALUES;
        public final String name;

        private OpV(String name) {
            this.name = name;
        }

        public abstract boolean eval(Item var1, Item var2, Collation var3, StaticContext var4, InputInfo var5) throws QueryException;

        public abstract OpV swap();

        public abstract OpV invert();

        public abstract CmpG.OpG general();

        public String toString() {
            return this.name;
        }

        static {
            VALUES = OpV.values();
        }
    }
}

