/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.IntPos;
import org.basex.query.expr.Range;
import org.basex.query.expr.Single;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class CmpIR
extends Single {
    public final long min;
    public final long max;
    private boolean single;

    private CmpIR(Expr expr, long min, long max, InputInfo info) {
        super(info, expr, SeqType.BOOLEAN_O);
        this.min = min;
        this.max = max;
    }

    static Expr get(CompileContext cc, InputInfo info, Expr expr, long min, long max) throws QueryException {
        return min > max ? Bln.FALSE : (min == Long.MIN_VALUE && max == Long.MAX_VALUE ? cc.function(Function.EXISTS, info, expr) : new CmpIR(expr, min, max, info).optimize(cc));
    }

    public static Expr get(CompileContext cc, CmpG cmp, boolean eq) throws QueryException {
        long mx;
        long mn;
        boolean cmpEq;
        Expr expr1 = cmp.exprs[0];
        Expr expr2 = cmp.exprs[1];
        if (cmp.has(Flag.NDT)) {
            return cmp;
        }
        Type type1 = expr1.seqType().type;
        boolean bl = cmpEq = cmp.op == CmpG.OpG.EQ;
        if (!(type1.instanceOf(AtomType.INTEGER) || cmpEq && type1.isUntyped())) {
            return cmp;
        }
        if (expr2 instanceof RangeSeq) {
            long[] range = ((RangeSeq)expr2).range(false);
            mn = range[0];
            mx = range[1];
        } else if (expr2 instanceof Int && (eq || !cmpEq)) {
            mx = mn = ((Int)expr2).itr();
        } else {
            return cmp;
        }
        switch (cmp.op) {
            case GE: {
                mx = Long.MAX_VALUE;
                break;
            }
            case GT: {
                ++mn;
                mx = Long.MAX_VALUE;
                break;
            }
            case LE: {
                mn = Long.MIN_VALUE;
                break;
            }
            case LT: {
                mn = Long.MIN_VALUE;
                --mx;
                break;
            }
            case EQ: {
                break;
            }
            default: {
                return cmp;
            }
        }
        return CmpIR.get(cc, cmp.info, expr1, mn, mx);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.expr = this.expr.simplifyFor(CompileContext.Simplify.NUMBER, cc);
        SeqType st = this.expr.seqType();
        boolean bl = this.single = st.zeroOrOne() && !st.mayBeArray();
        if (this.expr instanceof Value) {
            return cc.preEval(this);
        }
        if (Function.POSITION.is(this.expr)) {
            long size;
            long mn = Math.max(this.min, 1L);
            Expr pos = RangeSeq.get(mn, size = this.max - mn + 1L, true).optimizePos(CmpV.OpV.EQ, cc);
            return cc.replaceWith(this, pos instanceof Bln ? pos : IntPos.get(pos, CmpV.OpV.EQ, this.info));
        }
        return this;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        if (this.single) {
            Item item2 = this.expr.item(qc, this.info);
            return Bln.get(!item2.isEmpty() && this.inRange(item2));
        }
        if (this.expr instanceof Range || this.expr instanceof RangeSeq) {
            Value value = this.expr.value(qc);
            long size = value.size();
            if (size == 0L) {
                return Bln.FALSE;
            }
            if (size == 1L) {
                return Bln.get(this.inRange((Item)value));
            }
            long[] range = ((RangeSeq)value).range(false);
            return Bln.get(range[1] >= this.min && range[0] <= this.max);
        }
        Iter iter = this.expr.atomIter(qc, this.info);
        while ((item = qc.next(iter)) != null) {
            if (!this.inRange(item)) continue;
            return Bln.TRUE;
        }
        return Bln.FALSE;
    }

    private boolean inRange(Item item) throws QueryException {
        double value = item.dbl(this.info);
        return value >= (double)this.min && value <= (double)this.max && value == (double)((long)value);
    }

    @Override
    public Expr mergeEbv(Expr ex, boolean or, CompileContext cc) throws QueryException {
        Long newMin = null;
        Long newMax = null;
        if (ex instanceof CmpIR) {
            CmpIR cmp = (CmpIR)ex;
            newMin = cmp.min;
            newMax = cmp.max;
        } else if (ex instanceof CmpG && ((CmpG)ex).op == CmpG.OpG.EQ && ex.arg(1) instanceof Int) {
            newMax = newMin = Long.valueOf(((Int)ex.arg(1)).itr());
        }
        if (newMin == null || !this.expr.equals(ex.arg(0)) || or && (this.max < newMin || this.min > newMax)) {
            return null;
        }
        newMin = or ? Math.min(this.min, newMin) : Math.max(this.min, newMin);
        newMax = or ? Math.max(this.max, newMax) : Math.min(this.max, newMax);
        return CmpIR.get(cc, this.info, this.expr, newMin, newMax);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        CmpIR cmp = new CmpIR(this.expr.copy(cc, vm), this.min, this.max, this.info);
        cmp.single = this.single;
        return this.copyType(cmp);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CmpIR)) {
            return false;
        }
        CmpIR c = (CmpIR)obj;
        return this.min == c.min && this.max == c.max && super.equals(obj);
    }

    @Override
    public String description() {
        return "integer range comparison";
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "min", this.min, "max", this.max, "single", this.single), this.expr);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.expr);
        if (this.min == this.max) {
            qs.token("=").token(this.min);
        } else if (this.min != Long.MIN_VALUE && this.max != Long.MAX_VALUE) {
            qs.token("=").token(this.min).token("to").token(this.max);
        } else if (this.min != Long.MIN_VALUE) {
            qs.token(">=").token(this.min);
        } else {
            qs.token("<=").token(this.max);
        }
    }
}

