/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.ArrayList;
import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryFunction;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Arith;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpHashG;
import org.basex.query.expr.CmpIR;
import org.basex.query.expr.CmpR;
import org.basex.query.expr.CmpSR;
import org.basex.query.expr.CmpSimpleG;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.expr.Single;
import org.basex.query.expr.Union;
import org.basex.query.expr.path.NamePart;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.Path;
import org.basex.query.expr.path.Step;
import org.basex.query.func.Function;
import org.basex.query.func.fn.ContextFn;
import org.basex.query.func.fn.FnTokenize;
import org.basex.query.iter.Iter;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.index.IndexInfo;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.hash.IntObjMap;

public class CmpG
extends Cmp {
    OpG op;
    boolean check = true;

    public CmpG(InputInfo info, Expr expr1, Expr expr2, OpG op, Collation coll, StaticContext sc) {
        super(info, expr1, expr2, coll, SeqType.BOOLEAN_O, sc);
        this.op = op;
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        Expr expr = this.emptyExpr();
        if (expr != this) {
            return cc.replaceWith(this, cc.function(Function.BOOLEAN, this.info, expr));
        }
        AtomType t1 = this.exprs[0].seqType().type.atomic();
        AtomType t2 = this.exprs[1].seqType().type.atomic();
        if (t1 != null && t2 != null) {
            if (t1.isStringOrUntyped() && t2.isStringOrUntyped()) {
                this.exprs = this.simplifyAll(CompileContext.Simplify.STRING, cc);
            } else if (t1.isNumber() && t2.isNumber()) {
                this.exprs = this.simplifyAll(CompileContext.Simplify.NUMBER, cc);
            }
        }
        this.exprs = this.simplifyAll(CompileContext.Simplify.DISTINCT, cc);
        if (this.swap()) {
            cc.info("swap operands: %", this);
            this.op = this.op.swap();
        }
        if ((expr = this.opt(cc)) == this) {
            expr = this.optArith(cc);
        }
        if (expr == this) {
            expr = CmpIR.get(cc, this, false);
        }
        if (expr == this) {
            expr = CmpR.get(cc, this);
        }
        if (expr == this) {
            expr = CmpSR.get(cc, this);
        }
        if (expr == this) {
            Expr expr1 = this.exprs[0];
            Expr expr2 = this.exprs[1];
            SeqType st1 = expr1.seqType();
            SeqType st2 = expr2.seqType();
            Type type1 = st1.type;
            Type type2 = st2.type;
            this.check = (type1 != type2 || AtomType.ANY_ATOMIC_TYPE.instanceOf(type1) || !type1.isSortable() && this.op.oneOf(OpG.EQ, OpG.NE)) && !CmpG.comparable(type1, type2);
            CmpHashG hash = null;
            if (st1.zeroOrOne() && !st1.mayBeArray() && st2.zeroOrOne() && !st2.mayBeArray()) {
                if (!(this instanceof CmpSimpleG)) {
                    expr = new CmpSimpleG(expr1, expr2, this.op, this.coll, this.sc, this.info, this.check);
                }
            } else if (this.op == OpG.EQ && this.coll == null && (type1.isNumber() && type2.isNumber() || type1.isStringOrUntyped() && type2.isStringOrUntyped()) && !st2.zeroOrOne()) {
                hash = this instanceof CmpHashG ? (CmpHashG)this : new CmpHashG(expr1, expr2, this.op, this.sc, this.info);
                expr = hash;
            }
            if (this.allAreValues(false)) {
                expr = cc.preEval(expr);
                if (hash != null) {
                    cc.qc.threads.get(hash, this.info).remove();
                }
                return expr;
            }
        }
        return expr instanceof CmpG ? expr : cc.replaceWith(this, expr);
    }

    private Expr optArith(CompileContext cc) throws QueryException {
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        Expr ex = null;
        if (expr1 instanceof Arith && expr2.seqType().instanceOf(SeqType.NUMERIC_O)) {
            double num12;
            Expr op11 = expr1.arg(0);
            Expr op12 = expr1.arg(1);
            Expr op22 = expr2.arg(1);
            double d = num12 = op12 instanceof ANum ? ((ANum)op12).dbl() : Double.NaN;
            if (op12.seqType().instanceOf(SeqType.NUMERIC_O)) {
                Calc calc1 = ((Arith)expr1).calc;
                if (calc1 == Calc.MINUS && expr2 == Int.ZERO) {
                    ex = new CmpG(this.info, op11, op12, this.op, this.coll, this.sc);
                } else if ((Function.POSITION.is(op11) || !Double.isNaN(num12) && (expr2 instanceof ANum || expr2 instanceof Arith && op22 instanceof ANum)) && (calc1.oneOf(Calc.PLUS, Calc.MINUS) || calc1.oneOf(Calc.MULT, Calc.DIV) && num12 != 0.0 && (this.op.oneOf(OpG.EQ, OpG.NE) || num12 > 0.0))) {
                    Expr arg2 = new Arith(this.info, expr2, op12, calc1.invert()).optimize(cc);
                    ex = new CmpG(this.info, op11, arg2, this.op, this.coll, this.sc);
                }
            }
        }
        return ex != null ? ex.optimize(cc) : this;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        Iter iter1 = this.exprs[0].atomIter(qc, this.info);
        long size1 = iter1.size();
        if (size1 == 0L) {
            return Bln.FALSE;
        }
        Iter iter2 = this.exprs[1].atomIter(qc, this.info);
        long size2 = iter2.size();
        return size2 == 0L ? Bln.FALSE : this.compare(iter1, iter2, size1, size2, qc);
    }

    Bln compare(Iter iter1, Iter iter2, long size1, long size2, QueryContext qc) throws QueryException {
        Item item1;
        boolean swap;
        boolean single2;
        Iter ir1 = iter1;
        Iter ir2 = iter2;
        boolean single1 = size1 == 1L;
        boolean bl = single2 = size2 == 1L;
        if (single1 && single2) {
            return Bln.get(this.eval(ir1.next(), ir2.next()));
        }
        if (single1) {
            Item item2;
            Item item12 = ir1.next();
            while ((item2 = qc.next(ir2)) != null) {
                if (!this.eval(item12, item2)) continue;
                return Bln.TRUE;
            }
            return Bln.FALSE;
        }
        if (single2) {
            Item item13;
            Item item2 = ir2.next();
            while ((item13 = qc.next(ir1)) != null) {
                if (!this.eval(item13, item2)) continue;
                return Bln.TRUE;
            }
            return Bln.FALSE;
        }
        boolean bl2 = swap = size1 > size2;
        if (swap) {
            Iter iter = ir1;
            ir1 = ir2;
            ir2 = iter;
        }
        while ((item1 = ir1.next()) != null) {
            Item item2;
            if (ir2 == null) {
                ir2 = this.exprs[swap ? 0 : 1].atomIter(qc, this.info);
            }
            while ((item2 = qc.next(ir2)) != null) {
                if (!(swap ? this.eval(item2, item1) : this.eval(item1, item2))) continue;
                return Bln.TRUE;
            }
            ir2 = null;
        }
        return Bln.FALSE;
    }

    final boolean eval(Item item1, Item item2) throws QueryException {
        Type type2;
        Type type1;
        if (this.check && (type1 = item1.type) != (type2 = item2.type) && !CmpG.comparable(type1, type2)) {
            throw QueryError.diffError(item1, item2, this.info);
        }
        return this.op.value().eval(item1, item2, this.coll, this.sc, this.info);
    }

    public static boolean compatible(SeqType st1, SeqType st2, boolean eqne) {
        Type type1 = st1.type;
        Type type2 = st2.type;
        return type1 == type2 && !AtomType.ANY_ATOMIC_TYPE.instanceOf(type1) && (type1.isSortable() || !eqne) || type1.isStringOrUntyped() && type2.isStringOrUntyped() || type1 == AtomType.QNAME && type2 == AtomType.QNAME || type1.instanceOf(AtomType.NUMERIC) && type2.instanceOf(AtomType.NUMERIC) || type1.instanceOf(AtomType.DURATION) && type2.instanceOf(AtomType.DURATION);
    }

    private static boolean comparable(Type type1, Type type2) {
        if (type1.isUntyped() || type2.isUntyped() || type1.isNumber() && type2.isNumber() || type1.instanceOf(AtomType.DURATION) && type2.instanceOf(AtomType.DURATION)) {
            return true;
        }
        AtomType atom1 = type1.atomic();
        AtomType atom2 = type2.atomic();
        return !(atom1 == null || atom2 == null || !atom1.instanceOf(AtomType.STRING) && atom1 != AtomType.ANY_URI || !atom2.instanceOf(AtomType.STRING) && atom2 != AtomType.ANY_URI);
    }

    @Override
    public final CmpG invert() {
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        SeqType st1 = expr1.seqType();
        SeqType st2 = expr2.seqType();
        return st1.one() && !st1.mayBeArray() && st2.one() && !st2.mayBeArray() ? new CmpG(this.info, expr1, expr2, this.op.invert(), this.coll, this.sc) : null;
    }

    @Override
    public final CmpV.OpV opV() {
        return this.op.value();
    }

    @Override
    public final OpG opG() {
        return this.op;
    }

    @Override
    public Expr mergeEbv(Expr expr, boolean or, CompileContext cc) throws QueryException {
        boolean seqR2;
        OpG cmpOp;
        Expr expr2;
        if (expr instanceof Single) {
            return expr.mergeEbv(this, or, cc);
        }
        boolean not2 = Function.NOT.is(expr);
        Expr expr3 = expr2 = not2 ? expr.arg(0) : expr;
        if (!(expr2 instanceof CmpG)) {
            return null;
        }
        CmpG cmp2 = (CmpG)expr2;
        OpG opG = cmpOp = not2 ? cmp2.op.invert() : cmp2.op;
        if (this.op != cmpOp || this.coll != cmp2.coll || !this.exprs[0].equals(cmp2.exprs[0])) {
            return null;
        }
        Expr exprL = this.exprs[0];
        Expr exprR1 = this.exprs[1];
        Expr exprR2 = cmp2.exprs[1];
        QueryFunction<OpG, Expr> newList = newOp -> {
            Expr exprR = List.get(cc, this.info, exprR1, exprR2);
            return new CmpG(this.info, exprL, exprR, (OpG)((Object)newOp), this.coll, this.sc).optimize(cc);
        };
        boolean seqL = !exprL.seqType().one();
        boolean seqR1 = !exprR1.seqType().one();
        boolean bl = seqR2 = !exprR2.seqType().one();
        if (or) {
            if (not2 && (seqR2 || seqL)) {
                return null;
            }
            expr2 = newList.apply(this.op);
        } else {
            if (seqL || seqR1 || seqR2 && !not2) {
                return null;
            }
            expr2 = cc.function(Function.NOT, this.info, newList.apply(this.op.invert()));
        }
        return expr2;
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        return cc.simplify(this, mode.oneOf(CompileContext.Simplify.EBV, CompileContext.Simplify.PREDICATE) ? this.optPred(cc) : this, mode);
    }

    private Expr optPred(CompileContext cc) throws QueryException {
        Value val = cc.qc.focus.value;
        if (val == null) {
            return this;
        }
        Type type = val.seqType().type;
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        CmpV.OpV opV = this.opV();
        if (type instanceof NodeType && type != NodeType.NODE && expr1 instanceof ContextFn && expr2 instanceof Value && opV == CmpV.OpV.EQ) {
            ContextFn func = (ContextFn)expr1;
            Value value = (Value)expr2;
            if (func.exprs.length > 0 && !(func.exprs[0] instanceof ContextValue)) {
                return this;
            }
            ArrayList<QNm> qnames = new ArrayList<QNm>();
            NamePart part = null;
            if (expr2.seqType().type.isStringOrUntyped()) {
                Object uri;
                if (Function.LOCAL_NAME.is(func)) {
                    part = NamePart.LOCAL;
                    for (Item item : value) {
                        byte[] name = item.string(this.info);
                        if (!XMLToken.isNCName(name)) continue;
                        qnames.add(new QNm(name));
                    }
                } else if (Function.NAMESPACE_URI.is(func)) {
                    for (Item item : value) {
                        uri = item.string(this.info);
                        if (!Token.eq(Token.normalize(uri), uri)) continue;
                        qnames.add(new QNm(Token.COLON, (byte[])uri));
                    }
                    if ((long)qnames.size() == value.size()) {
                        part = NamePart.URI;
                    }
                } else if (Function.NAME.is(func)) {
                    byte[] dataNs;
                    Data data = cc.qc.focus.value.data();
                    byte[] byArray = dataNs = data != null ? data.defaultNs() : null;
                    if (dataNs != null && dataNs.length == 0) {
                        part = NamePart.LOCAL;
                        uri = value.iterator();
                        while (uri.hasNext()) {
                            Item item = (Item)uri.next();
                            byte[] name = item.string(this.info);
                            if (!XMLToken.isNCName(name)) continue;
                            qnames.add(new QNm(name));
                        }
                    }
                }
            } else if (Function.NODE_NAME.is(func) && expr2.seqType().type == AtomType.QNAME) {
                part = NamePart.FULL;
                for (Item item : value) {
                    qnames.add((QNm)item);
                }
            }
            if (part != null) {
                ExprList paths = new ExprList(2L);
                for (QNm qname : qnames) {
                    NameTest test = new NameTest(qname, part, (NodeType)type, cc.sc().elemNS);
                    Expr step = Step.get(cc, null, this.info, test, new Expr[0]);
                    if (step == Empty.VALUE) continue;
                    paths.add(Path.get(cc, this.info, null, step));
                }
                return paths.isEmpty() ? Bln.FALSE : (paths.size() == 1 ? (Expr)paths.get(0) : new Union(this.info, (Expr[])paths.finish()).optimize(cc));
            }
        }
        return this;
    }

    @Override
    public final boolean indexAccessible(IndexInfo ii) throws QueryException {
        if (this.op != OpG.EQ || this.coll != null) {
            return false;
        }
        Expr expr1 = this.exprs[0];
        IndexType type = null;
        if (Function.TOKENIZE.is(expr1)) {
            if (!expr1.arg(0).seqType().zeroOrOne() || !((FnTokenize)expr1).whitespaces()) {
                return false;
            }
            expr1 = expr1.arg(0);
            type = IndexType.TOKEN;
        }
        return ii.create(this.exprs[1], ii.type(expr1, type), false, this.info);
    }

    @Override
    public CmpG copy(CompileContext cc, IntObjMap<Var> vm) {
        CmpG cmp = new CmpG(this.info, this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm), this.op, this.coll, this.sc);
        cmp.check = this.check;
        return this.copyType(cmp);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof CmpG && this.op == ((CmpG)obj).op && super.equals(obj);
    }

    @Override
    public String description() {
        return this.op + " comparison";
    }

    @Override
    public final void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "op", this.op.name), this.exprs);
    }

    @Override
    public final void toString(QueryString qs) {
        qs.tokens(this.exprs, " " + this.op + " ", true);
    }

    public static enum OpG {
        LE("<="){

            @Override
            public OpG swap() {
                return GE;
            }

            @Override
            public OpG invert() {
                return GT;
            }

            @Override
            public CmpV.OpV value() {
                return CmpV.OpV.LE;
            }
        }
        ,
        LT("<"){

            @Override
            public OpG swap() {
                return GT;
            }

            @Override
            public OpG invert() {
                return GE;
            }

            @Override
            public CmpV.OpV value() {
                return CmpV.OpV.LT;
            }
        }
        ,
        GE(">="){

            @Override
            public OpG swap() {
                return LE;
            }

            @Override
            public OpG invert() {
                return LT;
            }

            @Override
            public CmpV.OpV value() {
                return CmpV.OpV.GE;
            }
        }
        ,
        GT(">"){

            @Override
            public OpG swap() {
                return LT;
            }

            @Override
            public OpG invert() {
                return LE;
            }

            @Override
            public CmpV.OpV value() {
                return CmpV.OpV.GT;
            }
        }
        ,
        EQ("="){

            @Override
            public OpG swap() {
                return EQ;
            }

            @Override
            public OpG invert() {
                return NE;
            }

            @Override
            public CmpV.OpV value() {
                return CmpV.OpV.EQ;
            }
        }
        ,
        NE("!="){

            @Override
            public OpG swap() {
                return NE;
            }

            @Override
            public OpG invert() {
                return EQ;
            }

            @Override
            public CmpV.OpV value() {
                return CmpV.OpV.NE;
            }
        };

        public static final OpG[] VALUES;
        public final String name;

        private OpG(String name) {
            this.name = name;
        }

        public abstract OpG swap();

        public abstract OpG invert();

        public abstract CmpV.OpV value();

        public String toString() {
            return this.name;
        }

        public final boolean oneOf(OpG ... ops) {
            for (OpG op : ops) {
                if (this != op) continue;
                return true;
            }
            return false;
        }

        static OpG get(CmpV.OpV opV) {
            for (OpG value : VALUES) {
                if (value.value() != opV) continue;
                return value;
            }
            return null;
        }

        static {
            VALUES = OpG.values();
        }
    }
}

