/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.basex.query.CompileContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Arith;
import org.basex.query.expr.Cast;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Unary;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Dat;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Tim;
import org.basex.query.value.item.YMDur;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public enum Calc {
    PLUS("+"){

        @Override
        public Item eval(Item item1, Item item2, InputInfo ii) throws QueryException {
            boolean num2;
            Type type1 = item1.type;
            Type type2 = item2.type;
            boolean num1 = type1.isNumberOrUntyped();
            if (num1 ^ (num2 = type2.isNumberOrUntyped())) {
                throw QueryError.numberError(num1 ? item2 : item1, ii);
            }
            if (num1) {
                Type type = 1.numType(type1, type2);
                if (type == AtomType.INTEGER) {
                    long itr1 = item1.itr(ii);
                    long itr2 = item2.itr(ii);
                    if (itr2 > 0L ? itr1 > Long.MAX_VALUE - itr2 : itr1 < Long.MIN_VALUE - itr2) {
                        throw QueryError.RANGE_X.get(ii, itr1 + " + " + itr2);
                    }
                    return Int.get(itr1 + itr2);
                }
                if (type == AtomType.DOUBLE) {
                    return Dbl.get(item1.dbl(ii) + item2.dbl(ii));
                }
                if (type == AtomType.FLOAT) {
                    return Flt.get(item1.flt(ii) + item2.flt(ii));
                }
                return Dec.get(item1.dec(ii).add(item2.dec(ii)));
            }
            if (type1 == type2) {
                if (!(item1 instanceof Dur)) {
                    throw QueryError.numberError(item1, ii);
                }
                if (type1 == AtomType.YEAR_MONTH_DURATION) {
                    return new YMDur((YMDur)item1, (YMDur)item2, true, ii);
                }
                if (type1 == AtomType.DAY_TIME_DURATION) {
                    return new DTDur((DTDur)item1, (DTDur)item2, true, ii);
                }
            }
            if (type1 == AtomType.DATE_TIME) {
                return new Dtm((Dtm)item1, 1.dur(ii, item2), true, ii);
            }
            if (type2 == AtomType.DATE_TIME) {
                return new Dtm((Dtm)item2, 1.dur(ii, item1), true, ii);
            }
            if (type1 == AtomType.DATE) {
                return new Dat((Dat)item1, 1.dur(ii, item2), true, ii);
            }
            if (type2 == AtomType.DATE) {
                return new Dat((Dat)item2, 1.dur(ii, item1), true, ii);
            }
            if (type1 == AtomType.TIME && type2 == AtomType.DAY_TIME_DURATION) {
                return new Tim((Tim)item1, (DTDur)item2, true);
            }
            if (type2 == AtomType.TIME && type1 == AtomType.DAY_TIME_DURATION) {
                return new Tim((Tim)item2, (DTDur)item1, true);
            }
            throw this.typeError(ii, type1, type2);
        }

        @Override
        public Expr optimize(Expr expr1, Expr expr2, InputInfo info, CompileContext cc) throws QueryException {
            Type type = 1.numType(expr1.seqType().type, expr2.seqType().type);
            if (expr2 instanceof ANum && ((ANum)expr2).dbl() == 0.0) {
                return new Cast(cc.sc(), info, expr1, type.seqType()).optimize(cc);
            }
            if (expr1.equals(expr2)) {
                return new Arith(info, expr1, (Expr)Int.get(2L), MULT).optimize(cc);
            }
            if (expr2 instanceof Unary) {
                return new Arith(info, expr1, ((Unary)expr2).expr, MINUS).optimize(cc);
            }
            if (expr1 instanceof Arith) {
                Arith arith = (Arith)expr1;
                if (arith.calc == MULT && arith.exprs[0].equals(expr2) && arith.exprs[1] instanceof Int) {
                    long factor = ((Int)arith.exprs[1]).itr();
                    return new Arith(info, arith.exprs[0], (Expr)Int.get(factor + 1L), MULT).optimize(cc);
                }
            }
            return null;
        }

        @Override
        public Type type(Type type1, Type type2) {
            if (type1 == AtomType.YEAR_MONTH_DURATION && type2 == AtomType.YEAR_MONTH_DURATION) {
                return AtomType.YEAR_MONTH_DURATION;
            }
            if (type1 == AtomType.DAY_TIME_DURATION && type2 == AtomType.DAY_TIME_DURATION) {
                return AtomType.DAY_TIME_DURATION;
            }
            if (type1 == AtomType.DATE_TIME || type2 == AtomType.DATE_TIME) {
                return AtomType.DATE_TIME;
            }
            if (type1 == AtomType.DATE || type2 == AtomType.DATE) {
                return AtomType.DATE;
            }
            if (type1 == AtomType.TIME && type2 == AtomType.DAY_TIME_DURATION || type1 == AtomType.DAY_TIME_DURATION && type2 == AtomType.TIME) {
                return AtomType.TIME;
            }
            return 1.numType(type1, type2);
        }

        @Override
        public Calc invert() {
            return MINUS;
        }
    }
    ,
    MINUS("-"){

        @Override
        public Item eval(Item item1, Item item2, InputInfo ii) throws QueryException {
            boolean num2;
            Type type1 = item1.type;
            Type type2 = item2.type;
            boolean num1 = type1.isNumberOrUntyped();
            if (num1 ^ (num2 = type2.isNumberOrUntyped())) {
                throw QueryError.numberError(num1 ? item2 : item1, ii);
            }
            if (num1) {
                Type type = 2.numType(type1, type2);
                if (type == AtomType.INTEGER) {
                    long itr1 = item1.itr(ii);
                    long itr2 = item2.itr(ii);
                    if (itr2 < 0L ? itr1 > Long.MAX_VALUE + itr2 : itr1 < Long.MIN_VALUE + itr2) {
                        throw QueryError.RANGE_X.get(ii, itr1 + " - " + itr2);
                    }
                    return Int.get(itr1 - itr2);
                }
                if (type == AtomType.DOUBLE) {
                    return Dbl.get(item1.dbl(ii) - item2.dbl(ii));
                }
                if (type == AtomType.FLOAT) {
                    return Flt.get(item1.flt(ii) - item2.flt(ii));
                }
                return Dec.get(item1.dec(ii).subtract(item2.dec(ii)));
            }
            if (type1 == type2) {
                if (type1 == AtomType.DATE_TIME || type1 == AtomType.DATE || type1 == AtomType.TIME) {
                    return new DTDur((ADate)item1, (ADate)item2, ii);
                }
                if (type1 == AtomType.YEAR_MONTH_DURATION) {
                    return new YMDur((YMDur)item1, (YMDur)item2, false, ii);
                }
                if (type1 == AtomType.DAY_TIME_DURATION) {
                    return new DTDur((DTDur)item1, (DTDur)item2, false, ii);
                }
                throw QueryError.numberError(item1, ii);
            }
            if (type1 == AtomType.DATE_TIME) {
                return new Dtm((Dtm)item1, 2.dur(ii, item2), false, ii);
            }
            if (type1 == AtomType.DATE) {
                return new Dat((Dat)item1, 2.dur(ii, item2), false, ii);
            }
            if (type1 == AtomType.TIME && type2 == AtomType.DAY_TIME_DURATION) {
                return new Tim((Tim)item1, (DTDur)item2, false);
            }
            throw this.typeError(ii, type1, type2);
        }

        @Override
        public Expr optimize(Expr expr1, Expr expr2, InputInfo info, CompileContext cc) throws QueryException {
            Type type = 2.numType(expr1.seqType().type, expr2.seqType().type);
            if (expr2 instanceof ANum && ((ANum)expr2).dbl() == 0.0) {
                return new Cast(cc.sc(), info, expr1, type.seqType()).optimize(cc);
            }
            if (expr1.equals(expr2)) {
                return type == AtomType.DECIMAL ? Dec.ZERO : (type == AtomType.INTEGER ? Int.ZERO : null);
            }
            if (expr2 instanceof Unary) {
                return new Arith(info, expr1, ((Unary)expr2).expr, PLUS).optimize(cc);
            }
            if (expr1 instanceof Arith) {
                Arith arith = (Arith)expr1;
                if (arith.calc == MULT && arith.exprs[0].equals(expr2) && arith.exprs[1] instanceof Int) {
                    long factor = ((Int)arith.exprs[1]).itr();
                    return new Arith(info, arith.exprs[0], (Expr)Int.get(factor - 1L), MULT).optimize(cc);
                }
            }
            return null;
        }

        @Override
        public Type type(Type type1, Type type2) {
            if (type1 == AtomType.DATE_TIME && type2 == AtomType.DATE_TIME || type1 == AtomType.DATE && type2 == AtomType.DATE) {
                return AtomType.DAY_TIME_DURATION;
            }
            if (type1 == AtomType.TIME && type2 == AtomType.TIME) {
                return AtomType.DAY_TIME_DURATION;
            }
            if (type1 == AtomType.DATE_TIME) {
                return AtomType.DATE_TIME;
            }
            if (type1 == AtomType.DATE) {
                return AtomType.DATE;
            }
            if (type1 == AtomType.TIME && type2 == AtomType.DAY_TIME_DURATION) {
                return AtomType.TIME;
            }
            return 2.numType(type1, type2);
        }

        @Override
        public Calc invert() {
            return PLUS;
        }
    }
    ,
    MULT("*"){

        @Override
        public Item eval(Item item1, Item item2, InputInfo ii) throws QueryException {
            boolean num2;
            Type type1 = item1.type;
            Type type2 = item2.type;
            if (type1 == AtomType.YEAR_MONTH_DURATION) {
                if (item2 instanceof ANum) {
                    return new YMDur((Dur)item1, item2.dbl(ii), true, ii);
                }
                throw QueryError.numberError(item2, ii);
            }
            if (type2 == AtomType.YEAR_MONTH_DURATION) {
                if (item1 instanceof ANum) {
                    return new YMDur((Dur)item2, item1.dbl(ii), true, ii);
                }
                throw QueryError.numberError(item1, ii);
            }
            if (type1 == AtomType.DAY_TIME_DURATION) {
                if (item2 instanceof ANum) {
                    return new DTDur((Dur)item1, item2.dbl(ii), true, ii);
                }
                throw QueryError.numberError(item2, ii);
            }
            if (type2 == AtomType.DAY_TIME_DURATION) {
                if (item1 instanceof ANum) {
                    return new DTDur((Dur)item2, item1.dbl(ii), true, ii);
                }
                throw QueryError.numberError(item1, ii);
            }
            boolean num1 = type1.isNumberOrUntyped();
            if (num1 ^ (num2 = type2.isNumberOrUntyped())) {
                throw this.typeError(ii, type1, type2);
            }
            if (num1) {
                Type type = 3.numType(type1, type2);
                if (type == AtomType.INTEGER) {
                    long l1 = item1.itr(ii);
                    long l2 = item2.itr(ii);
                    if (l2 > 0L ? l1 > Long.MAX_VALUE / l2 || l1 < Long.MIN_VALUE / l2 : (l2 < -1L ? l1 > Long.MIN_VALUE / l2 || l1 < Long.MAX_VALUE / l2 : l2 == -1L && l1 == Long.MIN_VALUE)) {
                        throw QueryError.RANGE_X.get(ii, l1 + " * " + l2);
                    }
                    return Int.get(l1 * l2);
                }
                if (type == AtomType.DOUBLE) {
                    return Dbl.get(item1.dbl(ii) * item2.dbl(ii));
                }
                if (type == AtomType.FLOAT) {
                    return Flt.get(item1.flt(ii) * item2.flt(ii));
                }
                return Dec.get(item1.dec(ii).multiply(item2.dec(ii)));
            }
            throw QueryError.numberError(item1, ii);
        }

        @Override
        public Expr optimize(Expr expr1, Expr expr2, InputInfo info, CompileContext cc) throws QueryException {
            Type type = 3.numType(expr1.seqType().type, expr2.seqType().type);
            if (expr2 instanceof ANum) {
                double dbl2 = ((ANum)expr2).dbl();
                if (dbl2 == 1.0) {
                    return new Cast(cc.sc(), info, expr1, type.seqType()).optimize(cc);
                }
                if (dbl2 == 0.0) {
                    return type == AtomType.DECIMAL ? Dec.ZERO : (type == AtomType.INTEGER ? Int.ZERO : null);
                }
            }
            if (type == AtomType.DOUBLE) {
                if (expr1.equals(expr2)) {
                    return cc.function(Function._MATH_POW, info, expr1, Dbl.get(2.0));
                }
                if (Function._MATH_POW.is(expr1)) {
                    StandardFunc func = (StandardFunc)expr1;
                    if (func.exprs[0].equals(expr2) && func.exprs[1] instanceof ANum) {
                        double factor = ((ANum)func.exprs[1]).dbl();
                        return cc.function(Function._MATH_POW, info, func.exprs[0], Dbl.get(factor + 1.0));
                    }
                }
            }
            if (expr2 instanceof Arith) {
                Arith arith = (Arith)expr2;
                if (arith.calc == DIV && arith.exprs[0] instanceof Int && arith.exprs[1].equals(expr1)) {
                    return new Cast(cc.sc(), info, arith.exprs[0], type.seqType()).optimize(cc);
                }
            }
            return null;
        }

        @Override
        public Type type(Type type1, Type type2) {
            if (type1 == AtomType.YEAR_MONTH_DURATION || type2 == AtomType.YEAR_MONTH_DURATION) {
                return AtomType.YEAR_MONTH_DURATION;
            }
            if (type1 == AtomType.DAY_TIME_DURATION || type2 == AtomType.DAY_TIME_DURATION) {
                return AtomType.DAY_TIME_DURATION;
            }
            return 3.numType(type1, type2);
        }

        @Override
        public Calc invert() {
            return DIV;
        }
    }
    ,
    DIV("div"){

        @Override
        public Item eval(Item item1, Item item2, InputInfo ii) throws QueryException {
            Type type1 = item1.type;
            Type type2 = item2.type;
            if (type1 == type2) {
                if (type1 == AtomType.YEAR_MONTH_DURATION) {
                    BigDecimal bd = BigDecimal.valueOf(((YMDur)item2).ymd());
                    if (bd.doubleValue() == 0.0) {
                        throw Calc.zeroError(ii, item1);
                    }
                    return Dec.get(BigDecimal.valueOf(((YMDur)item1).ymd()).divide(bd, MathContext.DECIMAL64));
                }
                if (type1 == AtomType.DAY_TIME_DURATION) {
                    BigDecimal bd = ((DTDur)item2).dtd();
                    if (bd.doubleValue() == 0.0) {
                        throw Calc.zeroError(ii, item1);
                    }
                    return Dec.get(((DTDur)item1).dtd().divide(bd, MathContext.DECIMAL64));
                }
            }
            if (type1 == AtomType.YEAR_MONTH_DURATION) {
                if (item2 instanceof ANum) {
                    return new YMDur((Dur)item1, item2.dbl(ii), false, ii);
                }
                throw QueryError.numberError(item2, ii);
            }
            if (type1 == AtomType.DAY_TIME_DURATION) {
                if (item2 instanceof ANum) {
                    return new DTDur((Dur)item1, item2.dbl(ii), false, ii);
                }
                throw QueryError.numberError(item2, ii);
            }
            4.checkNum(ii, item1, item2);
            Type type = 4.numType(type1, type2);
            if (type == AtomType.DOUBLE) {
                return Dbl.get(item1.dbl(ii) / item2.dbl(ii));
            }
            if (type == AtomType.FLOAT) {
                return Flt.get(item1.flt(ii) / item2.flt(ii));
            }
            BigDecimal dec1 = item1.dec(ii);
            BigDecimal dec2 = item2.dec(ii);
            if (dec2.signum() == 0) {
                throw Calc.zeroError(ii, item1);
            }
            int scale = Math.max(18, Math.max(dec1.scale(), dec2.scale()));
            return Dec.get(dec1.divide(dec2, scale, RoundingMode.HALF_EVEN));
        }

        @Override
        public Expr optimize(Expr expr1, Expr expr2, InputInfo info, CompileContext cc) throws QueryException {
            Type type = 4.numType(expr1.seqType().type, expr2.seqType().type);
            if (expr2 instanceof ANum && ((ANum)expr2).dbl() == 1.0) {
                return new Cast(cc.sc(), info, expr1, type.seqType()).optimize(cc);
            }
            if (expr1.equals(expr2)) {
                return type == AtomType.DECIMAL ? Dec.ONE : (type == AtomType.INTEGER ? Int.ONE : null);
            }
            if (Function._MATH_POW.is(expr1)) {
                StandardFunc func = (StandardFunc)expr1;
                if (func.exprs[0].equals(expr2) && func.exprs[1] instanceof ANum) {
                    double factor = ((ANum)func.exprs[1]).dbl();
                    return cc.function(Function._MATH_POW, info, func.exprs[0], Dbl.get(factor - 1.0));
                }
            }
            return null;
        }

        @Override
        public Type type(Type type1, Type type2) {
            if (type1 == AtomType.YEAR_MONTH_DURATION && type2 == AtomType.YEAR_MONTH_DURATION || type1 == AtomType.DAY_TIME_DURATION && type2 == AtomType.DAY_TIME_DURATION) {
                return AtomType.DECIMAL;
            }
            if (type1 == AtomType.YEAR_MONTH_DURATION) {
                return AtomType.YEAR_MONTH_DURATION;
            }
            if (type1 == AtomType.DAY_TIME_DURATION) {
                return AtomType.DAY_TIME_DURATION;
            }
            Type type = 4.numType(type1, type2);
            return type == AtomType.INTEGER ? AtomType.DECIMAL : type;
        }

        @Override
        public Calc invert() {
            return MULT;
        }
    }
    ,
    IDIV("idiv"){

        @Override
        public Int eval(Item item1, Item item2, InputInfo ii) throws QueryException {
            long l;
            boolean range;
            boolean zero;
            5.checkNum(ii, item1, item2);
            Type type = 5.numType(item1.type, item2.type);
            boolean inv = false;
            if (type == AtomType.FLOAT) {
                float n1 = item1.flt(ii);
                float n2 = item2.flt(ii);
                float n = n1 / n2;
                zero = n2 == 0.0f;
                inv = Float.isNaN(n) || Float.isInfinite(n);
                range = n < -9.223372E18f || n > 9.223372E18f;
                l = (long)n;
            } else if (type == AtomType.DOUBLE) {
                double n1 = item1.dbl(ii);
                double n2 = item2.dbl(ii);
                double n = n1 / n2;
                zero = n2 == 0.0;
                inv = Double.isNaN(n) || Double.isInfinite(n);
                range = n < -9.223372036854776E18 || n > 9.223372036854776E18;
                l = (long)n;
            } else if (type == AtomType.INTEGER) {
                long n1 = item1.itr(ii);
                long n2 = item2.itr(ii);
                zero = n2 == 0L;
                range = n1 == Integer.MIN_VALUE && n2 == -1L;
                l = zero ? 0L : n1 / n2;
            } else {
                BigDecimal n1 = item1.dec(ii);
                BigDecimal n2 = item2.dec(ii);
                zero = n2.signum() == 0;
                BigDecimal n = zero ? BigDecimal.ZERO : n1.divideToIntegralValue(n2);
                range = MIN_LONG.compareTo(n) > 0 || n.compareTo(MAX_LONG) > 0;
                long l2 = l = range ? Long.MAX_VALUE : n.longValueExact();
            }
            if (zero) {
                throw Calc.zeroError(ii, item1);
            }
            if (inv) {
                throw QueryError.INVIDIV.get(ii, item1 + " idiv " + item2);
            }
            if (range) {
                throw QueryError.RANGE_X.get(ii, item1 + " idiv " + item2);
            }
            return Int.get(l);
        }

        @Override
        public Expr optimize(Expr expr1, Expr expr2, InputInfo info, CompileContext cc) throws QueryException {
            Type type = 5.numType(expr1.seqType().type, expr2.seqType().type);
            if (expr2 instanceof ANum && ((ANum)expr2).dbl() == 1.0) {
                return new Cast(cc.sc(), info, expr1, SeqType.INTEGER_O).optimize(cc);
            }
            if (expr1.equals(expr2)) {
                return type.oneOf(AtomType.DECIMAL, AtomType.INTEGER) ? Int.ONE : null;
            }
            return null;
        }

        @Override
        public Type type(Type type1, Type type2) {
            return AtomType.INTEGER;
        }

        @Override
        public Calc invert() {
            return null;
        }
    }
    ,
    MOD("mod"){

        @Override
        public Item eval(Item item1, Item item2, InputInfo ii) throws QueryException {
            6.checkNum(ii, item1, item2);
            Type type = 6.numType(item1.type, item2.type);
            if (type == AtomType.DOUBLE) {
                return Dbl.get(item1.dbl(ii) % item2.dbl(ii));
            }
            if (type == AtomType.FLOAT) {
                return Flt.get(item1.flt(ii) % item2.flt(ii));
            }
            if (type == AtomType.INTEGER) {
                long itr1 = item1.itr(ii);
                long itr2 = item2.itr(ii);
                if (itr2 == 0L) {
                    throw Calc.zeroError(ii, item1);
                }
                return Int.get(itr1 % itr2);
            }
            BigDecimal dec1 = item1.dec(ii);
            BigDecimal dec2 = item2.dec(ii);
            if (dec2.signum() == 0) {
                throw Calc.zeroError(ii, item1);
            }
            BigDecimal sub = dec1.divide(dec2, 0, RoundingMode.DOWN);
            return Dec.get(dec1.subtract(sub.multiply(dec2)));
        }

        @Override
        public Expr optimize(Expr expr1, Expr expr2, InputInfo info, CompileContext cc) {
            Type type = 6.numType(expr1.seqType().type, expr2.seqType().type);
            if (type == AtomType.INTEGER && expr2 == Int.ONE) {
                return Int.ZERO;
            }
            return null;
        }

        @Override
        public Type type(Type type1, Type type2) {
            Type type = 6.numType(type1, type2);
            return type == AtomType.ANY_ATOMIC_TYPE ? AtomType.NUMERIC : type;
        }

        @Override
        public Calc invert() {
            return null;
        }
    };

    private static final BigDecimal MIN_LONG;
    private static final BigDecimal MAX_LONG;
    final String name;

    private Calc(String name) {
        this.name = name;
    }

    public abstract Item eval(Item var1, Item var2, InputInfo var3) throws QueryException;

    public abstract Expr optimize(Expr var1, Expr var2, InputInfo var3, CompileContext var4) throws QueryException;

    public abstract Type type(Type var1, Type var2);

    public abstract Calc invert();

    public final boolean oneOf(Calc ... calcs) {
        for (Calc calc : calcs) {
            if (this != calc) continue;
            return true;
        }
        return false;
    }

    public static Type numType(Type type1, Type type2) {
        if (!type1.isNumberOrUntyped() || !type2.isNumberOrUntyped()) {
            return AtomType.ANY_ATOMIC_TYPE;
        }
        if (type1 == AtomType.DOUBLE || type2 == AtomType.DOUBLE || type1.isUntyped() || type2.isUntyped()) {
            return AtomType.DOUBLE;
        }
        if (type1 == AtomType.FLOAT || type2 == AtomType.FLOAT) {
            return AtomType.FLOAT;
        }
        if (type1 == AtomType.DECIMAL || type2 == AtomType.DECIMAL) {
            return AtomType.DECIMAL;
        }
        if (type1 == AtomType.NUMERIC || type2 == AtomType.NUMERIC) {
            return AtomType.NUMERIC;
        }
        return AtomType.INTEGER;
    }

    private static QueryException zeroError(InputInfo ii, Item item) {
        return QueryError.DIVZERO_X.get(ii, item);
    }

    final QueryException typeError(InputInfo ii, Type type1, Type type2) {
        return QueryError.CALCTYPE_X_X_X.get(ii, this.info(), type1, type2);
    }

    static Dur dur(InputInfo ii, Item item) throws QueryException {
        Type type = item.type;
        if (item instanceof Dur) {
            if (type == AtomType.DURATION) {
                throw QueryError.NOSUBDUR_X.get(ii, item);
            }
            return (Dur)item;
        }
        throw QueryError.NODUR_X_X.get(ii, type, item);
    }

    static void checkNum(InputInfo ii, Item item1, Item item2) throws QueryException {
        if (!item1.type.isNumberOrUntyped()) {
            throw QueryError.numberError(item1, ii);
        }
        if (!item2.type.isNumberOrUntyped()) {
            throw QueryError.numberError(item2, ii);
        }
    }

    final String info() {
        return "'" + this.name + "' expression";
    }

    public String toString() {
        return this.name;
    }

    static {
        MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
        MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    }
}

