/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryBiFunction;
import org.basex.query.QueryException;
import org.basex.query.QueryFunction;
import org.basex.query.QueryPlan;
import org.basex.query.expr.And;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Or;
import org.basex.query.expr.ParseExpr;
import org.basex.query.func.Function;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public abstract class Arr
extends ParseExpr {
    public Expr[] exprs;

    protected Arr(InputInfo info, SeqType seqType, Expr ... exprs) {
        super(info, seqType);
        this.exprs = exprs;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.exprs);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        for (int e = 0; e < el; ++e) {
            this.exprs[e] = this.exprs[e].compile(cc);
        }
        return this.optimize(cc);
    }

    @Override
    public boolean has(Flag ... flags) {
        for (Expr expr : this.exprs) {
            if (!expr.has(flags)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        for (Expr expr : this.exprs) {
            if (expr.inlineable(ic)) continue;
            return false;
        }
        return true;
    }

    @Override
    public VarUsage count(Var var) {
        return VarUsage.sum(var, this.exprs);
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        return ic.inline(this.exprs) ? this.optimize(ic.cc) : null;
    }

    public static <T extends Expr> T[] copyAll(CompileContext cc, IntObjMap<Var> vm, T[] arr) {
        Expr[] copy = (Expr[])arr.clone();
        int cl = copy.length;
        for (int c = 0; c < cl; ++c) {
            copy[c] = copy[c].copy(cc, vm);
        }
        return copy;
    }

    protected final boolean allAreValues(boolean limit) {
        for (Expr expr : this.exprs) {
            if (expr instanceof Value && (!limit || expr.size() <= 262144L)) continue;
            return false;
        }
        return true;
    }

    protected final Expr[] simplifyAll(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        boolean changed = false;
        ExprList list = new ExprList(this.exprs.length);
        for (Expr expr : this.exprs) {
            Expr ex = expr.simplifyFor(mode, cc);
            if (ex != expr) {
                changed = true;
            }
            list.add(ex);
        }
        return changed ? (Expr[])list.finish() : this.exprs;
    }

    protected final void flatten(CompileContext cc) {
        ExprList list = new ExprList(this.exprs.length);
        Class<?> clazz = this.getClass();
        for (Expr expr : this.exprs) {
            if (clazz.isInstance(expr)) {
                list.add(expr.args());
                cc.info("flatten nested %: %", expr, this::description);
                continue;
            }
            list.add(expr);
        }
        this.exprs = (Expr[])list.finish();
    }

    protected final void removeEmpty(CompileContext cc) {
        if (!((Checks<Expr>)expr -> expr == Empty.VALUE).any((Expr[])this.exprs)) {
            return;
        }
        ExprList list = new ExprList(this.exprs.length - 1);
        for (Expr expr2 : this.exprs) {
            if (expr2 == Empty.VALUE) continue;
            list.add(expr2);
        }
        cc.info("remove % from %", Empty.VALUE, this::description);
        this.exprs = (Expr[])list.finish();
    }

    final Expr emptyExpr() {
        for (Expr expr : this.exprs) {
            if (!expr.seqType().zero()) continue;
            return expr;
        }
        return this;
    }

    final boolean optimizeEbv(boolean or, boolean positional, CompileContext cc) throws QueryException {
        QueryBiFunction<Boolean, Expr[], Expr> func;
        Class clazz;
        Expr tmp;
        ExprList list = new ExprList(this.exprs.length);
        boolean pos = false;
        for (Expr expr : this.exprs) {
            if (!(!(expr instanceof Value) || positional && expr instanceof ANum)) {
                if (expr.ebv(cc.qc, this.info).bool(this.info) == or) {
                    return true;
                }
                cc.info("remove % from %", expr, this::description);
                continue;
            }
            if (!pos && list.contains(expr) && !expr.has(Flag.NDT)) {
                cc.info("remove % from %", expr, this::description);
                continue;
            }
            list.add(expr);
            if (!positional || pos) continue;
            pos = Arr.mayBePositional(expr);
        }
        this.exprs = (Expr[])list.next();
        if (!(positional && this.has(Flag.POS) || (tmp = this.rewrite(clazz = or ? And.class : Or.class, func = (invert, args) -> invert == or ? new And(this.info, (Expr)args) : new Or(this.info, (Expr)args), cc)) == null)) {
            this.exprs = new Expr[]{tmp};
            cc.info("rewrite %: %", this::description, this);
        }
        list.add(this.exprs);
        for (int l = 0; l < list.size(); ++l) {
            for (int m = l + 1; m < list.size(); ++m) {
                Expr expr1 = (Expr)list.get(l);
                Expr[] expr2 = (Expr[])list.get(m);
                if (expr1.has(Flag.NDT) || positional && expr1.has(Flag.POS)) continue;
                if (Arr.contradict(expr1, (Expr)expr2, true) || Arr.contradict((Expr)expr2, expr1, true)) {
                    return true;
                }
                Expr merged = expr1.mergeEbv((Expr)expr2, or, cc);
                if (merged == null) continue;
                cc.info("simplify %: %", this::description, this);
                list.set(l, merged);
                list.remove(m--);
            }
        }
        this.exprs = (Expr[])list.next();
        Function not = Function.NOT;
        Checks<Expr> fnNot = ex -> not.is((Expr)ex) && (!positional || !ex.has(Flag.POS));
        if (this.exprs.length > 1 && fnNot.all((Expr[])this.exprs)) {
            Expr expr;
            ExprList tmp2 = new ExprList(this.exprs.length);
            for (Expr expr2 : this.exprs) {
                tmp2.add(expr2.arg(0));
            }
            expr = or ? new And(this.info, (Expr[])tmp2.finish()) : new Or(this.info, (Expr[])tmp2.finish());
            this.exprs = (Expr[])((ExprList)((Object)list.add(cc.function(not, this.info, expr.optimize(cc))))).finish();
        }
        return false;
    }

    static boolean contradict(Expr expr1, Expr expr2, boolean ebv) {
        Expr arg;
        Expr expr = arg = Function.BOOLEAN.is(expr1) ? expr1.arg(0) : expr1;
        if (Function.NOT.is(expr2) && expr2.arg(0).equals(arg)) {
            return true;
        }
        Expr expr3 = Function.EXISTS.is(expr1) ? expr1.arg(0) : (arg = ebv && expr1.seqType().type instanceof NodeType ? expr1 : null);
        if (Function.EMPTY.is(expr2) && arg != null && expr2.arg(0).equals(arg)) {
            return true;
        }
        return expr1 instanceof Cmp && expr2 instanceof Cmp && expr1.equals(((Cmp)expr2).invert());
    }

    final Expr rewrite(Class<? extends Arr> inverse, QueryBiFunction<Boolean, Expr[], Expr> newExpr, CompileContext cc) throws QueryException {
        block10: {
            block9: {
                if (this.exprs.length < 2) break block9;
                if (((Checks<Expr>)inverse::isInstance).any((Expr[])this.exprs)) break block10;
            }
            return null;
        }
        java.util.function.Function<Expr, ExprList> entries = ex -> {
            Expr[] exprArray;
            ExprList exprList = new ExprList();
            if (inverse.isInstance(ex)) {
                exprArray = ex.args();
            } else {
                Expr[] exprArray2 = new Expr[1];
                exprArray = exprArray2;
                exprArray2[0] = ex;
            }
            return (ExprList)exprList.add(exprArray);
        };
        int el = this.exprs.length;
        ExprList lefts = new ExprList().add(entries.apply(this.exprs[0]));
        for (int e = 1; e < el && !lefts.isEmpty(); ++e) {
            ExprList curr = entries.apply(this.exprs[e]);
            for (int c = lefts.size() - 1; c >= 0; --c) {
                if (curr.contains((Expr)lefts.get(c))) continue;
                lefts.remove(c);
            }
        }
        if (lefts.isEmpty()) {
            return null;
        }
        QueryBiFunction<Boolean, Expr[], Expr> f = (invert, args) -> ((Expr[])args).length == 1 ? args[0] : ((Expr)newExpr.apply((Boolean)invert, (Expr[])args)).optimize(cc);
        Expr left = f.apply(true, (Expr[])lefts.toArray());
        ExprList rights = new ExprList(this.exprs.length);
        for (Expr expr : this.exprs) {
            ExprList curr = entries.apply(expr).removeAll(lefts);
            if (curr.isEmpty()) {
                return left.seqType().type instanceof NodeType && !left.ddo() ? cc.function(Function._UTIL_DDO, this.info, left) : left;
            }
            if (curr.size() == 1) {
                rights.add((Expr)curr.get(0));
                continue;
            }
            rights.add(f.apply(true, (Expr[])curr.finish()));
        }
        return f.apply(true, new Expr[]{left, f.apply(false, (Expr[])rights.finish())});
    }

    protected static boolean mayBePositional(Expr expr) {
        return expr.seqType().mayBeNumber() || expr.has(Flag.POS);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return Arr.visitAll(visitor, this.exprs);
    }

    @Override
    public final Expr[] args() {
        return this.exprs;
    }

    public final void arg(int a, QueryFunction<Expr, Expr> rewrite) throws QueryException {
        this.exprs[a] = rewrite.apply(this.arg(a));
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (Expr expr : this.exprs) {
            size += expr.exprSize();
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Arr && Array.equals(this.exprs, ((Arr)obj).exprs);
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), this.exprs);
    }
}

