/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.basex.build.DirParser;
import org.basex.core.Context;
import org.basex.core.Datas;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Open;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryInput;
import org.basex.query.QueryResource;
import org.basex.query.StaticContext;
import org.basex.query.util.list.ItemList;
import org.basex.query.util.pkg.ModuleLoader;
import org.basex.query.value.Value;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.DBNodeSeq;
import org.basex.query.value.seq.DBNodes;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public final class QueryResources {
    private final QueryContext qc;
    private ModuleLoader modules;
    private final ArrayList<Value> colls = new ArrayList(1);
    private final ArrayList<String> collNames = new ArrayList(1);
    private boolean globalData;
    private final ArrayList<Data> datas = new ArrayList(1);
    private final Map<Class<? extends QueryResource>, QueryResource> external = new HashMap<Class<? extends QueryResource>, QueryResource>();
    private final Map<String, Value> functions = new HashMap<String, Value>();
    private final ArrayList<InputStream> inputs = new ArrayList(1);
    private Map<String, String[]> texts;
    private Map<String, IO> stop;
    private Map<String, IO> thes;

    QueryResources(QueryContext qc) {
        this.qc = qc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Value compile(DBNodes nodes) {
        Data data = this.addData(nodes.data());
        Datas datas = this.qc.context.datas;
        synchronized (datas) {
            this.qc.context.datas.pin(data);
        }
        this.globalData = true;
        boolean all = nodes.all();
        Value value = DBNodeSeq.get(new IntList(nodes.pres()), data, all, all);
        Value coll = all ? value : DBNodeSeq.get(data.resources.docs(), data, true, true);
        this.addCollection(coll, data.meta.name);
        return value;
    }

    void close() {
        for (Data data : this.datas) {
            Close.close(data, this.qc.context);
        }
        this.datas.clear();
        if (this.modules != null) {
            this.modules.close();
        }
        this.modules = null;
        for (QueryResource c : this.external.values()) {
            c.close();
        }
        this.external.clear();
        for (InputStream is : this.inputs) {
            try {
                is.close();
            }
            catch (IOException ex) {
                Util.debug(ex);
            }
        }
        this.inputs.clear();
    }

    Data globalData() {
        return this.globalData ? this.datas.get(0) : null;
    }

    public synchronized <R extends QueryResource> R index(Class<? extends R> resource) {
        QueryResource value = this.external.get(resource);
        if (value == null) {
            try {
                value = (QueryResource)resource.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.external.put(resource, value);
            }
            catch (Throwable ex) {
                throw Util.notExpected(ex, new Object[0]);
            }
        }
        return (R)value;
    }

    public synchronized void add(InputStream input) {
        this.inputs.add(input);
    }

    public synchronized void remove(InputStream input) throws IOException {
        this.inputs.remove(input);
        input.close();
    }

    public synchronized Value functions(String path) {
        return this.functions.get(path);
    }

    public synchronized void addFunctions(String path, Value funcs) {
        this.functions.put(path, funcs);
    }

    public synchronized Data database(String name, InputInfo ii) throws QueryException {
        Context ctx = this.qc.context;
        boolean mainmem = ctx.options.get(MainOptions.MAINMEM);
        for (Data data : this.datas) {
            if (data.inMemory() && !mainmem || !IO.equals(data.meta.name, name)) continue;
            return data;
        }
        if (!ctx.perm(Perm.READ, name)) {
            throw QueryError.BASEX_PERMISSION_X_X.get(ii, new Object[]{Perm.READ, name});
        }
        try {
            return this.addData(Open.open(name, ctx, ctx.options, true, false));
        }
        catch (IOException ex) {
            throw QueryError.DB_OPEN2_X.get(ii, ex);
        }
    }

    public synchronized DBNode doc(QueryInput qi, InputInfo ii) throws QueryException {
        int pre;
        Data data;
        MainOptions options = this.qc.context.options;
        if (options.get(MainOptions.WITHDB).booleanValue() && options.get(MainOptions.DEFAULTDB).booleanValue() && (data = this.globalData()) != null && (pre = data.resources.doc(qi.original)) != -1) {
            return new DBNode(data, pre, 0);
        }
        data = this.data(true, qi, ii);
        IntList docs = data.resources.docs(qi.dbPath);
        if (docs.size() == 1) {
            return new DBNode(data, docs.get(0), 0);
        }
        throw (docs.isEmpty() ? QueryError.BASEX_DBPATH1_X : QueryError.BASEX_DBPATH2_X).get(ii, qi.original);
    }

    public synchronized Value collection(QueryInput qi, InputInfo ii) throws QueryException {
        Context ctx = this.qc.context;
        boolean withdb = ctx.options.get(MainOptions.WITHDB);
        if (qi == null) {
            if (!withdb || this.colls.isEmpty()) {
                throw QueryError.NODEFCOLL.get(ii, new Object[0]);
            }
            return this.colls.get(0);
        }
        MainOptions options = this.qc.context.options;
        if (withdb) {
            Data data;
            if (options.get(MainOptions.DEFAULTDB).booleanValue() && (data = this.globalData()) != null) {
                IntList pres = data.resources.docs(qi.original);
                return DBNodeSeq.get(pres, data, true, qi.original.isEmpty());
            }
            int cs = this.colls.size();
            for (int c = 0; c < cs; ++c) {
                if (!IO.equals(this.collNames.get(c), qi.io.path())) continue;
                return this.colls.get(c);
            }
        }
        Data data = this.data(false, qi, ii);
        IntList docs = data.resources.docs(qi.dbPath);
        return DBNodeSeq.get(docs, data, true, qi.dbPath.isEmpty());
    }

    public ModuleLoader modules() {
        if (this.modules == null) {
            this.modules = new ModuleLoader(this.qc.context);
        }
        return this.modules;
    }

    public void remove(String name) {
        int d;
        boolean mainmem = this.qc.context.options.get(MainOptions.MAINMEM);
        int ds = this.datas.size();
        int n = d = this.globalData ? 1 : 0;
        while (d < ds) {
            Data data = this.datas.get(d);
            if (data.meta.name.equals(name) && !data.inMemory() && !mainmem) {
                Close.close(data, this.qc.context);
                this.datas.remove(d);
                break;
            }
            ++d;
        }
    }

    public String[] text(IO io) {
        if (this.texts == null) {
            return null;
        }
        String[] pathEnc = this.texts.get(io.path());
        if (pathEnc == null) {
            pathEnc = this.texts.get(io.name());
        }
        return pathEnc;
    }

    IO stopWords(String path, StaticContext sc) {
        return this.stop != null ? this.stop.get(path) : sc.resolve(path);
    }

    IO thesaurus(String path, StaticContext sc) {
        return this.thes != null ? this.thes.get(path) : sc.resolve(path);
    }

    public void addDoc(String name, String path, StaticContext sc) throws QueryException {
        QueryInput qi = new QueryInput(path, sc);
        Data data = this.create(qi, null, true);
        if (name != null) {
            data.meta.original = name;
        }
    }

    public void addText(String uri, String ... strings) {
        if (this.texts == null) {
            this.texts = new HashMap<String, String[]>();
        }
        this.texts.put(uri, strings);
    }

    public void addCollection(String name, String[] paths, StaticContext sc) throws QueryException {
        ItemList items = new ItemList(paths.length);
        for (String path : paths) {
            QueryInput qi = new QueryInput(path, sc);
            items.add(new DBNode(this.create(qi, null, false), 0, 0));
        }
        this.addCollection(items.value(NodeType.DOCUMENT_NODE), name);
    }

    public void ftmaps(HashMap<String, IO> sw, HashMap<String, IO> th) {
        this.stop = sw;
        this.thes = th;
    }

    private Data data(boolean single, QueryInput qi, InputInfo ii) throws QueryException {
        Data data;
        Context ctx = this.qc.context;
        boolean withdb = ctx.options.get(MainOptions.WITHDB);
        String dbName = qi.dbName;
        for (Data data2 : this.datas) {
            boolean mem = data2.inMemory();
            if (!withdb && !mem) continue;
            String original = data2.meta.original;
            if (!original.isEmpty() && IO.get(original).eq(qi.io)) {
                qi.dbPath = "";
                return data2;
            }
            if (!IO.equals(data2.meta.name, dbName) || mem && ctx.soptions.dbExists(dbName)) continue;
            return data2;
        }
        if (withdb && dbName != null) {
            if (!ctx.perm(Perm.READ, dbName)) {
                throw QueryError.BASEX_PERMISSION_X_X.get(ii, new Object[]{Perm.READ, dbName});
            }
            try {
                data = Open.open(dbName, ctx, ctx.options, false, false);
                if (data != null) {
                    return this.addData(data);
                }
            }
            catch (IOException ex) {
                throw QueryError.IOERR_X.get(ii, ex);
            }
        }
        data = this.create(qi, ii, single);
        qi.dbPath = "";
        return data;
    }

    private Data create(QueryInput input, InputInfo ii, boolean single) throws QueryException {
        Data data;
        Context context = this.qc.context;
        if (!context.user().has(Perm.READ)) {
            throw QueryError.XQUERY_PERMISSION1_X.get(ii, Util.info(Text.PERM_REQUIRED_X, new Object[]{Perm.READ}));
        }
        IO io = input.io;
        if (!io.exists()) {
            throw QueryError.WHICHRES_X.get(ii, io.path());
        }
        if (single && io instanceof IOFile && io.isDir()) {
            throw QueryError.RESDIR_X.get(ii, io.path());
        }
        boolean mem = context.options.get(MainOptions.FORCECREATE) == false;
        MainOptions opts = new MainOptions(context.options, single);
        DirParser parser = new DirParser(io, opts);
        try {
            data = CreateDB.create(io.dbName(), parser, context, opts, mem);
        }
        catch (IOException ex) {
            throw QueryError.IOERR_X.get(ii, ex);
        }
        return this.addData(data);
    }

    private Data addData(Data data) {
        this.datas.add(data);
        return data;
    }

    private void addCollection(Value coll, String name) {
        this.colls.add(coll);
        this.collNames.add(name);
    }
}

