/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.json;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.json.JsonSerializer;
import org.basex.query.QueryError;
import org.basex.query.util.ft.FTPos;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.util.Token;

public final class JsonMLSerializer
extends JsonSerializer {
    private boolean att;

    public JsonMLSerializer(OutputStream os, SerializerOptions sopts) throws IOException {
        super(os, sopts);
    }

    @Override
    protected void startOpen(QNm name) throws IOException {
        if (this.level != 0) {
            this.out.print(44);
            this.indent();
        }
        this.out.print("[\"");
        for (byte ch : name.local()) {
            this.printChar(ch);
        }
        this.out.print(34);
        this.att = false;
    }

    @Override
    protected void namespace(byte[] prefix, byte[] uri, boolean standalone) {
    }

    @Override
    protected void attribute(byte[] name, byte[] value, boolean standalone) throws IOException {
        this.out.print(",");
        this.out.print(32);
        if (!this.att) {
            this.out.print("{");
            this.att = true;
        }
        this.out.print(34);
        for (byte ch : Token.local(name)) {
            this.printChar(ch);
        }
        this.out.print("\":\"");
        for (byte ch : Token.normalize(value, this.form)) {
            this.printChar(ch);
        }
        this.out.print("\"");
    }

    @Override
    protected void finishOpen() throws IOException {
        if (this.att) {
            this.out.print("}");
        }
    }

    @Override
    protected void text(byte[] value, FTPos ftp) throws IOException {
        this.out.print(44);
        this.indent();
        this.out.print(34);
        for (byte ch : value) {
            this.printChar(ch);
        }
        this.out.print(34);
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.finishOpen();
        this.out.print(93);
    }

    @Override
    protected void finishClose() throws IOException {
        this.out.print(93);
    }

    @Override
    protected void atomic(Item value) throws IOException {
        throw QueryError.JSON_SERIALIZE_X.getIO("Atomic values cannot be serialized");
    }
}

