/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.csv;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.io.parse.csv.CsvXQueryConverter;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.csv.CsvSerializer;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.value.Value;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.XQMap;
import org.basex.util.list.TokenList;

public final class CsvXQuerySerializer
extends CsvSerializer {
    public CsvXQuerySerializer(OutputStream os, SerializerOptions sopts) throws IOException {
        super(os, sopts);
    }

    @Override
    public void serialize(Item item) throws IOException {
        if (this.sep && this.level == 0) {
            this.out.print(32);
        }
        if (!(item instanceof XQMap)) {
            throw QueryError.CSV_SERIALIZE_X_X.getIO("Top level must be a map, found", item.type);
        }
        XQMap m = (XQMap)item;
        TokenList tl = new TokenList();
        try {
            if (this.header) {
                if (!m.contains(CsvXQueryConverter.NAMES, null)) {
                    throw QueryError.CSV_SERIALIZE_X.getIO("Map has no 'names' key");
                }
                this.record(m.get(CsvXQueryConverter.NAMES, null), tl);
            }
            if (!m.contains(CsvXQueryConverter.RECORDS, null)) {
                throw QueryError.CSV_SERIALIZE_X.getIO("Map has no 'records' key");
            }
            for (Item record : m.get(CsvXQueryConverter.RECORDS, null)) {
                this.record(record, tl);
            }
        }
        catch (QueryException ex) {
            throw new QueryIOException(ex);
        }
        this.sep = true;
    }

    private void record(Value line, TokenList tl) throws QueryException, IOException {
        if (!(line instanceof XQArray)) {
            throw QueryError.CSV_SERIALIZE_X_X.getIO("Array expected, found", line.seqType());
        }
        for (Value entry : ((XQArray)line).members()) {
            if (!entry.isItem()) {
                throw QueryError.CSV_SERIALIZE_X_X.getIO("Item expected, found" + entry.seqType());
            }
            tl.add(((Item)entry).string(null));
        }
        this.record(tl);
    }
}

