/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.basex.build.csv.CsvOptions;
import org.basex.build.csv.CsvSerialOptions;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.StandardSerializer;
import org.basex.query.QueryError;
import org.basex.query.value.item.Item;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.TokenList;

abstract class CsvSerializer
extends StandardSerializer {
    final CsvSerialOptions copts;
    final int separator;
    final boolean quotes;
    final boolean backslashes;
    Pattern allow;
    boolean header;

    CsvSerializer(OutputStream os, SerializerOptions sopts) throws IOException {
        super(os, sopts);
        this.copts = sopts.get(SerializerOptions.CSV);
        this.quotes = this.copts.get(CsvOptions.QUOTES);
        this.backslashes = this.copts.get(CsvOptions.BACKSLASHES);
        this.header = this.copts.get(CsvOptions.HEADER);
        String allw = this.copts.get(CsvSerialOptions.ALLOW);
        if (!allw.isEmpty()) {
            try {
                this.allow = Pattern.compile(allw);
            }
            catch (PatternSyntaxException ex) {
                Util.debug(ex);
                throw QueryError.CSV_SERIALIZE_X_X.getIO("Invalid pattern", allw);
            }
        }
        this.separator = this.copts.separator();
    }

    final void record(TokenList entries) throws IOException {
        int fs = entries.size();
        for (int i = 0; i < fs; ++i) {
            boolean special;
            byte[] v = (byte[])entries.get(i);
            if (i != 0) {
                this.out.print(this.separator);
            }
            byte[] txt = Token.EMPTY;
            if (v != null) {
                txt = v;
                if (this.allow != null && !this.allow.matcher(Token.string(v)).matches()) {
                    throw QueryError.CSV_SERIALIZE_X_X.getIO("Value is not allowed", v);
                }
            }
            boolean delim = Token.contains(txt, this.separator) || Token.contains(txt, 10);
            boolean bl = special = Token.contains(txt, 13) || Token.contains(txt, 9) || Token.contains(txt, 34);
            if (delim || special || this.backslashes && Token.contains(txt, 92)) {
                TokenBuilder tb = new TokenBuilder();
                if (delim && !this.backslashes && !this.quotes) {
                    throw QueryError.CSV_SERIALIZE_X_X.getIO("Output must be put into quotes", txt);
                }
                if (this.quotes && (delim || special)) {
                    tb.add(34);
                }
                int len = txt.length;
                for (int c = 0; c < len; c += Token.cl(txt, c)) {
                    int cp = Token.cp(txt, c);
                    if (this.backslashes) {
                        if (cp == 10) {
                            tb.add("\\n");
                            continue;
                        }
                        if (cp == 13) {
                            tb.add("\\r");
                            continue;
                        }
                        if (cp == 9) {
                            tb.add("\\t");
                            continue;
                        }
                        if (cp == 34) {
                            tb.add("\\\"");
                            continue;
                        }
                        if (cp == 92) {
                            tb.add("\\\\");
                            continue;
                        }
                        if (cp == this.separator && !this.quotes) {
                            tb.add(92).add(cp);
                            continue;
                        }
                        tb.add(cp);
                        continue;
                    }
                    if (cp == 34) {
                        tb.add(34);
                    }
                    tb.add(cp);
                }
                if (this.quotes && (delim || special)) {
                    tb.add(34);
                }
                txt = tb.finish();
            }
            this.out.print(txt);
        }
        this.out.print(10);
        entries.reset();
    }

    @Override
    protected void atomic(Item value) throws IOException {
        throw QueryError.CSV_SERIALIZE_X.getIO("Atomic values cannot be serialized");
    }
}

