/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import java.text.Normalizer;
import java.util.Map;
import org.basex.io.in.TextInput;
import org.basex.io.serial.OutputSerializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.StrLazy;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public abstract class StandardSerializer
extends OutputSerializer {
    protected final Normalizer.Form form;
    protected final IntObjMap<byte[]> map;
    protected boolean sep;
    protected boolean atomic;

    protected StandardSerializer(OutputStream os, SerializerOptions sopts) throws IOException {
        super(os, sopts);
        String norm = sopts.get(SerializerOptions.NORMALIZATION_FORM);
        if (norm.equals(SerializerOptions.NORMALIZATION_FORM.value())) {
            this.form = null;
        } else {
            try {
                this.form = Normalizer.Form.valueOf(norm);
            }
            catch (IllegalArgumentException ex) {
                Util.debug(ex);
                throw QueryError.SERNORM_X.getIO(norm);
            }
        }
        String maps = sopts.get(SerializerOptions.USE_CHARACTER_MAPS);
        if (maps.isEmpty()) {
            this.map = null;
        } else {
            this.map = new IntObjMap();
            for (Map.Entry<String, String> entry : sopts.toMap(SerializerOptions.USE_CHARACTER_MAPS).entrySet()) {
                String key = entry.getKey();
                if (key.length() != 1) {
                    throw QueryError.SERMAP_X.getIO(key);
                }
                this.map.put(key.charAt(0), Token.token(entry.getValue()));
            }
        }
    }

    @Override
    public void serialize(Item item) throws IOException {
        if (this.separate()) {
            this.sep = false;
        }
        super.serialize(item);
    }

    @Override
    public void reset() {
        this.sep = false;
        this.atomic = false;
        super.reset();
    }

    @Override
    protected void node(ANode node) throws IOException {
        Type type = node.type;
        if (type == NodeType.ATTRIBUTE) {
            throw QueryError.SERATTR_X.getIO(node);
        }
        if (type == NodeType.NAMESPACE_NODE) {
            throw QueryError.SERNS_X.getIO(node);
        }
        super.node(node);
    }

    @Override
    protected void function(FItem item) throws IOException {
        if (!(item instanceof XQArray)) {
            throw QueryError.SERFUNC_X.getIO(item.seqType());
        }
        for (Value value : ((XQArray)item).members()) {
            for (Item it : value) {
                this.serialize(it);
            }
        }
    }

    @Override
    protected void atomic(Item item) throws IOException {
        block11: {
            if (this.sep && this.atomic) {
                this.out.print(32);
            }
            try {
                if (item instanceof StrLazy && this.form == null) {
                    try (TextInput ti = item.stringInput(null);){
                        int cp;
                        while ((cp = ti.read()) != -1) {
                            this.printChar(cp);
                        }
                        break block11;
                    }
                }
                this.printChars(Token.normalize(item.string(null), this.form));
            }
            catch (QueryException ex) {
                throw new QueryIOException(ex);
            }
        }
        this.sep = true;
        this.atomic = true;
    }

    @Override
    protected final void printChar(int cp) throws IOException {
        if (!this.characterMap(cp)) {
            this.print(cp);
        }
    }

    protected void print(int cp) throws IOException {
        this.out.print(cp);
    }

    protected final boolean characterMap(int cp) throws IOException {
        byte[] value;
        if (this.map != null && (value = this.map.get(cp)) != null) {
            this.out.print(value);
            return true;
        }
        return false;
    }

    static ItemList flatten(XQArray array) {
        ItemList list = new ItemList();
        for (Value value : array.members()) {
            for (Item item : value) {
                if (item instanceof XQArray) {
                    list.add(StandardSerializer.flatten((XQArray)item));
                    continue;
                }
                list.add(item);
            }
        }
        return list;
    }
}

