/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.io.in.BufferInput;
import org.basex.io.serial.AdaptiveSerializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.XQMap;

public final class BaseXSerializer
extends AdaptiveSerializer {
    private final boolean binary;
    private int nested;

    BaseXSerializer(OutputStream os, SerializerOptions sopts) throws IOException {
        super(os, sopts, false);
        this.binary = sopts.yes(SerializerOptions.BINARY);
    }

    @Override
    protected void atomic(Item item) throws IOException {
        if (this.nested == 0) {
            try {
                if (this.binary && item instanceof Bin) {
                    try (BufferInput bi = item.input(null);){
                        int b;
                        while ((b = bi.read()) != -1) {
                            this.out.write(b);
                        }
                    }
                }
                this.printChars(item.string(null));
            }
            catch (QueryException ex) {
                throw new QueryIOException(ex);
            }
        } else {
            super.atomic(item);
        }
    }

    @Override
    protected void array(XQArray item) throws IOException {
        ++this.nested;
        super.array(item);
        --this.nested;
    }

    @Override
    protected void map(XQMap item) throws IOException {
        ++this.nested;
        super.map(item);
        --this.nested;
    }
}

