/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import java.util.ArrayList;
import java.util.Stack;
import org.basex.build.json.JsonOptions;
import org.basex.build.json.JsonParserOptions;
import org.basex.io.parse.json.JsonConstants;
import org.basex.io.parse.json.JsonConverter;
import org.basex.query.QueryError;
import org.basex.query.QueryIOException;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.node.FNode;
import org.basex.util.Token;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.BoolList;
import org.basex.util.list.ByteList;

abstract class JsonXmlConverter
extends JsonConverter {
    static final QNm Q_JSON = new QNm(JsonConstants.JSON);
    static final QNm Q_PAIR = new QNm(JsonConstants.PAIR);
    static final QNm Q_ITEM = new QNm(JsonConstants.ITEM);
    static final QNm Q_NAME = new QNm(JsonConstants.NAME);
    static final QNm Q_KEY = new QNm(JsonConstants.KEY);
    static final QNm Q_ESCAPED_KEY = new QNm(JsonConstants.ESCAPED_KEY);
    static final QNm Q_ESCAPED = new QNm(JsonConstants.ESCAPED);
    final Stack<FBuilder> stack = new Stack();
    final BoolList addValues = new BoolList();
    private final TokenObjMap<TypeCache> names = new TokenObjMap();
    private final boolean merge = this.jopts.get(JsonOptions.MERGE);
    private final boolean strings = this.jopts.get(JsonOptions.STRINGS);
    FBuilder doc;
    FBuilder curr;
    byte[] name;

    JsonXmlConverter(JsonParserOptions opts) throws QueryIOException {
        super(opts);
        this.addValues.add(true);
        JsonParserOptions.JsonDuplicates dupl = this.jopts.get(JsonParserOptions.DUPLICATES);
        if (dupl == JsonParserOptions.JsonDuplicates.USE_LAST) {
            throw new QueryIOException(QueryError.JSON_OPTIONS_X.get(null, new Object[]{JsonParserOptions.DUPLICATES.name(), dupl}));
        }
    }

    @Override
    final void init(String uri) {
        this.doc = FDoc.build(Token.token(uri));
    }

    @Override
    FNode finish() {
        if (this.merge) {
            ByteList[] types = new ByteList[JsonConstants.ATTRS.length];
            block0: for (TypeCache arr : this.names.values()) {
                if (arr == null) continue;
                int tl = JsonConstants.TYPES.length;
                for (int i = 0; i < tl; ++i) {
                    if (arr.type != JsonConstants.TYPES[i] || !this.strings && arr.type == JsonConstants.STRING) continue;
                    if (types[i] == null) {
                        types[i] = new ByteList();
                    } else {
                        types[i].add(32);
                    }
                    types[i].add(arr.name);
                    continue block0;
                }
            }
            int tl = types.length;
            for (int t = 0; t < tl; ++t) {
                if (types[t] == null) continue;
                this.curr.add(this.shared.qname(JsonConstants.ATTRS[t]), this.shared.token(types[t].finish()));
            }
        }
        return this.doc.add(this.curr).finish();
    }

    @Override
    void numberLit(byte[] value) throws QueryIOException {
        this.addValue(JsonConstants.NUMBER, value);
    }

    @Override
    void stringLit(byte[] value) throws QueryIOException {
        this.addValue(JsonConstants.STRING, value);
    }

    @Override
    void nullLit() throws QueryIOException {
        this.addValue(JsonConstants.NULL, null);
    }

    @Override
    void booleanLit(byte[] value) throws QueryIOException {
        this.addValue(JsonConstants.BOOLEAN, value);
    }

    abstract void addValue(byte[] var1, byte[] var2) throws QueryIOException;

    final void processType(FBuilder elem, byte[] type) {
        if (this.merge && this.name != null && !Token.contains(this.name, 32)) {
            if (this.names.contains(this.name)) {
                TypeCache cache = this.names.get(this.name);
                if (cache != null && cache.type == type) {
                    cache.add(elem);
                } else {
                    if (cache != null) {
                        for (FBuilder val : cache.vals) {
                            this.addType(val, cache.type);
                        }
                        this.names.put(this.name, null);
                    }
                    this.addType(elem, type);
                }
            } else {
                this.names.put(this.name, new TypeCache(this.name, type, elem));
            }
        } else {
            this.addType(elem, type);
        }
    }

    private void addType(FBuilder elem, byte[] type) {
        if (this.strings || type != JsonConstants.STRING) {
            elem.add(this.shared.qname(JsonConstants.TYPE), type);
        }
    }

    private static final class TypeCache {
        private final ArrayList<FBuilder> vals = new ArrayList(1);
        private final byte[] type;
        private final byte[] name;

        private TypeCache(byte[] name, byte[] type, FBuilder elem) {
            this.name = name;
            this.type = type;
            this.add(elem);
        }

        private void add(FBuilder elem) {
            this.vals.add(elem);
        }
    }
}

