/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import org.basex.build.json.JsonParserOptions;
import org.basex.io.parse.json.JsonConstants;
import org.basex.io.parse.json.JsonXmlConverter;
import org.basex.query.QueryIOException;
import org.basex.query.QueryText;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.util.Token;

public final class JsonBasicConverter
extends JsonXmlConverter {
    private final boolean escape;

    JsonBasicConverter(JsonParserOptions opts) throws QueryIOException {
        super(opts);
        this.escape = this.jopts.get(JsonParserOptions.ESCAPE);
    }

    @Override
    void openObject() {
        this.openOuter(JsonConstants.MAP);
    }

    @Override
    void closeObject() {
        this.closeOuter();
    }

    @Override
    void openPair(byte[] key, boolean add) {
        this.addValues.add(add);
        if (add) {
            this.name = this.shared.token(key);
        }
    }

    @Override
    void closePair(boolean add) {
        this.addValues.pop();
    }

    @Override
    void openArray() {
        this.openOuter(JsonConstants.ARRAY);
    }

    @Override
    void closeArray() {
        this.closeOuter();
    }

    @Override
    void openItem() {
    }

    @Override
    void closeItem() {
    }

    @Override
    void addValue(byte[] type, byte[] value) {
        if (this.addValues.peek()) {
            byte[] val = value != null ? this.shared.token(value) : null;
            FBuilder elem = this.element(type).add(val);
            if (this.escape && value != null && Token.contains(val, 92)) {
                elem.add(Q_ESCAPED, Token.TRUE);
            }
            if (this.curr != null) {
                this.curr.add(elem);
            } else {
                this.curr = elem;
            }
        }
    }

    private void openOuter(byte[] type) {
        this.curr = this.element(type);
        if (this.stack.isEmpty()) {
            this.curr.declareNS();
        }
        this.stack.push(this.curr);
    }

    private void closeOuter() {
        this.curr = (FBuilder)this.stack.pop();
        if (!this.stack.isEmpty()) {
            this.curr = ((FBuilder)this.stack.peek()).add(this.curr);
        }
    }

    private FBuilder element(byte[] type) {
        FBuilder elem = FElem.build(this.shared.qname(type, QueryText.FN_URI));
        if (this.name != null) {
            elem.add(Q_KEY, this.name);
            if (this.escape && Token.contains(this.name, 92)) {
                elem.add(Q_ESCAPED_KEY, Token.TRUE);
            }
            this.name = null;
        }
        return elem;
    }
}

