/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.csv;

import java.io.IOException;
import org.basex.build.csv.CsvOptions;
import org.basex.build.csv.CsvParserOptions;
import org.basex.core.jobs.Job;
import org.basex.io.IO;
import org.basex.io.in.NewlineInput;
import org.basex.io.parse.csv.CsvDirectConverter;
import org.basex.io.parse.csv.CsvParser;
import org.basex.io.parse.csv.CsvXQueryConverter;
import org.basex.query.util.SharedData;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.util.list.TokenList;

public abstract class CsvConverter
extends Job {
    protected static final QNm Q_CSV = new QNm("csv");
    protected static final QNm Q_RECORD = new QNm("record");
    protected static final QNm Q_ENTRY = new QNm("entry");
    protected static final QNm Q_NAME = new QNm("name");
    protected final SharedData shared = new SharedData();
    protected final TokenList headers = new TokenList(1L);
    protected final boolean attributes;
    protected final boolean lax;
    protected final boolean skipEmpty;
    protected NewlineInput nli;
    protected int column = -1;
    private final CsvParserOptions copts;

    protected CsvConverter(CsvParserOptions copts) {
        this.copts = copts;
        this.lax = copts.get(CsvOptions.LAX);
        this.attributes = copts.get(CsvOptions.FORMAT) == CsvOptions.CsvFormat.ATTRIBUTES;
        this.skipEmpty = copts.get(CsvParserOptions.SKIP_EMPTY) != false && copts.get(CsvOptions.HEADER) != false;
    }

    public final Item convert(IO input) throws IOException {
        this.init(input.url());
        try (NewlineInput in = new NewlineInput(input);){
            this.nli = in.encoding(this.copts.get(CsvParserOptions.ENCODING));
            new CsvParser(in, this.copts, this).parse();
        }
        return this.finish();
    }

    public static CsvConverter get(CsvParserOptions copts) {
        return copts.get(CsvOptions.FORMAT) == CsvOptions.CsvFormat.XQUERY ? new CsvXQueryConverter(copts) : new CsvDirectConverter(copts);
    }

    protected abstract void header(byte[] var1);

    protected abstract void record() throws IOException;

    protected abstract void entry(byte[] var1) throws IOException;

    protected abstract void init(String var1);

    protected abstract Item finish() throws IOException;
}

