/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.in;

import org.basex.util.Strings;
import org.basex.util.Util;
import org.basex.util.list.ByteList;

public final class TarEntry {
    private static final String LONGNAME = "././@LongLink";
    private final long size;
    private final byte type;
    private String name;

    TarEntry(byte[] buffer) {
        ByteList result = new ByteList();
        for (int i = 0; i < 100 && buffer[i] != 0; ++i) {
            result.add(buffer[i]);
        }
        this.name = TarEntry.name(result);
        long s = 0L;
        boolean p = true;
        for (int i = 124; i < 136; ++i) {
            byte b = buffer[i];
            if (p && (b == 32 || b == 48)) continue;
            if (b == 0 || b == 32) break;
            s = (s << 3) + (long)(b - 48);
            p = false;
        }
        this.size = s;
        this.type = buffer[156];
    }

    public long getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String nm) {
        this.name = nm;
    }

    public boolean isDirectory() {
        return this.type == 53 || Strings.endsWith(this.name, '/');
    }

    public boolean isLongName() {
        return this.type == 76 && this.name.equals(LONGNAME);
    }

    static String name(ByteList result) {
        try {
            return new String(result.toArray());
        }
        catch (Exception ex) {
            Util.debug(ex);
            return result.toString();
        }
    }

    public String toString() {
        return Util.className(this) + "[" + this.name + ", " + this.size + " bytes]";
    }
}

