/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.plot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPopup;
import org.basex.gui.layout.BaseXSlider;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewData;
import org.basex.gui.view.ViewNotifier;
import org.basex.gui.view.ViewRect;
import org.basex.gui.view.plot.PlotAxis;
import org.basex.gui.view.plot.PlotData;
import org.basex.index.stats.StatsType;
import org.basex.query.value.seq.DBNodes;
import org.basex.util.Token;
import org.basex.util.list.IntList;

public final class PlotView
extends View {
    static final int CAPTIONWHITESPACE = 10;
    private static final double ROTATE = StrictMath.sin(30.0);
    private static final int[] MARGIN = new int[4];
    private static final int MAXL = 11;
    private static final int CUTOFF = 10;
    private final BaseXCombo xCombo;
    private final BaseXCombo yCombo;
    private final BaseXCombo itemCombo;
    private final BaseXSlider dots;
    private PlotData plotData;
    private boolean plotChanged;
    private boolean drawSubNodes;
    private boolean markingChanged;
    private final BaseXCheckBox xLog;
    private final BaseXCheckBox yLog;
    private final ViewRect selectionBox;
    private BufferedImage itemImg;
    private BufferedImage itemImgMarked;
    private BufferedImage itemImgFocused;
    private BufferedImage itemImgSub;
    private BufferedImage plotImg;
    private BufferedImage markedImg;
    private int mouseX;
    private int mouseY;
    private int plotHeight;
    private int plotWidth;
    private boolean dragging;
    private boolean rightClick;
    private DBNodes nextContext;

    public PlotView(ViewNotifier notifier) {
        super("plot", notifier);
        this.border(5).layout(new BorderLayout());
        BaseXBack panel = new BaseXBack(false).layout(new BorderLayout());
        Box box = new Box(0);
        this.xLog = new BaseXCheckBox(this.gui, "log", false);
        this.xLog.setSelected(this.gui.gopts.get(GUIOptions.PLOTXLOG));
        this.xLog.addActionListener(e -> {
            this.gui.gopts.invert(GUIOptions.PLOTXLOG);
            this.refreshUpdate();
        });
        this.dots = new BaseXSlider(this.gui, -6, 6, GUIOptions.PLOTDOTS, this.gui.gopts);
        this.dots.addActionListener(e -> {
            this.dots.assign();
            this.refreshLayout();
        });
        BaseXLayout.setWidth(this.dots, 40);
        this.yLog = new BaseXCheckBox(this.gui, "log", false);
        this.yLog.setSelected(this.gui.gopts.get(GUIOptions.PLOTYLOG));
        this.yLog.addActionListener(e -> {
            this.gui.gopts.invert(GUIOptions.PLOTYLOG);
            this.refreshUpdate();
        });
        box.add(this.yLog);
        box.add(Box.createHorizontalGlue());
        box.add(this.dots);
        box.add(Box.createHorizontalGlue());
        box.add(this.xLog);
        panel.add((Component)box, "North");
        box = new Box(0);
        this.xCombo = new BaseXCombo((BaseXWindow)this.gui, new String[0]);
        this.xCombo.addActionListener(e -> this.setAxis(this.plotData.xAxis, this.xCombo));
        this.yCombo = new BaseXCombo((BaseXWindow)this.gui, new String[0]);
        this.yCombo.addActionListener(e -> this.setAxis(this.plotData.yAxis, this.yCombo));
        this.itemCombo = new BaseXCombo((BaseXWindow)this.gui, new String[0]);
        this.itemCombo.addActionListener(e -> {
            String item = this.itemCombo.getSelectedItem();
            this.plotData.xAxis.log = this.gui.gopts.get(GUIOptions.PLOTXLOG);
            this.plotData.yAxis.log = this.gui.gopts.get(GUIOptions.PLOTYLOG);
            if (this.plotData.setItem(item)) {
                this.plotChanged = true;
                this.markingChanged = true;
                String[] cats = this.plotData.getCategories(Token.token(item));
                this.xCombo.setItems(cats);
                this.yCombo.setItems(cats);
                if (cats.length > 0) {
                    this.xCombo.setSelectedIndex(Math.min(1, cats.length));
                    this.yCombo.setSelectedIndex(0);
                }
            }
            this.drawSubNodes = true;
            this.markingChanged = true;
            this.repaint();
        });
        box.add(this.yCombo);
        box.add(Box.createHorizontalStrut(3));
        box.add(new BaseXLabel("Y"));
        box.add(Box.createHorizontalGlue());
        box.add(this.itemCombo);
        box.add(Box.createHorizontalGlue());
        box.add(new BaseXLabel("X"));
        box.add(Box.createHorizontalStrut(3));
        box.add(this.xCombo);
        panel.add((Component)box, "South");
        this.add((Component)panel, "South");
        new BaseXPopup(this, GUIConstants.POPUP);
        this.selectionBox = new ViewRect();
        this.refreshLayout();
    }

    private void setAxis(PlotAxis ax, BaseXCombo cb) {
        BaseXCombo ocb;
        String cs = cb.getSelectedItem();
        if (!ax.setAxis(cs)) {
            return;
        }
        this.plotChanged = true;
        this.markingChanged = true;
        this.repaint();
        BaseXCombo baseXCombo = ocb = cb == this.xCombo ? this.yCombo : this.xCombo;
        if (cs.equals(ocb.getSelectedItem())) {
            int i = ocb.getSelectedIndex();
            ocb.setSelectedIndex(i > 0 ? i - 1 : i + 1);
        }
    }

    private BufferedImage itemImage(boolean focus, boolean marked, boolean markedSub) {
        int size = Math.max(1, GUIConstants.fontSize + this.gui.gopts.get(GUIOptions.PLOTDOTS) - (focus ? 2 : (marked || markedSub ? 4 : 6)));
        BufferedImage img = new BufferedImage(size, size, 3);
        Graphics g = img.getGraphics();
        BaseXLayout.antiAlias(g);
        Color c = GUIConstants.color1A;
        if (marked) {
            c = GUIConstants.colormark1A;
        }
        if (markedSub) {
            c = GUIConstants.colormark2A;
        }
        if (focus) {
            c = GUIConstants.color4;
        }
        g.setColor(c);
        g.fillOval(0, 0, size, size);
        return img;
    }

    private void createPlotImage() {
        this.plotImg = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics g = this.plotImg.getGraphics();
        BaseXLayout.antiAlias(g);
        this.drawAxis(g, true);
        this.drawAxis(g, false);
        g.setColor(GUIConstants.color4);
        int pl = this.plotData.pres.length;
        for (int p = 0; p < pl; ++p) {
            this.drawItem(g, this.plotData.xAxis.co[p], this.plotData.yAxis.co[p], false, false, false);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int f;
        super.paintComponent(g);
        if (this.plotData == null) {
            this.refreshInit();
            return;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        this.plotWidth = w - (MARGIN[1] + MARGIN[3]);
        this.plotHeight = h - (MARGIN[0] + MARGIN[2]);
        int sz = PlotView.sizeFactor();
        g.setFont(GUIConstants.font);
        g.setColor(GUIConstants.TEXT);
        Data data = this.gui.context.data();
        if (data == null || this.plotWidth - sz < 0 || this.plotHeight - sz < 0) {
            BaseXLayout.drawCenter(g, data == null ? Text.NO_DATA : Text.NO_PIXELS, w, h / 2 - MARGIN[0]);
            return;
        }
        if (this.plotImg == null || this.plotChanged) {
            this.createPlotImage();
        }
        g.drawImage(this.plotImg, 0, 0, this);
        if (this.markingChanged || this.markedImg == null) {
            this.createMarkedNodes();
        }
        g.drawImage(this.markedImg, 0, 0, this);
        if (this.plotData.pres.length < 1) {
            return;
        }
        this.gui.painting = true;
        int focused = this.gui.context.focused;
        if (focused != -1) {
            int itmID = data.elemNames.id(this.plotData.item);
            int k = data.kind(focused);
            int name = data.nameId(focused);
            while (focused > 0 && itmID != name) {
                if ((focused = data.parent(focused, k)) <= -1) continue;
                k = data.kind(focused);
                name = data.nameId(focused);
            }
        }
        if ((f = this.plotData.findPre(focused)) > -1) {
            int ol = this.overlappingNodes(f).length;
            if (!this.dragging) {
                Object name;
                Object label;
                double x1 = this.plotData.xAxis.co[f];
                double y1 = this.plotData.yAxis.co[f];
                this.drawItem(g, x1, y1, true, false, false);
                g.setFont(GUIConstants.font);
                int textH = g.getFontMetrics().getHeight();
                String x = this.formatString(true, focused);
                String y = this.formatString(false, focused);
                Object object = label = x.length() > 16 ? x.substring(0, 14) + ".." : x;
                if (!x.isEmpty() && !y.isEmpty()) {
                    label = (String)label + " | ";
                }
                label = (String)label + (String)(y.length() > 16 ? y.substring(0, 14) + ".." : y);
                int xa = this.calcCoordinate(true, x1) + 15;
                int ya = this.calcCoordinate(false, y1) + this.gui.gopts.get(GUIOptions.PLOTDOTS);
                int ww = this.getWidth();
                int id = ViewData.labelID(data, this.gui.gopts.get(GUIOptions.LABELS));
                byte[] l = data.attValue(id, focused);
                Object object2 = name = l != null ? Token.string(l) : "";
                if (!((String)name).isEmpty() && this.plotData.xAxis.attrID != id && this.plotData.yAxis.attrID != id) {
                    if (ol > 1) {
                        name = ol + "x: " + (String)name + ", ...";
                    }
                    int lw = BaseXLayout.width(g, (String)label);
                    if (ya < MARGIN[0] + textH && xa < w - lw) {
                        ya += 2 * textH - this.gui.gopts.get(GUIOptions.PLOTDOTS);
                    }
                    if (xa > w - lw) {
                        BaseXLayout.drawTooltip(g, (String)name + ": " + (String)label, xa, ya, ww, 10);
                    } else {
                        BaseXLayout.drawTooltip(g, (String)name, xa, ya - textH, ww, 10);
                        BaseXLayout.drawTooltip(g, (String)label, xa, ya, ww, 10);
                    }
                } else {
                    if (ol > 1) {
                        label = ((String)label).isEmpty() ? ol + "x" : ol + "x: " + (String)label + ", ...";
                    }
                    BaseXLayout.drawTooltip(g, (String)label, xa, ya, ww, 10);
                }
            }
        }
        if (this.dragging) {
            int selW = this.selectionBox.w;
            int selH = this.selectionBox.h;
            int x1 = this.selectionBox.x;
            int y1 = this.selectionBox.y;
            int x = selW > 0 ? x1 : x1 + selW;
            int y = selH > 0 ? y1 : y1 + selH;
            g.setColor(GUIConstants.colormark2A);
            g.fillRect(x, y, Math.abs(selW), Math.abs(selH));
            g.setColor(GUIConstants.colormark1A);
            g.drawRect(x, y, Math.abs(selW), Math.abs(selH));
        }
        this.markingChanged = false;
        this.plotChanged = false;
        this.gui.painting = false;
    }

    private void createMarkedNodes() {
        int i;
        Data data = this.gui.context.data();
        this.markedImg = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics gi = this.markedImg.getGraphics();
        BaseXLayout.antiAlias(gi);
        DBNodes marked = this.gui.context.marked;
        if (marked.isEmpty()) {
            return;
        }
        int[] pres = marked.pres();
        int[] m = Arrays.copyOf(pres, pres.length);
        if (!this.drawSubNodes) {
            int ml = m.length;
            for (i = 0; i < ml; ++i) {
                int pi = this.plotData.findPre(m[i]);
                if (pi <= -1) continue;
                this.drawItem(gi, this.plotData.xAxis.co[pi], this.plotData.yAxis.co[pi], false, true, false);
            }
            return;
        }
        Arrays.sort(m);
        int[] p = this.plotData.pres;
        int k = this.plotData.findPre(m[0]);
        if (k > -1) {
            this.drawItem(gi, this.plotData.xAxis.co[k], this.plotData.yAxis.co[k], false, true, false);
            ++k;
        } else {
            k = -k;
            --k;
        }
        int ml = m.length;
        int pl = p.length;
        while (i < ml && k < pl) {
            int a = m[i];
            int b = p[k];
            int ns = data.size(a, data.kind(a)) - 1;
            if (a == b) {
                this.drawItem(gi, this.plotData.xAxis.co[k], this.plotData.yAxis.co[k], false, true, false);
                ++k;
                continue;
            }
            if (a + ns >= b) {
                if (a < b) {
                    this.drawItem(gi, this.plotData.xAxis.co[k], this.plotData.yAxis.co[k], false, false, true);
                }
                ++k;
                continue;
            }
            ++i;
        }
    }

    private void drawItem(Graphics g, double x, double y, boolean focus, boolean marked, boolean sub) {
        int x1 = this.calcCoordinate(true, x);
        int y1 = this.calcCoordinate(false, y);
        BufferedImage img = focus ? this.itemImgFocused : (marked ? this.itemImgMarked : (sub ? this.itemImgSub : this.itemImg));
        int size = img.getWidth() / 2;
        g.drawImage(img, x1 - size, y1 - size, this);
    }

    private void drawAxis(Graphics g, boolean drawX) {
        PlotAxis axis;
        int sz = PlotView.sizeFactor();
        int pWidth = this.plotWidth - sz;
        int pHeight = this.plotHeight - sz;
        PlotAxis plotAxis = axis = drawX ? this.plotData.xAxis : this.plotData.yAxis;
        if (this.plotChanged) {
            if (drawX) {
                if (this.plotData.pres.length > 0) {
                    axis.calcCaption(pWidth);
                }
                this.xLog.setEnabled(StatsType.isNumeric(this.plotData.xAxis.type) && Math.abs(axis.min - axis.max) >= 1.0);
            } else {
                if (this.plotData.pres.length > 0) {
                    axis.calcCaption(pHeight);
                }
                this.yLog.setEnabled(StatsType.isNumeric(this.plotData.yAxis.type) && Math.abs(axis.min - axis.max) >= 1.0);
            }
        }
        if (this.plotData.pres.length < 1) {
            this.drawCaptionAndGrid(g, drawX, "", 0.0);
            this.drawCaptionAndGrid(g, drawX, "", 1.0);
            return;
        }
        int nrCaptions = axis.nrCaptions;
        double step = axis.actlCaptionStep;
        double capRange = 1.0 / (double)(nrCaptions - 1);
        g.setFont(GUIConstants.font);
        if (StatsType.isString(axis.type)) {
            int i;
            int nrCats = axis.nrCats;
            double[] coSorted = Arrays.copyOf(axis.co, axis.co.length);
            this.drawCaptionAndGrid(g, drawX, nrCats > 1 ? Token.string(axis.firstCat) : "", 0.0);
            this.drawCaptionAndGrid(g, drawX, nrCats > 1 ? Token.string(axis.lastCat) : "", 1.0);
            if (nrCaptions == 0) {
                return;
            }
            Arrays.sort(coSorted);
            double op = capRange;
            int cl = coSorted.length;
            for (i = 0; i < cl && coSorted[i] == 0.0; ++i) {
            }
            while (i < cl && op < 1.0 - 0.4 * capRange) {
                if (coSorted[i] > op) {
                    int j;
                    double distG;
                    double distL = Math.abs(coSorted[i - 1] - op);
                    op = coSorted[distL < (distG = Math.abs(coSorted[i] - op)) ? i - 1 : i];
                    int al = axis.co.length;
                    for (j = 0; j < al && axis.co[j] != op; ++j) {
                    }
                    this.drawCaptionAndGrid(g, drawX, Token.string(axis.getValue(this.plotData.pres[j])), op);
                    op += capRange;
                }
                ++i;
            }
            if (nrCats == 1) {
                int j;
                op = 0.5;
                int al = axis.co.length;
                for (j = 0; j < al && axis.co[j] != op; ++j) {
                }
                this.drawCaptionAndGrid(g, drawX, Token.string(axis.getValue(this.plotData.pres[j])), op);
            }
        } else {
            boolean noRange = axis.max - axis.min == 0.0;
            this.drawIntermediateGridLine(g, drawX, 0.0, null);
            this.drawIntermediateGridLine(g, drawX, 1.0, null);
            if (nrCaptions == 0) {
                return;
            }
            if (noRange) {
                this.drawCaptionAndGrid(g, drawX, BaseXLayout.value(axis.min), 0.5);
                return;
            }
            if (axis.log) {
                double b;
                double last;
                int lim;
                double a;
                int l;
                if (axis.min < 0.0) {
                    l = 0;
                    a = -1.0;
                    while (a >= axis.min) {
                        if (a <= axis.max && this.adequateDistance(drawX, a, 0.0)) {
                            this.drawCaptionAndGrid(g, drawX, BaseXLayout.value(a), axis.calcPosition(a));
                        }
                        lim = (int)(-1.0 * StrictMath.pow(10.0, l + 1));
                        last = a;
                        for (b = 2.0 * a; b > (double)lim && b >= axis.min; b += a) {
                            if (!this.adequateDistance(drawX, last, b) || !this.adequateDistance(drawX, lim, b) || !(b < axis.max)) continue;
                            this.drawIntermediateGridLine(g, drawX, axis.calcPosition(b), BaseXLayout.value(b));
                            last = b;
                        }
                        a = -1.0 * StrictMath.pow(10.0, ++l);
                    }
                }
                if (axis.min <= 0.0 && axis.max >= 0.0) {
                    this.drawCaptionAndGrid(g, drawX, BaseXLayout.value(0.0), axis.calcPosition(0.0));
                }
                if (axis.max > 0.0) {
                    l = 0;
                    a = 1.0;
                    while (a <= axis.max) {
                        if (a >= axis.min && this.adequateDistance(drawX, a, 0.0)) {
                            this.drawCaptionAndGrid(g, drawX, BaseXLayout.value(a), axis.calcPosition(a));
                        }
                        lim = (int)StrictMath.pow(10.0, l + 1);
                        last = a;
                        for (b = 2.0 * a; b < (double)lim && b <= axis.max; b += a) {
                            if (!this.adequateDistance(drawX, last, b) || !this.adequateDistance(drawX, lim, b) || !(b > axis.min)) continue;
                            this.drawIntermediateGridLine(g, drawX, axis.calcPosition(b), BaseXLayout.value(b));
                            last = b;
                        }
                        a = StrictMath.pow(10.0, ++l);
                    }
                }
            } else {
                double d = axis.calcPosition(axis.startvalue);
                double f = axis.startvalue;
                int c = 0;
                while (d < 1.0 - 0.25 / (double)nrCaptions) {
                    ++c;
                    this.drawCaptionAndGrid(g, drawX, BaseXLayout.value(f), d);
                    d = axis.calcPosition(f += step);
                }
                if (c < 2) {
                    this.drawCaptionAndGrid(g, drawX, BaseXLayout.value(axis.min), 0.0);
                    this.drawCaptionAndGrid(g, drawX, BaseXLayout.value(axis.max), 1.0);
                }
            }
        }
    }

    private boolean adequateDistance(boolean drawX, double a, double b) {
        double t = drawX ? 1.8 : 1.3;
        PlotAxis axis = drawX ? this.plotData.xAxis : this.plotData.yAxis;
        return (double)Math.abs(this.calcCoordinate(drawX, axis.calcPosition(a)) - this.calcCoordinate(drawX, axis.calcPosition(b))) >= (double)PlotView.sizeFactor() / t;
    }

    private void drawCaptionAndGrid(Graphics g, boolean drawX, String caption, double d) {
        Object cap = caption;
        if (((String)cap).length() > 11) {
            cap = ((String)cap).substring(0, 10) + "..";
        }
        int pos = this.calcCoordinate(drawX, d);
        int h = this.getHeight();
        int w = this.getWidth();
        int textH = g.getFontMetrics().getHeight();
        int fs = GUIConstants.fontSize;
        int imgW = BaseXLayout.width(g, (String)cap) + fs;
        BufferedImage img = PlotView.createCaptionImage(g, (String)cap, false, imgW);
        g.setColor(GUIConstants.color(2));
        if (drawX) {
            int y = h - MARGIN[2];
            g.drawImage(img, pos - imgW + textH - fs + 3, y, this);
            g.drawLine(pos, MARGIN[0], pos, y + fs / 2);
            g.drawLine(pos - 1, MARGIN[0], pos - 1, y + fs / 2);
        } else {
            g.drawImage(img, MARGIN[1] - imgW - fs / 2, pos - fs, this);
            g.drawLine(MARGIN[1] - fs / 2, pos, w - MARGIN[3], pos);
            g.drawLine(MARGIN[1] - fs / 2, pos + 1, w - MARGIN[3], pos + 1);
        }
    }

    private static BufferedImage createCaptionImage(Graphics g, String caption, boolean im, int imgW) {
        int textH = g.getFontMetrics().getHeight();
        int fs = GUIConstants.fontSize;
        int imgH = 160;
        BufferedImage img = new BufferedImage(imgW, 160, 2);
        Graphics2D g2d = img.createGraphics();
        BaseXLayout.antiAlias(g2d);
        g2d.rotate(ROTATE, imgW, textH);
        g2d.setFont(GUIConstants.font);
        g2d.setColor(im ? GUIConstants.color3 : GUIConstants.TEXT);
        g2d.drawString(caption, fs, fs);
        return img;
    }

    private void drawIntermediateGridLine(Graphics g, boolean drawX, double d, String caption) {
        Object cap = caption;
        int pos = this.calcCoordinate(drawX, d);
        int h = this.getHeight();
        int w = this.getWidth();
        int fs = GUIConstants.fontSize;
        int sf = PlotView.sizeFactor();
        g.setColor(GUIConstants.color(2));
        if (cap != null) {
            if (((String)cap).length() > 11) {
                cap = ((String)cap).substring(0, 10) + "..";
            }
            int textH = g.getFontMetrics().getHeight();
            int imgW = BaseXLayout.width(g, (String)cap) + fs;
            BufferedImage img = PlotView.createCaptionImage(g, (String)cap, true, imgW);
            int y = h - MARGIN[2];
            if (drawX) {
                g.drawImage(img, pos - imgW + textH - fs + 3, y - textH / 3, this);
                g.drawLine(pos, MARGIN[0], pos, h - MARGIN[2]);
            } else {
                g.drawImage(img, MARGIN[1] - imgW - fs / 2, pos - fs, this);
                g.drawLine(MARGIN[1], pos, w - MARGIN[3], pos);
            }
        } else if (drawX) {
            g.drawLine(pos, MARGIN[0], pos, h - MARGIN[2] - sf);
        } else {
            g.drawLine(MARGIN[1] + sf, pos, w - MARGIN[3], pos);
        }
    }

    private int calcCoordinate(boolean drawX, double d) {
        int sz = PlotView.sizeFactor();
        if (drawX) {
            if (d == -1.0) {
                return (int)((double)MARGIN[1] + (double)sz * 0.35);
            }
            int width = this.getWidth();
            int xSpace = width - (MARGIN[1] + MARGIN[3]) - sz;
            return (int)(d * (double)xSpace) + MARGIN[1] + sz;
        }
        int h = this.getHeight();
        if (d == -1.0) {
            return h - MARGIN[2] - sz / 4;
        }
        int ySpace = h - (MARGIN[0] + MARGIN[2]) - sz;
        return ySpace - (int)(d * (double)ySpace) + MARGIN[0];
    }

    @Override
    public void refreshContext(boolean more, boolean quick) {
        this.plotData.refreshItems(this.nextContext != null && more && this.rightClick ? this.nextContext : this.gui.context.current(), !more || !this.rightClick);
        this.plotData.xAxis.log = this.gui.gopts.get(GUIOptions.PLOTXLOG);
        this.plotData.xAxis.refreshAxis();
        this.plotData.yAxis.log = this.gui.gopts.get(GUIOptions.PLOTYLOG);
        this.plotData.yAxis.refreshAxis();
        this.nextContext = null;
        this.drawSubNodes = !this.rightClick;
        this.rightClick = false;
        this.plotChanged = true;
        this.markingChanged = true;
        this.repaint();
    }

    @Override
    public void refreshFocus() {
        this.repaint();
    }

    @Override
    public void refreshInit() {
        this.plotData = null;
        Data data = this.gui.context.data();
        if (data == null || !this.visible()) {
            return;
        }
        this.plotData = new PlotData(this.gui.context);
        String[] items = this.plotData.getItems();
        this.itemCombo.setModel(new DefaultComboBoxModel<String>(items));
        if (items.length > 0) {
            this.itemCombo.setSelectedIndex(0);
        }
        this.drawSubNodes = true;
        this.markingChanged = true;
        this.plotChanged = true;
        this.repaint();
    }

    @Override
    public void refreshLayout() {
        this.itemImg = this.itemImage(false, false, false);
        this.itemImgMarked = this.itemImage(false, true, false);
        this.itemImgFocused = this.itemImage(true, false, false);
        this.itemImgSub = this.itemImage(false, false, true);
        int sz = PlotView.sizeFactor() / 2;
        PlotView.MARGIN[0] = sz + 7;
        PlotView.MARGIN[1] = sz * 6;
        PlotView.MARGIN[2] = 55 + sz * 7;
        PlotView.MARGIN[3] = sz + 3;
        this.plotChanged = true;
        this.markingChanged = true;
        if (this.plotData == null) {
            return;
        }
        this.repaint();
    }

    @Override
    public void refreshMark() {
        this.drawSubNodes = true;
        this.markingChanged = true;
        this.repaint();
    }

    @Override
    public void refreshUpdate() {
        this.refreshContext(false, true);
    }

    @Override
    public boolean visible() {
        return this.gui.gopts.get(GUIOptions.SHOWPLOT);
    }

    @Override
    public void visible(boolean v) {
        this.gui.gopts.set(GUIOptions.SHOWPLOT, v);
    }

    @Override
    protected boolean db() {
        return true;
    }

    private boolean focus() {
        int size = this.itemImg.getWidth() / 2;
        int focusedPre = this.gui.context.focused;
        if (this.mouseX < MARGIN[1] || this.mouseX > this.getWidth() - MARGIN[3] + size || this.mouseY < MARGIN[0] - size || this.mouseY > this.getHeight() - MARGIN[2]) {
            if (focusedPre == -1) {
                return false;
            }
            this.gui.notify.focus(-1, this);
            return true;
        }
        focusedPre = -1;
        int dist = Integer.MAX_VALUE;
        int pl = this.plotData.pres.length;
        for (int i = 0; i < pl && dist != 0; ++i) {
            int currDist;
            int x = this.calcCoordinate(true, this.plotData.xAxis.co[i]);
            int y = this.calcCoordinate(false, this.plotData.yAxis.co[i]);
            int distX = Math.abs(this.mouseX - x);
            int distY = Math.abs(this.mouseY - y);
            int sz = PlotView.sizeFactor() / 4;
            if (distX >= sz || distY >= sz || (currDist = distX * distY) >= dist) continue;
            dist = currDist;
            focusedPre = this.plotData.pres[i];
        }
        if (focusedPre != this.gui.context.focused) {
            this.gui.notify.focus(focusedPre, this);
            return true;
        }
        return false;
    }

    private int[] overlappingNodes(int pre) {
        IntList il = new IntList();
        int mx = this.calcCoordinate(true, this.plotData.xAxis.co[pre]);
        int my = this.calcCoordinate(false, this.plotData.yAxis.co[pre]);
        int pl = this.plotData.pres.length;
        for (int p = 0; p < pl; ++p) {
            int x = this.calcCoordinate(true, this.plotData.xAxis.co[p]);
            int y = this.calcCoordinate(false, this.plotData.yAxis.co[p]);
            if (mx != x || my != y) continue;
            il.add(this.plotData.pres[p]);
        }
        return il.finish();
    }

    private static int sizeFactor() {
        return Math.max(2, GUIConstants.fontSize << 1);
    }

    private String formatString(boolean drawX, int focused) {
        PlotAxis axis = drawX ? this.plotData.xAxis : this.plotData.yAxis;
        byte[] val = axis.getValue(focused);
        if (val.length == 0) {
            return "";
        }
        return StatsType.isString(axis.type) ? Token.string(val) : BaseXLayout.value(Token.toDouble(val));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.gui.updating || this.gui.painting) {
            return;
        }
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        if (this.focus()) {
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        boolean inBox;
        if (this.gui.updating || e.isShiftDown()) {
            return;
        }
        if (this.dragging) {
            this.mouseX = e.getX();
            this.mouseY = e.getY();
        }
        int h = this.getHeight();
        int w = this.getWidth();
        int th = 14;
        int lb = MARGIN[1] - 14;
        int rb = w - MARGIN[3] + 14;
        int tb = MARGIN[0] - 14;
        int bb = h - MARGIN[2] + 14;
        boolean bl = inBox = this.mouseY > tb && this.mouseY < bb && this.mouseX > lb && this.mouseX < rb;
        if (!this.dragging && !inBox) {
            return;
        }
        if (!this.dragging) {
            this.dragging = true;
            this.selectionBox.x = this.mouseX;
            this.selectionBox.y = this.mouseY;
        }
        int x = this.mouseX;
        int y = this.mouseY;
        if (!inBox) {
            if (this.mouseX < lb) {
                if (this.mouseY > bb) {
                    x = lb;
                    y = bb;
                } else if (this.mouseY < tb) {
                    x = lb;
                    y = tb;
                } else {
                    x = lb;
                }
            } else if (this.mouseX > rb) {
                if (this.mouseY > bb) {
                    x = rb;
                    y = bb;
                } else if (this.mouseY < tb) {
                    x = rb;
                    y = tb;
                } else {
                    x = rb;
                }
            } else {
                y = this.mouseY < tb ? tb : bb;
            }
        }
        this.selectionBox.w = x - this.selectionBox.x;
        this.selectionBox.h = y - this.selectionBox.y;
        IntList il = new IntList();
        int pl = this.plotData.pres.length;
        for (int p = 0; p < pl; ++p) {
            x = this.calcCoordinate(true, this.plotData.xAxis.co[p]);
            if (!this.selectionBox.contains(x, y = this.calcCoordinate(false, this.plotData.yAxis.co[p]))) continue;
            il.add(this.plotData.pres[p]);
        }
        this.gui.notify.mark(new DBNodes(this.gui.context.data(), il.finish()), (View)this);
        this.nextContext = this.gui.context.marked;
        this.drawSubNodes = false;
        this.markingChanged = true;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.gui.updating || this.gui.painting) {
            return;
        }
        this.dragging = false;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        boolean r;
        if (this.gui.updating || this.gui.painting) {
            return;
        }
        this.markingChanged = true;
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        this.focus();
        boolean bl = r = !SwingUtilities.isLeftMouseButton(e);
        if (r) {
            this.rightClick = true;
            return;
        }
        if (this.gui.context.focused == -1) {
            this.gui.notify.mark(new DBNodes(this.gui.context.data(), new int[0]), (View)this);
            return;
        }
        int pre = this.plotData.findPre(this.gui.context.focused);
        int[] il = this.overlappingNodes(pre);
        if (e.isShiftDown()) {
            DBNodes marked = this.gui.context.marked;
            marked.union(il);
            this.gui.notify.mark(marked, (View)this);
        } else if (e.getClickCount() == 2) {
            this.rightClick = true;
            DBNodes marked = new DBNodes(this.gui.context.data(), new int[0]);
            marked.union(il);
            this.gui.notify.context(marked, false, null);
        } else {
            DBNodes marked = new DBNodes(this.gui.context.data(), il);
            this.gui.notify.mark(marked, (View)this);
        }
        this.nextContext = this.gui.context.marked;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.markingChanged = true;
        this.plotChanged = true;
        if (!this.gui.updating) {
            this.repaint();
        }
    }
}

