/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import org.basex.data.DataText;
import org.basex.gui.GUIConstants;
import org.basex.gui.text.Syntax;
import org.basex.gui.text.TextIterator;
import org.basex.query.QueryText;
import org.basex.query.expr.CmpN;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.path.Axis;
import org.basex.query.func.FuncDefinition;
import org.basex.query.func.Functions;
import org.basex.query.util.NSGlobal;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;

final class SyntaxXQuery
extends Syntax {
    private static final String OPENING = "{(";
    private static final String CLOSING = "})";
    private static final HashSet<String> KEYWORDS = new HashSet();
    private int comment;
    private int quote;
    private boolean var;
    private boolean elem;

    SyntaxXQuery() {
    }

    @Override
    public void init(Color color) {
        super.init(color);
        this.quote = 0;
        this.var = false;
        this.elem = false;
        this.comment = 0;
    }

    @Override
    public Color getColor(TextIterator iter) {
        int ch = iter.curr();
        if (this.quote != 0) {
            if (ch == this.quote) {
                this.quote = 0;
            }
            return GUIConstants.DGRAY;
        }
        if (this.comment == 0 && ch == 40) {
            ++this.comment;
        } else if (this.comment == 1) {
            this.comment = ch == 58 ? 2 : 0;
        } else if (this.comment == 2 && ch == 58) {
            ++this.comment;
        } else if (this.comment == 3 && ch != 58) {
            int n = this.comment = ch == 41 ? 0 : 2;
        }
        if (this.comment != 0) {
            this.var = false;
            return GUIConstants.GRAY;
        }
        if (ch == 34 || ch == 39) {
            this.quote = ch;
            return GUIConstants.DGRAY;
        }
        if (ch == 36) {
            this.var = true;
            return GUIConstants.GREEN;
        }
        if (this.var) {
            this.var = XMLToken.isChar(ch);
            return GUIConstants.GREEN;
        }
        if (Token.digit(ch) && !Double.isNaN(Token.toDouble(Token.token(iter.currString())))) {
            return GUIConstants.PURPLE;
        }
        if (!XMLToken.isNCChar(ch)) {
            this.elem = ch == 60 || ch == 37;
            return GUIConstants.GRAY;
        }
        if (!this.elem && KEYWORDS.contains(iter.currString())) {
            return GUIConstants.BLUE;
        }
        this.elem = false;
        return this.plain;
    }

    @Override
    public byte[] commentOpen() {
        return DataText.XQCOMM_O;
    }

    @Override
    public byte[] commentEnd() {
        return DataText.XQCOMM_C;
    }

    @Override
    public byte[] format(byte[] text, byte[] spaces) {
        int ind = 0;
        TokenBuilder tb = new TokenBuilder();
        int tl = text.length;
        for (int t = 0; t < tl; ++t) {
            int i;
            byte prev;
            byte ch = text[t];
            int open = OPENING.indexOf(ch);
            int close = CLOSING.indexOf(ch);
            byte next = t + 1 < tl ? text[t + 1] : (byte)0;
            byte by = prev = t > 0 ? text[t - 1] : (byte)0;
            if (open != -1 && (next != 58 || ch != 40)) {
                ++ind;
                tb.addByte(ch);
                if (next == 10 || SyntaxXQuery.matches(CLOSING.charAt(open), t, text, 3)) continue;
                tb.add(10);
                for (i = 0; i < ind; ++i) {
                    tb.add(spaces);
                }
                continue;
            }
            if (close != -1 && (prev != 58 || ch != 41)) {
                --ind;
                if (!SyntaxXQuery.spaces(tb) && !SyntaxXQuery.matches(OPENING.charAt(close), t, text, -3)) {
                    tb.add(10);
                    for (i = 0; i < ind; ++i) {
                        tb.add(spaces);
                    }
                }
            }
            tb.addByte(ch);
        }
        return tb.finish();
    }

    private static boolean spaces(TokenBuilder text) {
        byte c;
        for (int t = text.size() - 1; t >= 0 && (c = text.get(t)) != 10; --t) {
            if (Token.ws(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean matches(char ch, int pos, byte[] text, int dist) {
        int p;
        int d = 0;
        while ((dist > 0 ? d < dist : d > dist) && (p = pos + d) >= 0 && p < text.length) {
            if (text[p] == ch) {
                return true;
            }
            d += dist > 0 ? 1 : -1;
        }
        return false;
    }

    static {
        try {
            for (Field field : QueryText.class.getFields()) {
                if ("IGNORE".equals(field.getName())) break;
                Collections.addAll(KEYWORDS, ((String)field.get(null)).split("-"));
            }
            for (FuncDefinition fd : Functions.DEFINITIONS) {
                Collections.addAll(KEYWORDS, Token.string(fd.local()).split("-"));
            }
            for (Axis axis : Axis.VALUES) {
                Collections.addAll(KEYWORDS, axis.name);
            }
            for (CmpV.OpV opV : CmpV.OpV.VALUES) {
                Collections.addAll(KEYWORDS, opV.name);
            }
            for (CmpN.OpN opN : CmpN.OpN.VALUES) {
                Collections.addAll(KEYWORDS, opN.name);
            }
            Atts ns = NSGlobal.NS;
            for (int n = 0; n < ns.size(); ++n) {
                KEYWORDS.add(Token.string(ns.name(n)));
            }
        }
        catch (Exception ex) {
            Util.stack(ex);
        }
    }
}

