/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;
import org.basex.gui.GUIConstants;
import org.basex.gui.dialog.DialogMem;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;
import org.basex.gui.layout.BaseXWindow;
import org.basex.util.Performance;

public final class BaseXMem
extends BaseXPanel {
    private static final int DWIDTH = 70;

    public BaseXMem(BaseXWindow win, boolean mouse) {
        super(win);
        BaseXLayout.setWidth(this, 70);
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.getFont().getSize() + 6));
        if (mouse) {
            this.setCursor(GUIConstants.CURSORHAND);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
        new Timer(true).scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                BaseXMem.this.repaint();
            }
        }, 0L, 5000L);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Runtime rt = Runtime.getRuntime();
        long max = rt.maxMemory();
        long total = rt.totalMemory();
        long used = total - rt.freeMemory();
        int ww = this.getWidth();
        int hh = this.getHeight();
        g.setColor(GUIConstants.BACK);
        g.fillRect(0, 0, ww - 3, hh - 3);
        g.setColor(GUIConstants.gray);
        g.drawLine(0, 0, ww - 4, 0);
        g.drawLine(0, 0, 0, hh - 4);
        g.drawLine(ww - 3, 0, ww - 3, hh - 3);
        g.drawLine(0, hh - 3, ww - 3, hh - 3);
        g.setColor(GUIConstants.color1);
        g.fillRect(2, 2, Math.max(1, (int)(total * (long)(ww - 6) / max)), hh - 6);
        boolean full = used * 6L / 5L > max;
        g.setColor(full ? GUIConstants.colormark4 : GUIConstants.color3);
        g.fillRect(2, 2, Math.max(1, (int)(used * (long)(ww - 6) / max)), hh - 6);
        FontMetrics fm = g.getFontMetrics();
        String mem = Performance.format(used);
        int fw = (ww - fm.stringWidth(mem)) / 2;
        int h = fm.getHeight() - 3;
        g.setColor(full ? GUIConstants.colormark3 : GUIConstants.dgray);
        g.drawString(mem, fw, h);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        DialogMem.show(this.gui);
        this.repaint();
    }
}

