/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Taskbar;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyListener;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIMenuCmd;
import org.basex.gui.GUIOptions;
import org.basex.gui.dialog.DialogAbout;
import org.basex.gui.dialog.DialogPrefs;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXImages;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.text.SearchBar;
import org.basex.gui.text.TextPanel;
import org.basex.io.IOFile;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;

public final class BaseXLayout {
    private static final Map<?, ?> HINTS = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
    private static boolean hints = true;
    private static final String META = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 2 ? "ctrl" : "meta";
    private static KeyListener keys;

    private BaseXLayout() {
    }

    static void focus(Component comp) {
        GUI gui = BaseXLayout.gui(comp);
        if (gui == null) {
            return;
        }
        if (gui.gopts.get(GUIOptions.MOUSEFOCUS).booleanValue() && comp.isEnabled()) {
            comp.requestFocusInWindow();
        }
    }

    public static void hints(Graphics g) {
        if (HINTS != null && hints) {
            try {
                ((Graphics2D)g).addRenderingHints(HINTS);
            }
            catch (Exception ex) {
                Util.stack(ex);
                hints = false;
            }
        }
    }

    public static void antiAlias(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public static void antiAlias(Graphics g, String type) {
        Object hint = null;
        if (type.equals("Off")) {
            hint = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        } else if (type.equals("On")) {
            hint = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
        } else if (type.equals("GASP")) {
            hint = RenderingHints.VALUE_TEXT_ANTIALIAS_GASP;
        }
        if (hint != null) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, hint);
        }
    }

    private static GUI gui(Component comp) {
        Component c = comp;
        do {
            if (!(c instanceof GUI)) continue;
            return (GUI)c;
        } while ((c = c.getParent()) != null);
        return null;
    }

    public static void setWidth(Component comp, int w) {
        comp.setPreferredSize(new Dimension(w, comp.getPreferredSize().height));
    }

    public static void setHeight(Component comp, int h) {
        comp.setPreferredSize(new Dimension(comp.getPreferredSize().width, h));
    }

    public static EmptyBorder border(int t, int l, int b, int r) {
        return new EmptyBorder(t, l, b, r);
    }

    public static void addDrop(final JComponent comp, final DropHandler dnd) {
        comp.setDropTarget(new DropTarget(comp, 3, null, true, null){

            @Override
            public synchronized void drop(DropTargetDropEvent dtde) {
                dtde.acceptDrop(3);
                for (Object clip : BaseXLayout.fromClipboard(dtde::getTransferable)) {
                    dnd.drop(clip);
                }
                comp.requestFocusInWindow();
            }
        });
    }

    public static KeyStroke keyStroke(GUICommand cmd) {
        String scut;
        Object sc = cmd.shortcuts();
        if (sc == null) {
            return null;
        }
        if (sc instanceof BaseXKeys[]) {
            BaseXKeys[] scs = (BaseXKeys[])sc;
            if (scs.length == 0) {
                return null;
            }
            scut = scs[0].shortCut();
        } else {
            scut = Util.info(sc, META);
        }
        KeyStroke ks = KeyStroke.getKeyStroke(scut);
        if (ks == null) {
            Util.errln("Could not assign shortcut: " + sc + " / " + scut, new Object[0]);
        }
        return ks;
    }

    public static void setMnemonic(AbstractButton b, StringBuilder mnem) {
        if (Prop.MAC) {
            return;
        }
        String label = b.getText();
        int ll = label.length();
        for (int l = 0; l < ll; ++l) {
            char ch = Character.toLowerCase(label.charAt(l));
            if (!Token.letter(ch) || mnem.indexOf(Character.toString(ch)) != -1) continue;
            b.setMnemonic(ch);
            mnem.append(ch);
            break;
        }
    }

    public static ArrayList<Object> fromClipboard(Supplier<Transferable> clipboard) {
        ArrayList<Object> list = new ArrayList<Object>();
        int n = 10;
        for (int i = 1; i <= 10; ++i) {
            try {
                Transferable tr;
                Transferable transferable = tr = clipboard != null ? clipboard.get() : Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                if (tr != null) {
                    if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        list.addAll((List)tr.getTransferData(DataFlavor.javaFileListFlavor));
                        break;
                    }
                    if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        list.add(tr.getTransferData(DataFlavor.stringFlavor));
                        break;
                    }
                    StringBuilder sb = new StringBuilder("Data flavors not supported:\n");
                    for (DataFlavor df : tr.getTransferDataFlavors()) {
                        sb.append("- ").append(df).append('\n');
                    }
                    Util.debug(sb, new Object[0]);
                    break;
                }
                Util.debug("Clipboard has no contents.", new Object[0]);
                break;
            }
            catch (Exception ex) {
                Util.stack(ex);
                Performance.sleep((long)i * 200L);
                continue;
            }
        }
        return list;
    }

    public static void toClipboard(String text) {
        int n = 10;
        for (int i = 1; i <= 10; ++i) {
            try {
                Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                clip.setContents(new StringSelection(text), null);
                return;
            }
            catch (Exception ex) {
                Util.stack(ex);
                if (i == 10) {
                    Util.stack(ex);
                    continue;
                }
                Util.debug(ex);
                Performance.sleep((long)i * 200L);
                continue;
            }
        }
    }

    public static void copyPath(String path) {
        try {
            BaseXLayout.toClipboard(Paths.get(path, new String[0]).toRealPath(new LinkOption[0]).toString());
        }
        catch (Exception ex) {
            Util.stack(ex);
        }
    }

    public static void addInteraction(Component comp, BaseXWindow win) {
        comp.addMouseListener(e -> BaseXLayout.focus(comp));
        BaseXDialog dialog = win.dialog();
        if (dialog == null) {
            comp.addKeyListener(BaseXLayout.globalShortcuts(win.gui()));
        } else {
            comp.addKeyListener(e -> {
                BaseXCombo combo;
                BaseXCombo baseXCombo = combo = comp instanceof BaseXCombo ? (BaseXCombo)comp : null;
                if (combo != null && combo.isPopupVisible()) {
                    return;
                }
                if (BaseXKeys.ENTER.is(e) && !(comp instanceof BaseXButton) && !(comp instanceof TextPanel)) {
                    dialog.close();
                } else if (BaseXKeys.ESCAPE.is(e)) {
                    boolean close = true;
                    if (comp instanceof TextPanel) {
                        SearchBar bar = ((TextPanel)comp).getSearch();
                        boolean bl = close = bar == null || !bar.deactivate(true);
                    }
                    if (close) {
                        dialog.cancel();
                    }
                }
            });
        }
    }

    private static KeyListener globalShortcuts(GUI gui) {
        if (keys == null) {
            keys = e -> {
                if (gui.context.data() != null) {
                    if (BaseXKeys.GOBACK.is(e)) {
                        GUIMenuCmd.C_GO_BACK.execute(gui);
                    } else if (BaseXKeys.GOFORWARD.is(e)) {
                        GUIMenuCmd.C_GO_FORWARD.execute(gui);
                    } else if (BaseXKeys.GOUP.is(e)) {
                        GUIMenuCmd.C_GO_UP.execute(gui);
                    } else if (BaseXKeys.GOHOME.is(e)) {
                        GUIMenuCmd.C_GO_HOME.execute(gui);
                    } else if (BaseXKeys.FILTER.is(e)) {
                        GUIMenuCmd.C_FILTER_NODES.execute(gui);
                    }
                }
                if (BaseXKeys.FOCUSINPUT.is(e)) {
                    gui.input.requestFocusInWindow();
                } else if (BaseXKeys.FOCUSEDITOR.is(e)) {
                    gui.editor.focusEditor();
                } else if (BaseXKeys.FOCUSTEXT.is(e)) {
                    gui.text.focusText();
                }
                int fs = gui.gopts.get(GUIOptions.FONTSIZE);
                long nfs = fs;
                if (BaseXKeys.INCFONT1.is(e) || BaseXKeys.INCFONT2.is(e)) {
                    nfs = Math.max((long)(fs + 1), Math.round((double)fs * 1.05));
                } else if (BaseXKeys.DECFONT.is(e)) {
                    nfs = Math.min((long)(fs - 1), Math.round((double)fs / 1.05));
                } else if (BaseXKeys.NORMFONT.is(e)) {
                    nfs = (long)((double)GUIConstants.dmfont.getSize() * 1.4);
                }
                if ((long)fs != nfs) {
                    gui.gopts.set(GUIOptions.FONTSIZE, (int)Math.max(1L, Math.min(128L, nfs)));
                    gui.updateLayout();
                }
            };
        }
        return keys;
    }

    public static String addShortcut(String string, String sc) {
        if (sc == null) {
            return string;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : sc.split(" ")) {
            String t;
            String string2 = "%".equals(s) ? (Prop.MAC ? "meta" : "control") : (t = s);
            if (t.length() != 1) {
                t = Toolkit.getProperty("AWT." + t.toLowerCase(Locale.ENGLISH), t);
            }
            sb.append('+').append(t);
        }
        return string + " (" + sb.substring(1) + ")";
    }

    public static String value(double val) {
        return Token.string(Token.chopNumber(Token.token(val)));
    }

    public static void drawCell(Graphics g, int xs, int xe, int ys, int ye, boolean focus) {
        g.setColor(GUIConstants.gray);
        g.drawRect(xs, ys, xe - xs - 1, ye - ys - 1);
        g.setColor(GUIConstants.BACK);
        g.drawRect(xs + 1, ys + 1, xe - xs - 3, ye - ys - 3);
        g.setColor(focus ? GUIConstants.lgray : GUIConstants.BACK);
        g.fillRect(xs + 1, ys + 1, xe - xs - 2, ye - ys - 2);
    }

    public static void drawCenter(Graphics g, String string, int w, int y) {
        g.drawString(string, (w - BaseXLayout.width(g, string)) / 2, y);
    }

    public static void drawTooltip(Graphics g, String tt, int x, int y, int w, int c) {
        int tw = BaseXLayout.width(g, tt);
        int th = g.getFontMetrics().getHeight();
        int xx = Math.min(w - tw - 8, x);
        g.setColor(GUIConstants.color(c));
        g.fillRect(xx - 1, y - th, tw + 4, th);
        g.setColor(GUIConstants.BACK);
        g.drawString(tt, xx, y - 4);
    }

    public static int width(Graphics g, String s) {
        return g.getFontMetrics().stringWidth(s);
    }

    public static void chopString(Graphics g, byte[] string, int x, int y, int w, int fs) {
        if (w < 10) {
            return;
        }
        int j = string.length;
        try {
            int l = 0;
            int fw = 0;
            for (int k = 0; k < j; k += l) {
                int ww = BaseXLayout.width(g, Token.cp(string, k));
                if (fw + ww >= w - 4) {
                    j = Math.max(1, k - l);
                    if (k > 1) {
                        fw -= BaseXLayout.width(g, Token.cp(string, k - 1));
                    }
                    g.drawString("..", x + fw, y + fs);
                    break;
                }
                fw += ww;
                l = Token.cl(string, k);
            }
        }
        catch (Exception ex) {
            Util.debug(ex);
        }
        g.drawString(Token.string(string, 0, j), x, y + fs);
    }

    public static int width(Graphics g, byte[] string) {
        int fw = 0;
        try {
            int l = string.length;
            for (int k = 0; k < l; k += Token.cl(string, k)) {
                fw += BaseXLayout.width(g, Token.cp(string, k));
            }
        }
        catch (Exception ex) {
            Util.debug(ex);
        }
        return fw;
    }

    public static int width(Graphics g, int cp) {
        return g.getFontMetrics().charWidth(cp);
    }

    public static void resizeFont(JComponent comp, float factor) {
        Font f = comp.getFont();
        comp.setFont(f.deriveFont((float)f.getSize() * factor));
    }

    public static void boldFont(JComponent comp) {
        comp.setFont(comp.getFont().deriveFont(1));
    }

    public static String reversePath(IOFile file) {
        StringBuilder sb = new StringBuilder();
        String[] names = file.file().getParent().split("[/\\\\]");
        for (int n = names.length - 1; n >= 0; --n) {
            sb.append(names[n]);
            if (n <= 0) continue;
            sb.append('/');
        }
        return sb.toString();
    }

    public static String info(IOFile file, boolean full) {
        StringBuilder sb = new StringBuilder();
        if (file != null) {
            sb.append(full ? file.path() : file.name());
            if (file.exists()) {
                sb.append(" (").append(Performance.format(file.length())).append(')');
            }
        }
        return sb.toString();
    }

    public static String results(long count, long bytes, GUI gui) {
        GUIOptions gopts = gui.gopts;
        BiFunction<Long, Integer, String> more = (num, max) -> num >= (long)max.intValue() ? "\u2265" : "";
        StringBuilder sb = new StringBuilder();
        if (count >= 0L) {
            String num2 = new DecimalFormat("#,###,###").format(count);
            String text = more.apply(count, gopts.get(GUIOptions.MAXRESULTS)) + num2;
            sb.append(Util.info(count == 1L ? Text.RESULT_X : Text.RESULTS_X, text));
            if (bytes >= 0L) {
                int maxtext = gopts.get(GUIOptions.MAXTEXT);
                sb.append(", ").append(more.apply(bytes, maxtext)).append(Performance.format(bytes));
            }
        }
        return sb.length() > 0 ? sb.toString() : " ";
    }

    public static void initMac(GUI gui) {
        try {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            Desktop desktop = Desktop.getDesktop();
            desktop.setAboutHandler(e -> DialogAbout.show(gui));
            desktop.setPreferencesHandler(e -> DialogPrefs.show(gui));
            desktop.setQuitHandler((e, r) -> {
                if (gui.quit()) {
                    r.performQuit();
                } else {
                    r.cancelQuit();
                }
            });
            Taskbar taskbar = Taskbar.getTaskbar();
            taskbar.setIconImage(BaseXImages.get("logo_large"));
        }
        catch (Exception ex) {
            Util.errln("Failed to initialize native Mac OS X interface:", new Object[0]);
            Util.stack(ex);
        }
    }

    public static interface DropHandler {
        public void drop(Object var1);
    }
}

