/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXHistory;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.BaseXTextHint;
import org.basex.gui.layout.BaseXWindow;
import org.basex.util.Util;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.EnumOption;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Option;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;
import org.basex.util.options.StringsOption;

public class BaseXCombo
extends JComboBox<Object> {
    private Options options;
    private Option<?> option;
    private BaseXHistory history;
    private BaseXTextHint hint;
    private KeyListener keys;
    private FocusListener focus;
    private final BaseXWindow win;

    public BaseXCombo(BaseXWindow win, NumberOption option, Options options, String ... values) {
        this(win, option, options, false, values);
        this.setSelectedItem(values[options.get(option)]);
    }

    public BaseXCombo(BaseXWindow win, BooleanOption option, Options options) {
        this(win, option, options, false, "true", "false");
        this.setSelectedItem(options.get(option));
    }

    public BaseXCombo(BaseXWindow win, EnumOption<?> option, Options options) {
        this(win, option, options, false, option.strings());
        this.setSelectedItem(options.get(option));
    }

    public final BaseXCombo history(StringsOption opt, Options opts) {
        if (!this.isEditable()) {
            throw Util.notExpected("Combobox is not editable.", new Object[0]);
        }
        this.options = opts;
        this.option = opt;
        this.history = new BaseXHistory(opt, this.options);
        this.setItems(opts.get(opt));
        BaseXTextField comp = this.textField();
        comp.removeKeyListener(this.keys);
        this.keys = e -> {
            String value;
            boolean next = BaseXKeys.NEXTLINE.is(e);
            boolean prev = BaseXKeys.PREVLINE.is(e);
            if ((next || prev) && e.isShiftDown() && (value = this.history.get(next)) != null) {
                this.setText(value);
                BaseXDialog dialog = this.win.dialog();
                if (dialog != null) {
                    dialog.action(this);
                }
            }
        };
        comp.addKeyListener(this.keys);
        comp.removeFocusListener(this.focus);
        this.focus = e -> this.updateHistory();
        comp.addFocusListener(this.focus);
        return this;
    }

    private BaseXCombo(BaseXWindow win, Option<?> option, Options options, boolean editable, String ... values) {
        this(win, editable, values);
        this.options = options;
        this.option = option;
    }

    public BaseXCombo(BaseXWindow win, String ... values) {
        this(win, false, values);
    }

    public BaseXCombo(BaseXWindow win, boolean editable, String ... values) {
        super(values);
        this.win = win;
        this.setEditable(editable);
        this.setEditor(new BaseXEditor(win.gui(), this));
        BaseXLayout.addInteraction(this, win);
        final BaseXDialog dialog = win.dialog();
        if (dialog == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            BaseXTextField tf = this.textField();
            if (tf == null) {
                this.addActionListener(e -> dialog.action(this));
            } else {
                tf.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        dialog.action(BaseXCombo.this);
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        dialog.action(BaseXCombo.this);
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                    }
                });
            }
        });
    }

    public BaseXCombo hint(String label) {
        BaseXTextField tf = this.textField();
        if (tf != null) {
            if (this.hint == null) {
                this.hint = new BaseXTextHint(label, tf);
            } else {
                this.hint.setText(label);
            }
        }
        this.setToolTipText(label.replaceAll("\\.\\.\\.$", ""));
        return this;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        BaseXTextField tf = this.textField();
        if (this.hint != null && tf != null) {
            this.hint.setFont(tf.getFont());
        }
    }

    public void setItems(String ... items) {
        this.setModel(new DefaultComboBoxModel<String>(items));
    }

    public void updateHistory() {
        if (this.history != null) {
            this.history.add(this.getText());
            SwingUtilities.invokeLater(() -> this.setItems(this.history.values()));
        }
    }

    public String getText() {
        return this.getSelectedItem();
    }

    public void setText(String text) {
        this.setSelectedItem(text);
    }

    @Override
    public String getSelectedItem() {
        Object item = this.isEditable() ? this.getEditor().getItem() : super.getSelectedItem();
        return item == null ? "" : item.toString();
    }

    public BaseXTextField textField() {
        return this.isEditable() ? (BaseXTextField)this.getEditor().getEditorComponent() : null;
    }

    @Override
    public void setSelectedItem(Object object) {
        if (object == null) {
            return;
        }
        String value = object.toString();
        if (this.isEditable()) {
            this.getEditor().setItem(value);
        } else {
            ComboBoxModel model = this.getModel();
            int ms = model.getSize();
            for (int m = 0; m < ms; ++m) {
                if (!model.getElementAt(m).equals(value)) continue;
                super.setSelectedItem(value);
                return;
            }
        }
        if (this.hint != null) {
            this.hint.update();
        }
    }

    public synchronized void highlight(boolean hits) {
        BaseXTextField tf = this.textField();
        (tf != null ? tf : this).setBackground(hits ? GUIConstants.BACK : GUIConstants.LRED);
    }

    @Override
    public synchronized KeyListener[] getKeyListeners() {
        BaseXTextField tf = this.textField();
        return tf != null ? tf.getKeyListeners() : super.getKeyListeners();
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        BaseXTextField tf = this.textField();
        if (tf != null) {
            tf.addKeyListener(l);
        } else {
            super.addKeyListener(l);
        }
    }

    @Override
    public synchronized void removeKeyListener(KeyListener l) {
        BaseXTextField tf = this.textField();
        if (tf != null) {
            tf.removeKeyListener(l);
        }
        super.removeKeyListener(l);
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        BaseXTextField tf = this.textField();
        if (tf != null) {
            tf.addFocusListener(l);
        } else {
            super.addFocusListener(l);
        }
    }

    @Override
    public synchronized void removeFocusListener(FocusListener l) {
        BaseXTextField tf = this.textField();
        if (tf != null) {
            tf.removeFocusListener(l);
        }
        super.removeFocusListener(l);
    }

    public void assign() {
        if (this.option instanceof NumberOption) {
            this.options.set((NumberOption)this.option, this.getSelectedIndex());
        } else if (this.option instanceof EnumOption) {
            this.options.set((EnumOption)this.option, this.getSelectedItem());
        } else if (this.option instanceof StringOption) {
            this.options.set((StringOption)this.option, this.getSelectedItem());
        } else if (this.option instanceof BooleanOption) {
            this.options.set((BooleanOption)this.option, Boolean.parseBoolean(this.getSelectedItem()));
        } else if (this.option instanceof StringsOption) {
            this.updateHistory();
        } else {
            throw Util.notExpected("Option type not supported: " + this.option, new Object[0]);
        }
    }

    private static final class BaseXEditor
    implements ComboBoxEditor {
        private final BaseXTextField tf;

        private BaseXEditor(GUI gui, BaseXCombo combo) {
            this.tf = new BaseXTextField(gui);
            Component comp = combo.getEditor().getEditorComponent();
            if (comp instanceof JTextField) {
                this.tf.setBorder(((JTextField)comp).getBorder());
            }
        }

        @Override
        public Component getEditorComponent() {
            return this.tf;
        }

        @Override
        public void setItem(Object text) {
            if (text != null) {
                this.tf.setText(text.toString());
            }
        }

        @Override
        public String getItem() {
            return this.tf.getText();
        }

        @Override
        public void selectAll() {
            this.tf.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.tf.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.tf.removeActionListener(l);
        }
    }
}

