/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.ColumnLayout;
import org.basex.gui.layout.RowLayout;
import org.basex.io.IOFile;

public final class DialogBindings
extends BaseXDialog {
    private static final int MAX = 8;
    private final BaseXTextField[] names = new BaseXTextField[8];
    private final BaseXTextField[] values = new BaseXTextField[8];
    private final BaseXTextField ctxitem;

    public DialogBindings(GUI gui) {
        super(gui, Text.EXTERNAL_VARIABLES);
        ((BorderLayout)this.panel.getLayout()).setHgap(4);
        this.ctxitem = new BaseXTextField(this).hint(gui.editor.context());
        BaseXBack center = new BaseXBack(new RowLayout(4));
        for (int c = -1; c < 9; ++c) {
            BaseXBack row = new BaseXBack(new ColumnLayout(4));
            if (c == -1) {
                row.add(new BaseXLabel(Text.NAME + ": ", false, true));
                row.add(new BaseXLabel(Text.VALUE + ": ", false, true));
            } else if (c < 8) {
                this.names[c] = new BaseXTextField(this);
                row.add(this.names[c]);
                this.values[c] = new BaseXTextField(this);
                row.add(this.values[c]);
            } else {
                row.add(new BaseXLabel("Context item: "));
                BaseXBack ctx = new BaseXBack().layout(new BorderLayout(8, 0));
                ctx.add((Component)this.ctxitem, "Center");
                BaseXButton browse = new BaseXButton(this, Text.BROWSE_D);
                browse.addActionListener(e -> this.choose());
                ctx.add((Component)browse, "East");
                row.add(ctx);
            }
            BaseXLayout.setWidth(row.getComponent(0), 120);
            BaseXLayout.setWidth(row.getComponent(1), 480);
            center.add(row);
        }
        this.set(center, "Center");
        this.set(this.okCancel(), "South");
        this.fill();
        this.ok = true;
        this.setResizable(true);
        this.finish();
    }

    private void fill() {
        MainOptions opts = this.gui.context.options;
        int c = 0;
        for (Map.Entry<String, String> entry : opts.toMap(MainOptions.BINDINGS).entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (name.isEmpty()) {
                this.ctxitem.setText(value);
                continue;
            }
            if (c >= 8) continue;
            this.names[c].setText("$" + name.replaceAll("^\\$", ""));
            this.values[c].setText(value);
            ++c;
        }
        while (c < 8) {
            this.names[c].setText("$");
            this.values[c].setText("");
            ++c;
        }
    }

    private void choose() {
        BaseXFileChooser fc = new BaseXFileChooser(this.gui, Text.OPEN, this.gui.gopts.get(GUIOptions.WORKPATH));
        fc.filter("XML Documents", true, this.gui.gopts.xmlSuffixes());
        IOFile file = fc.select(BaseXFileChooser.Mode.FOPEN);
        if (file == null) {
            return;
        }
        this.close();
        this.gui.editor.setContext(file);
    }

    @Override
    public void close() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int c = 0; c < 8; ++c) {
            String name = this.names[c].getText().replaceAll("^\\s*\\$|\\s+$", "");
            if (name.isEmpty()) continue;
            map.put(name, this.values[c].getText());
        }
        String value = this.ctxitem.getText();
        if (!value.isEmpty()) {
            map.put("", value);
        }
        DialogBindings.assign(map, this.gui);
        this.gui.editor.refreshContextLabel();
        super.close();
    }

    public static void assign(Map<String, String> map, GUI gui) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append((name + "=" + value).replace(",", ",,"));
        }
        gui.set(MainOptions.BINDINGS, sb.toString());
    }
}

