/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.AQuery;
import org.basex.core.cmd.Find;
import org.basex.core.cmd.Set;
import org.basex.core.cmd.XQuery;
import org.basex.core.jobs.JobException;
import org.basex.core.parse.CommandParser;
import org.basex.core.parse.PasswordReader;
import org.basex.data.Data;
import org.basex.data.Namespaces;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIInput;
import org.basex.gui.GUIMenu;
import org.basex.gui.GUIMenuCmd;
import org.basex.gui.GUIOptions;
import org.basex.gui.GUIStatus;
import org.basex.gui.GUIToolBar;
import org.basex.gui.dialog.DialogPass;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXImages;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXToolBar;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.view.ViewContainer;
import org.basex.gui.view.ViewNotifier;
import org.basex.gui.view.editor.EditorArea;
import org.basex.gui.view.editor.EditorView;
import org.basex.gui.view.explore.ExploreView;
import org.basex.gui.view.folder.FolderView;
import org.basex.gui.view.info.InfoView;
import org.basex.gui.view.map.MapView;
import org.basex.gui.view.plot.PlotView;
import org.basex.gui.view.table.TableView;
import org.basex.gui.view.text.TextView;
import org.basex.gui.view.tree.TreeView;
import org.basex.io.IOUrl;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.seq.DBNodes;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.Version;
import org.basex.util.options.Option;

public final class GUI
extends JFrame
implements BaseXWindow {
    public final Context context;
    public final GUIOptions gopts;
    public final ViewNotifier notify;
    public final GUIStatus status;
    public final GUIInput input;
    public final EditorView editor;
    public final TextView text;
    public final InfoView info;
    public boolean painting;
    public boolean updating;
    boolean fullscreen;
    final BaseXBack buttons;
    final BaseXBack nav;
    private final GUIMenu menu;
    private final ViewContainer views;
    private final AbstractButton stop;
    private final BaseXCombo mode;
    private final BaseXBack top;
    private final BaseXBack control;
    private final BaseXLabel results;
    private final GUIToolBar toolbar;
    private volatile Command command;
    private final AtomicInteger commandID = new AtomicInteger(0);
    private boolean running;
    private int menuHeight;
    private JFrame fullscr;
    private static volatile PasswordReader pwReader;
    private static final Pattern VERSION_CHECK;

    public GUI(Context context, GUIOptions gopts) {
        this.context = context;
        this.gopts = gopts;
        if (Prop.MAC) {
            BaseXLayout.initMac(this);
        }
        this.setIconImage(BaseXImages.get("logo_small"));
        this.setTitle();
        Dimension scr = Toolkit.getDefaultToolkit().getScreenSize();
        int[] loc = gopts.get(GUIOptions.GUILOC);
        int[] size = gopts.get(GUIOptions.GUISIZE);
        int x = Math.max(0, Math.min(scr.width - size[0], loc[0]));
        int y = Math.max(0, Math.min(scr.height - size[1], loc[1]));
        this.setBounds(x, y, size[0], size[1]);
        if (gopts.get(GUIOptions.MAXSTATE).booleanValue()) {
            this.setExtendedState(2);
            this.setExtendedState(4);
            this.setExtendedState(6);
        }
        this.top = new BaseXBack(new BorderLayout());
        this.control = new BaseXBack(new BorderLayout());
        this.menu = new GUIMenu(this);
        this.setJMenuBar(this.menu);
        this.buttons = new BaseXBack(new BorderLayout());
        this.toolbar = new GUIToolBar(GUIConstants.TOOLBAR, this);
        this.buttons.add((Component)this.toolbar, "West");
        this.results = new BaseXLabel(" ").border(-2, 0, 0, 4).resize(1.7f);
        this.results.setHorizontalAlignment(4);
        BaseXBack b = new BaseXBack();
        b.add(this.results);
        this.buttons.add((Component)b, "East");
        if (this.gopts.get(GUIOptions.SHOWBUTTONS).booleanValue()) {
            this.control.add((Component)this.buttons, "Center");
        }
        this.mode = new BaseXCombo((BaseXWindow)this, Text.FIND, "XQuery", Text.COMMAND);
        this.mode.setSelectedIndex(2);
        this.input = new GUIInput(this);
        this.input.mode(this.mode.getSelectedItem());
        this.mode.addActionListener(e -> {
            int s = this.mode.getSelectedIndex();
            if (s == gopts.get(GUIOptions.SEARCHMODE) || !this.mode.isEnabled()) {
                return;
            }
            gopts.set(GUIOptions.SEARCHMODE, s);
            this.input.mode(this.mode.getSelectedItem());
        });
        b = new BaseXBack(new BorderLayout(4, 0));
        b.add((Component)this.input, "Center");
        this.nav = new BaseXBack(new BorderLayout(5, 0)).border(2, 2, 0, 2);
        this.nav.add((Component)this.mode, "West");
        this.nav.add((Component)b, "Center");
        AbstractButton go = BaseXButton.get("c_go", Text.RUN_QUERY, false, this);
        go.addActionListener(e -> this.execute());
        this.stop = BaseXButton.get("c_stop", Text.STOP, false, this);
        this.stop.setEnabled(false);
        this.stop.addActionListener(e -> {
            if (this.command != null) {
                this.command.stop();
                this.stop.setEnabled(false);
            }
        });
        BaseXToolBar tb = new BaseXToolBar();
        tb.add(go);
        tb.add(this.stop);
        this.nav.add((Component)tb, "East");
        if (this.gopts.get(GUIOptions.SHOWINPUT).booleanValue()) {
            this.control.add((Component)this.nav, "South");
        }
        this.top.add((Component)this.control, "North");
        this.notify = new ViewNotifier(this);
        this.text = new TextView(this.notify);
        this.editor = new EditorView(this.notify);
        this.info = new InfoView(this.notify);
        context.setExternal(this.info);
        this.views = new ViewContainer(this, this.text, this.editor, this.info, new FolderView(this.notify), new PlotView(this.notify), new TableView(this.notify), new MapView(this.notify), new TreeView(this.notify), new ExploreView(this.notify));
        this.top.add((Component)this.views, "Center");
        this.setContentBorder();
        this.status = new GUIStatus(this);
        if (this.gopts.get(GUIOptions.SHOWSTATUS).booleanValue()) {
            this.top.add((Component)this.status, "South");
        }
        this.setDefaultCloseOperation(2);
        this.add(this.top);
        this.setVisible(true);
        this.views.updateViews();
        this.refreshControls(true);
        if (gopts.get(GUIOptions.CHECKUPDATES).booleanValue() && !Strings.contains(Prop.VERSION, ' ')) {
            SwingUtilities.invokeLater(() -> this.checkVersion(false));
        }
    }

    @Override
    public void dispose() {
        this.quit();
    }

    public boolean quit() {
        if (this.editor.confirm(null)) {
            this.saveOptions();
            this.context.close();
            super.dispose();
            return true;
        }
        return false;
    }

    public void saveOptions() {
        this.gopts.setFiles(GUIOptions.OPEN, this.editor.openFiles());
        boolean max = this.getExtendedState() == 6;
        this.gopts.set(GUIOptions.MAXSTATE, max);
        if (!max) {
            this.gopts.set(GUIOptions.GUILOC, new int[]{this.getX(), this.getY()});
            this.gopts.set(GUIOptions.GUISIZE, new int[]{this.getWidth(), this.getHeight()});
        }
        this.gopts.write();
        this.context.soptions.write();
    }

    public void setTitle() {
        Data data;
        EditorArea ea;
        TokenBuilder tb = new TokenBuilder();
        EditorArea editorArea = ea = this.editor == null ? null : this.editor.getEditor();
        if (ea != null) {
            tb.add(ea.opened() ? ea.file().path() : ea.file().name());
            if (ea.modified()) {
                tb.add(42);
            }
        }
        if ((data = this.context.data()) != null) {
            if (!tb.isEmpty()) {
                tb.add(32);
            }
            tb.add("[").add(data.meta.name).add("]");
        }
        if (!tb.isEmpty()) {
            tb.add(" - ");
        }
        tb.add(Text.TITLE);
        this.setTitle(tb.toString());
    }

    public void cursor(Cursor cursor) {
        this.cursor(cursor, false);
    }

    public void cursor(Cursor cursor, boolean enforce) {
        Cursor cc = this.getCursor();
        if (cc != cursor && (cc != GUIConstants.CURSORWAIT || enforce)) {
            this.setCursor(cursor);
        }
    }

    void execute() {
        String in = this.input.getText().trim();
        boolean cmd = this.mode.getSelectedIndex() == 2;
        boolean exc = Strings.startsWith(in, '!');
        if (cmd || exc) {
            try {
                CommandParser cp = CommandParser.get(in.substring(exc ? 1 : 0), this.context);
                if (pwReader == null) {
                    pwReader = () -> {
                        DialogPass dp = new DialogPass(this);
                        return dp.ok() ? dp.password() : "";
                    };
                }
                cp.pwReader(pwReader);
                this.execute(cp.parse());
            }
            catch (QueryException ex) {
                if (!this.info.visible()) {
                    GUIMenuCmd.C_SHOW_INFO.execute(this);
                }
                this.info.setInfo(Util.message(ex), null, false, true);
            }
        } else if (this.gopts.get(GUIOptions.SEARCHMODE) == 1 || Strings.startsWith(in, '/')) {
            this.simpleQuery(in);
        } else {
            this.execute(new Find(in));
        }
    }

    public void simpleQuery(String query) {
        Data data;
        String q = query.trim().isEmpty() ? "()" : query;
        Namespaces ns = data.nspaces;
        data = this.context.data();
        int uriId = ns.uriIdForPrefix(Token.EMPTY, 0, data);
        if (uriId != 0) {
            q = Util.info("declare default element namespace \"%\"; %", ns.uri(uriId), q);
        }
        this.execute(new XQuery(q));
    }

    public void execute(Command ... cmd) {
        this.execute(false, cmd);
    }

    public void execute(boolean editing, Command ... cmds) {
        if (this.updating) {
            return;
        }
        new Thread(() -> {
            if (cmds.length == 0) {
                this.info.setInfo("", null, true, true);
            }
            for (Command cmd : cmds) {
                if (!this.execute(cmd, editing)) break;
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute(Command cmd, boolean editing) {
        Command c;
        int id = this.commandID.incrementAndGet();
        while ((c = this.command) != null) {
            c.stop();
            Performance.sleep(1L);
            if (this.commandID.get() == id) continue;
            return true;
        }
        this.cursor(GUIConstants.CURSORWAIT);
        this.input.setCursor(GUIConstants.CURSORWAIT);
        this.stop.setEnabled(true);
        if (editing) {
            this.editor.pleaseWait(id);
        }
        Data data = this.context.data();
        if (this.gopts.get(GUIOptions.FILTERRT).booleanValue() && data != null && !this.context.root()) {
            this.context.invalidate();
        }
        DBNodes current = this.context.current();
        this.command = cmd;
        ArrayOutput output = new ArrayOutput();
        output.setLimit(this.gopts.get(GUIOptions.MAXTEXT));
        if (cmd instanceof AQuery) {
            ((AQuery)cmd).maxResults(this.gopts.get(GUIOptions.MAXRESULTS));
        }
        Performance perf = new Performance();
        boolean ok = true;
        try {
            String inf;
            this.running = true;
            this.updating = cmd.updating(this.context);
            if (cmd.newData(this.context)) {
                this.notify.init();
            }
            Throwable cause = null;
            try {
                cmd.execute(this.context, output);
                inf = cmd.info();
            }
            catch (BaseXException ex) {
                cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                ok = false;
                inf = Util.message(ex);
            }
            finally {
                this.updating = false;
                this.running = false;
            }
            Value value = cmd.result;
            DBNodes nodes = value instanceof DBNodes ? (DBNodes)value : null;
            boolean updated = cmd.updated(this.context);
            if (!this.text.visible()) {
                if (nodes == null && output.size() != 0L) {
                    GUIMenuCmd.C_SHOW_RESULT.execute(this);
                }
                if (!(ok || editing || this.info.visible())) {
                    GUIMenuCmd.C_SHOW_INFO.execute(this);
                }
            }
            boolean stopped = cause instanceof JobException;
            if (editing) {
                this.editor.info(cause, stopped, true);
            }
            if (ok) {
                if (this.context.data() != data) {
                    this.notify.init();
                } else if (updated) {
                    this.notify.update();
                    if (nodes == null && (value == null || value.isEmpty())) {
                        nodes = this.context.current();
                    }
                } else if (value != null) {
                    boolean filterrt = this.gopts.get(GUIOptions.FILTERRT);
                    DBNodes curr = this.context.current();
                    if (filterrt || curr != null && !curr.equals(current)) {
                        if (nodes != null) {
                            this.notify.context(nodes, filterrt, null);
                        }
                    } else if (this.context.marked != null) {
                        DBNodes marked = this.context.marked;
                        if (nodes != null) {
                            marked = nodes;
                        } else if (!marked.isEmpty()) {
                            marked = new DBNodes(data, new int[0]);
                        }
                        if (this.context.marked != marked) {
                            this.notify.mark(marked, null);
                        }
                    }
                }
            }
            if (id == this.commandID.get()) {
                this.editor.refreshContextLabel();
                String total = this.info.setInfo(inf, cmd, perf.getTime(), ok, true);
                if (ok) {
                    this.status.setText(Text.TIME_REQUIRED + ": " + total, true);
                }
                this.results.setText(BaseXLayout.results(value != null ? value.size() : -1L, -1L, this));
                if (nodes == null) {
                    this.text.setText(output, value != null ? value.size() : -1L, cause);
                }
                if (!updated) {
                    this.text.cache(output, cmd, value);
                }
            }
        }
        catch (Exception ex) {
            this.updating = false;
            this.running = false;
            BaseXDialog.error(this, Util.info(Text.EXEC_ERROR_X_X, cmd, Util.bug(ex)));
        }
        this.stop();
        return ok;
    }

    public void stop() {
        if (this.command != null) {
            this.command.stop();
        }
        this.cursor(GUIConstants.CURSORARROW, true);
        this.input.setCursor(GUIConstants.CURSORTEXT);
        this.stop.setEnabled(false);
        this.command = null;
    }

    public boolean running(int id) {
        return id == this.commandID.get() && this.running;
    }

    public <T extends Option<V>, V> void set(T opt, V val) {
        if (!this.context.options.get(opt).toString().equals(val.toString())) {
            Set cmd = new Set(opt, val);
            cmd.run(this.context);
            this.info.setInfo(cmd.info(), cmd, true, false);
        }
    }

    private void setContentBorder() {
        int n = this.control.getComponentCount();
        int n2 = this.top.getComponentCount();
        if (n == 0 && n2 == 2) {
            this.views.border(0);
        } else {
            this.views.setBorder(new CompoundBorder(BaseXLayout.border(3, 1, 3, 1), BorderFactory.createEtchedBorder(1)));
        }
    }

    public void updateLayout() {
        GUIConstants.init(this.gopts);
        this.notify.layout();
        this.views.repaint();
    }

    void updateControl(JComponent comp, boolean show, String layout) {
        if (comp == this.status) {
            if (show) {
                this.top.add((Component)comp, layout);
            } else {
                this.top.remove(comp);
            }
        } else if (comp == this.menu) {
            if (!show) {
                this.menuHeight = this.menu.getHeight();
            }
            int s = show ? this.menuHeight : 0;
            comp.setPreferredSize(new Dimension(comp.getPreferredSize().width, s));
            this.menu.setSize(this.menu.getWidth(), s);
        } else if (show) {
            this.control.add((Component)comp, layout);
        } else {
            this.control.remove(comp);
        }
        this.setContentBorder();
        Container frame = this.fullscr == null ? this.getRootPane() : this.fullscr;
        ((Component)frame).validate();
        this.refreshControls(false);
    }

    public void layoutViews() {
        this.views.updateViews();
        this.refreshControls(true);
    }

    public void refreshControls(boolean result) {
        int m;
        DBNodes marked = this.context.marked;
        DBNodes current = this.context.current();
        if (result && marked != null) {
            this.results.setText(BaseXLayout.results((marked.isEmpty() ? current : marked).size(), -1L, this));
        }
        boolean inf = this.gopts.get(GUIOptions.SHOWINFO);
        this.context.options.set(MainOptions.QUERYINFO, inf);
        this.context.options.set(MainOptions.XMLPLAN, inf);
        Data data = this.context.data();
        this.mode.setEnabled(data != null);
        int n = m = data == null ? 2 : this.gopts.get(GUIOptions.SEARCHMODE);
        if (this.mode.getSelectedIndex() != m) {
            this.mode.setSelectedIndex(m);
            this.input.mode(this.mode.getSelectedItem());
        }
        this.toolbar.refresh();
        this.menu.refresh();
    }

    void fullscreen() {
        this.fullscreen ^= true;
        this.fullscreen(this.fullscreen);
    }

    public void fullscreen(boolean full) {
        if (full ^ this.fullscr == null) {
            return;
        }
        if (full) {
            this.control.remove(this.buttons);
            this.control.remove(this.nav);
            this.getRootPane().remove(this.menu);
            this.top.remove(this.status);
            this.remove(this.top);
            this.fullscr = new JFrame();
            this.fullscr.setIconImage(this.getIconImage());
            this.fullscr.setTitle(this.getTitle());
            this.fullscr.setUndecorated(true);
            this.fullscr.setJMenuBar(this.menu);
            this.fullscr.add(this.top);
            this.fullscr.setDefaultCloseOperation(2);
        } else {
            this.fullscr.removeAll();
            this.fullscr.dispose();
            this.fullscr = null;
            if (!this.gopts.get(GUIOptions.SHOWBUTTONS).booleanValue()) {
                this.control.add((Component)this.buttons, "Center");
            }
            if (!this.gopts.get(GUIOptions.SHOWINPUT).booleanValue()) {
                this.control.add((Component)this.nav, "South");
            }
            if (!this.gopts.get(GUIOptions.SHOWSTATUS).booleanValue()) {
                this.top.add((Component)this.status, "South");
            }
            this.setJMenuBar(this.menu);
            this.add(this.top);
        }
        this.gopts.set(GUIOptions.SHOWBUTTONS, !full);
        this.gopts.set(GUIOptions.SHOWINPUT, !full);
        this.gopts.set(GUIOptions.SHOWSTATUS, !full);
        this.fullscreen = full;
        GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(this.fullscr);
        this.setContentBorder();
        this.updateControl(this.menu, !full, "North");
        this.setVisible(!full);
    }

    @Override
    public GUI gui() {
        return this;
    }

    @Override
    public BaseXDialog dialog() {
        return null;
    }

    @Override
    public GUI component() {
        return this;
    }

    void checkVersion(boolean ask) {
        boolean check;
        Version version;
        Version latest = version = new Version(this.gopts.get(GUIOptions.UPDATEVERSION));
        try {
            Matcher matcher = VERSION_CHECK.matcher(new IOUrl(Text.VERSION_URL).string());
            if (matcher.matches()) {
                latest = new Version(matcher.group(2));
                this.gopts.set(GUIOptions.UPDATEVERSION, latest.toString());
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
        }
        boolean chk = check = this.gopts.get(GUIOptions.CHECKUPDATES).booleanValue();
        if (version.compareTo(latest) < 0) {
            if (BaseXDialog.confirm(this, Util.info(Text.H_VERSION_NEW_X_X, "BaseX", latest))) {
                BaseXDialog.browse(this, Text.UPDATE_URL);
            } else if (ask) {
                chk = BaseXDialog.confirm(this, Text.H_VERSION_CHECK);
                this.gopts.set(GUIOptions.CHECKUPDATES, chk);
            }
            this.saveOptions();
        } else if (ask) {
            chk = BaseXDialog.confirm(this, Util.info(Text.H_VERSION_LATEST_X, "BaseX") + "\n" + Text.H_VERSION_CHECK);
            this.gopts.set(GUIOptions.CHECKUPDATES, chk);
        }
        if (!version.equals(latest) || check != chk) {
            this.saveOptions();
        }
    }

    static {
        VERSION_CHECK = Pattern.compile("^(Version )?([\\w\\d.]*?)( .*|$)", 32);
    }
}

