/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.io.IOException;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.data.Namespaces;
import org.basex.index.IdPreMap;
import org.basex.index.IndexBuilder;
import org.basex.index.IndexType;
import org.basex.index.name.Names;
import org.basex.index.path.PathIndex;
import org.basex.index.value.MemValuesBuilder;
import org.basex.index.value.ValueIndex;
import org.basex.io.random.TableMemAccess;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenSet;

public final class MemData
extends Data {
    private final TokenSet texts;
    private final TokenSet values;

    public MemData(PathIndex paths, Namespaces nspaces, MainOptions options) {
        this(null, null, paths, nspaces, null, null, options);
    }

    public MemData(MainOptions options) {
        this(null, null, options);
    }

    private MemData(Names elemNames, Names attrNames, PathIndex paths, Namespaces nspaces, TokenSet texts, TokenSet values, MainOptions options) {
        super(new MetaData(options));
        this.table = new TableMemAccess(this.meta);
        if (this.meta.updindex) {
            this.idmap = new IdPreMap(this.meta.lastid);
        }
        this.texts = texts == null ? new TokenSet() : texts;
        this.values = values == null ? new TokenSet() : values;
        this.elemNames = elemNames == null ? new Names(this.meta) : elemNames;
        this.attrNames = attrNames == null ? new Names(this.meta) : attrNames;
        this.paths = paths == null ? new PathIndex(this) : paths;
        this.nspaces = nspaces == null ? new Namespaces() : nspaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createIndex(IndexType type, Command cmd) throws IOException {
        MemValuesBuilder ib;
        switch (type) {
            case TEXT: 
            case ATTRIBUTE: 
            case TOKEN: {
                ib = new MemValuesBuilder(this, type);
                break;
            }
            case FULLTEXT: {
                throw new BaseXException(Text.NO_MAINMEM, new Object[0]);
            }
            default: {
                throw Util.notExpected();
            }
        }
        try {
            if (cmd != null) {
                cmd.pushJob(ib);
            }
            this.set(type, ((IndexBuilder)ib).build());
        }
        finally {
            if (cmd != null) {
                cmd.popJob();
            }
        }
    }

    @Override
    public void dropIndex(IndexType type) throws BaseXException {
        switch (type) {
            case TEXT: 
            case ATTRIBUTE: 
            case TOKEN: {
                break;
            }
            case FULLTEXT: {
                throw new BaseXException(Text.NO_MAINMEM, new Object[0]);
            }
            default: {
                throw Util.notExpected();
            }
        }
        this.set(type, null);
    }

    private void set(IndexType type, ValueIndex index) {
        this.meta.dirty = true;
        switch (type) {
            case TEXT: {
                this.textIndex = index;
                break;
            }
            case ATTRIBUTE: {
                this.attrIndex = index;
                break;
            }
            case TOKEN: {
                this.tokenIndex = index;
                break;
            }
            case FULLTEXT: {
                this.ftIndex = index;
                break;
            }
        }
    }

    @Override
    public void startUpdate(MainOptions opts) {
    }

    @Override
    public void finishUpdate(MainOptions opts) {
    }

    @Override
    public void flush(boolean all) {
    }

    @Override
    public byte[] text(int pre, boolean text) {
        return (text ? this.texts : this.values).key((int)this.textRef(pre));
    }

    @Override
    public long textItr(int pre, boolean text) {
        return Token.toLong(this.text(pre, text));
    }

    @Override
    public double textDbl(int pre, boolean text) {
        return Token.toDouble(this.text(pre, text));
    }

    @Override
    public int textLen(int pre, boolean text) {
        return this.text(pre, text).length;
    }

    @Override
    public boolean inMemory() {
        return true;
    }

    public TokenSet values(boolean text) {
        return text ? this.texts : this.values;
    }

    @Override
    protected void delete(int pre, boolean text) {
    }

    @Override
    protected void updateText(int pre, byte[] value, int kind) {
        this.indexDelete(pre, -1, 1);
        this.textRef(pre, this.textRef(value, kind != 3));
        this.indexAdd(pre, -1, 1, null);
    }

    @Override
    protected long textRef(byte[] value, boolean text) {
        return (text ? this.texts : this.values).put(value);
    }
}

