/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.users;

import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.basex.core.BaseXException;
import org.basex.core.Databases;
import org.basex.core.users.Algorithm;
import org.basex.core.users.Code;
import org.basex.core.users.Perm;
import org.basex.core.users.UserText;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.XMLAccess;

public final class User {
    private final EnumMap<Algorithm, EnumMap<Code, String>> passwords = new EnumMap(Algorithm.class);
    private final LinkedHashMap<String, Perm> patterns = new LinkedHashMap();
    private Perm perm = Perm.NONE;
    private String name;
    private ANode info;

    public User(String name) {
        this.name = name;
    }

    public User(String name, String password) {
        this(name);
        this.password(password);
    }

    public boolean enabled() {
        return !this.passwords.isEmpty();
    }

    User(ANode user, IOFile file) throws BaseXException {
        this.name = Token.string(XMLAccess.attribute(user, UserText.Q_NAME, "Root"));
        this.perm = (Perm)XMLAccess.attribute((String)this.name, (ANode)user, (QNm)UserText.Q_PERMISSION, (Enum[])Perm.values());
        for (ANode child : XMLAccess.children(user)) {
            QNm qname = child.qname();
            if (qname.eq(UserText.Q_PASSWORD)) {
                EnumMap<Code, String> ec = new EnumMap<Code, String>(Code.class);
                Algorithm algorithm = (Algorithm)XMLAccess.attribute((String)this.name, (ANode)child, (QNm)UserText.Q_ALGORITHM, (Enum[])Algorithm.values());
                if (this.passwords.containsKey((Object)algorithm)) {
                    throw new BaseXException("%: Algorithm % supplied more than once.", new Object[]{this.name, algorithm});
                }
                this.passwords.put(algorithm, ec);
                for (ANode code : XMLAccess.children(child)) {
                    Code cd = (Code)XMLAccess.value((String)this.name, (byte[])code.qname().internal(), (Enum[])algorithm.codes);
                    if (ec.containsKey((Object)cd)) {
                        throw new BaseXException("%, %: Code % supplied more than once.", new Object[]{this.name, algorithm, code});
                    }
                    ec.put(cd, Token.string(code.string()));
                }
                for (Code code : algorithm.codes) {
                    if (ec.get((Object)code) != null) continue;
                    throw new BaseXException("%, %: Code '%' missing.", new Object[]{this.name, algorithm, code});
                }
                continue;
            }
            if (qname.eq(UserText.Q_DATABASE)) {
                String nm = Token.string(XMLAccess.attribute(child, UserText.Q_PATTERN, this.name));
                Perm prm = (Perm)XMLAccess.attribute((String)this.name, (ANode)child, (QNm)UserText.Q_PERMISSION, (Enum[])Perm.values());
                this.patterns.put(nm, prm);
                continue;
            }
            if (qname.eq(UserText.Q_INFO)) {
                if (this.info != null) {
                    throw new BaseXException("%: <%/> occurs more than once.", file, qname);
                }
                this.info = child.finish();
                continue;
            }
            throw new BaseXException("%: invalid element <%/>.", file, qname);
        }
    }

    public synchronized FNode toXml(QueryContext qc, InputInfo ii) throws QueryException {
        FBuilder user = FElem.build(UserText.Q_USER).add(UserText.Q_NAME, this.name).add(UserText.Q_PERMISSION, (Object)this.perm);
        this.passwords.forEach((key, value) -> {
            FBuilder pw = FElem.build(UserText.Q_PASSWORD).add(UserText.Q_ALGORITHM, key);
            value.forEach((k, v) -> {
                if (!v.isEmpty()) {
                    pw.add(FElem.build(new QNm(k.toString())).add(v));
                }
            });
            user.add(pw.finish());
        });
        this.patterns.forEach((key, value) -> user.add(FElem.build(UserText.Q_DATABASE).add(UserText.Q_PATTERN, key).add(UserText.Q_PERMISSION, value).finish()));
        if (this.info != null) {
            if (qc != null) {
                user.add((ANode)this.info.materialize(n -> false, ii, qc));
            } else {
                user.add(this.info);
                this.info.parent(null);
            }
        }
        return user.finish();
    }

    public synchronized void name(String nm) {
        this.name = nm;
    }

    public synchronized void drop(String pattern) {
        this.patterns.remove(pattern);
    }

    public synchronized String name() {
        return this.name;
    }

    public synchronized void password(String password) {
        for (Algorithm algorithm : Algorithm.values()) {
            EnumMap codes = this.passwords.computeIfAbsent(algorithm, k -> new EnumMap(Code.class));
            if (algorithm == Algorithm.SALTED_SHA256) {
                String salt = Long.toString(System.nanoTime());
                codes.put(Code.SALT, salt);
                codes.put(Code.HASH, Strings.sha256(salt + password));
                continue;
            }
            codes.put(Code.HASH, User.digest(this.name, password));
        }
    }

    public synchronized String code(Algorithm algorithm, Code code) {
        return this.passwords.get((Object)algorithm).get((Object)code);
    }

    public synchronized Perm perm(String db) {
        Map.Entry<String, Perm> entry;
        if (db != null && (entry = this.find(db)) != null) {
            return entry.getValue();
        }
        return this.perm;
    }

    synchronized Map.Entry<String, Perm> find(String pattern) {
        for (Map.Entry<String, Perm> entry : this.patterns.entrySet()) {
            if (!Databases.regex(entry.getKey()).matcher(pattern).matches()) continue;
            return entry;
        }
        return null;
    }

    public synchronized User perm(Perm prm) {
        this.perm = prm;
        return this;
    }

    public synchronized User perm(Perm prm, String pattern) {
        if (pattern.isEmpty()) {
            this.perm(prm);
        } else {
            this.patterns.put(pattern, prm);
        }
        return this;
    }

    public synchronized boolean has(Perm prm) {
        return this.has(prm, null);
    }

    public synchronized boolean has(Perm prm, String db) {
        return this.perm(db).ordinal() >= prm.ordinal();
    }

    public synchronized boolean matches(String password) {
        if (!this.enabled()) {
            return false;
        }
        EnumMap<Code, String> algorithm = this.passwords.get((Object)Algorithm.SALTED_SHA256);
        return Strings.sha256(algorithm.get((Object)Code.SALT) + password).equals(algorithm.get((Object)Code.HASH));
    }

    public synchronized ANode info() {
        return this.info;
    }

    public synchronized void info(ANode elem) {
        this.info = elem.hasChildren() || elem.attributeIter().size() != 0L ? elem : null;
    }

    private static String digest(String name, String password) {
        return Strings.md5(name + ":BaseX:" + password);
    }
}

