/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.jobs;

import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.function.Consumer;
import org.basex.core.Context;
import org.basex.core.jobs.Job;
import org.basex.core.jobs.JobContext;
import org.basex.core.jobs.JobException;
import org.basex.core.jobs.JobOptions;
import org.basex.core.jobs.JobPool;
import org.basex.core.jobs.JobState;
import org.basex.core.jobs.QueryJobResult;
import org.basex.core.jobs.QueryJobSpec;
import org.basex.core.jobs.QueryJobTask;
import org.basex.query.QueryContext;
import org.basex.query.QueryDateTime;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.value.Value;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.ADateDur;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Tim;
import org.basex.server.Log;
import org.basex.util.InputInfo;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;

public final class QueryJob
extends Job
implements Runnable {
    private final QueryJobResult result = new QueryJobResult(this);
    private final QueryJobSpec job;
    private final Consumer<QueryJobResult> notify;
    private QueryProcessor qp;
    private boolean remove;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryJob(QueryJobSpec job, Context context, InputInfo ii, Consumer<QueryJobResult> notify, QueryContext qc) throws QueryException {
        boolean cache;
        long duration;
        long delay;
        this.job = job;
        this.notify = notify;
        this.jc().context = context;
        JobOptions opts = job.options;
        Item start = QueryJob.time(opts.get(JobOptions.START), ii);
        long interval = 0L;
        String inter = opts.get(JobOptions.INTERVAL);
        if (inter != null && !inter.isEmpty()) {
            interval = QueryJob.ms(new DTDur(Token.token(inter), ii));
            if (interval < 1000L) {
                throw QueryError.JOBS_RANGE_X.get(ii, inter);
            }
            for (delay = start == null ? 0L : QueryJob.delay(start, 0L, ii); delay < 0L; delay += interval) {
            }
        }
        if (delay < 0L) {
            throw QueryError.JOBS_RANGE_X.get(ii, start);
        }
        Item end = QueryJob.time(opts.get(JobOptions.END), ii);
        long l = duration = end == null ? Long.MAX_VALUE : QueryJob.delay(end, delay, ii);
        if (duration <= delay) {
            throw QueryError.JOBS_RANGE_X.get(ii, end);
        }
        boolean bl = cache = opts.contains(JobOptions.CACHE) && opts.get(JobOptions.CACHE) != false;
        if (cache && interval > 0L) {
            throw QueryError.JOBS_OPTIONS.get(ii, new Object[0]);
        }
        JobPool jobs = context.jobs;
        while (jobs.tasks.size() + jobs.active.size() >= 1000) {
            Performance.sleep(10L);
            if (qc == null) continue;
            qc.checkStop();
        }
        Map<String, QueryJobTask> map = jobs.tasks;
        synchronized (map) {
            String id = opts.get(JobOptions.ID);
            if (id != null) {
                if (id.startsWith("job")) {
                    throw QueryError.JOBS_ID_INVALID_X.get(ii, id);
                }
                if (jobs.tasks.containsKey(id) || jobs.active.containsKey(id) || jobs.results.containsKey(id)) {
                    throw QueryError.JOBS_ID_EXISTS_X.get(ii, id);
                }
                this.jc().id(id);
            } else {
                id = this.jc().id();
            }
            if (cache) {
                if (jobs.results.size() >= 1000) {
                    throw QueryError.JOBS_OVERFLOW.get(ii, new Object[0]);
                }
                jobs.results.put(id, this.result);
            }
            QueryJobTask task = new QueryJobTask(this, jobs, delay, interval, duration);
            jobs.tasks.put(id, task);
            if (interval > 0L) {
                jobs.timer.scheduleAtFixedRate((TimerTask)task, delay, interval);
            } else {
                jobs.timer.schedule((TimerTask)task, delay);
            }
        }
    }

    private static Item time(String string, InputInfo ii) throws QueryException {
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (string.matches("^\\d+$")) {
            return Int.get(Int.parse(Token.token(string), ii));
        }
        if (Dur.DTD.matcher(string).matches()) {
            return new DTDur(Token.token(string), ii);
        }
        if (ADate.TIME.matcher(string).matches()) {
            return new Tim(Token.token(string), ii);
        }
        return new Dtm(Token.token(string), ii);
    }

    public HashMap<String, Value> bindings() {
        return this.job.bindings;
    }

    private static long delay(Item start, long min, InputInfo ii) throws QueryException {
        long ms;
        QueryDateTime qdt = new QueryDateTime();
        if (start instanceof Int) {
            ms = start.itr(ii) * 60000L;
            ms -= qdt.time.seconds().multiply(Dec.BD_1000).longValue();
            while (ms <= min) {
                ms += 3600000L;
            }
        } else if (start instanceof DTDur) {
            ms = QueryJob.ms((DTDur)start);
        } else if (start instanceof Dtm) {
            ms = QueryJob.ms(new DTDur((Dtm)start, qdt.datm, ii));
        } else {
            for (ms = QueryJob.ms(new DTDur((Tim)start, qdt.time, ii)); ms <= min; ms += 86400000L) {
            }
        }
        return ms;
    }

    private static long ms(ADateDur date) {
        return date.sec.multiply(Dec.BD_1000).longValue();
    }

    void remove() {
        this.remove = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.result.init();
        JobContext jc = this.jc();
        String id = jc.id();
        Context ctx = jc.context;
        JobOptions opts = this.job.options;
        String log = opts.get(JobOptions.LOG);
        if (log != null && log.isEmpty()) {
            log = null;
        }
        if (log != null) {
            ctx.log.write(Log.LogType.REQUEST, log, null, "JOB:" + id, ctx);
        }
        Performance perf = new Performance();
        this.qp = new QueryProcessor(this.job.query, opts.get(JobOptions.BASE_URI), ctx, null);
        try {
            for (Map.Entry<String, Value> binding : this.job.bindings.entrySet()) {
                String key = binding.getKey();
                Value value = binding.getValue();
                if (key.isEmpty()) {
                    this.qp.context(value);
                    continue;
                }
                this.qp.variable(key, value);
            }
            this.qp.parse();
            this.updating = this.qp.updating;
            this.result.time = perf.ns();
            this.pushJob(this.qp);
            this.register(ctx);
            perf = new Performance();
            if (this.remove) {
                ctx.jobs.tasks.remove(id);
            }
            this.result.value = this.qp.value().materialize(d -> d == null || d.inMemory(), null, this.qp.qc);
        }
        catch (JobException ex) {
            Util.debug(ex);
            ctx.jobs.results.remove(id);
        }
        catch (QueryException ex) {
            this.result.exception = ex;
        }
        catch (Throwable ex) {
            this.result.exception = QueryError.XQUERY_UNEXPECTED_X.get(null, ex);
        }
        finally {
            if (Boolean.TRUE.equals(opts.get(JobOptions.CACHE))) {
                ctx.jobs.scheduleResult(this);
                this.state(JobState.CACHED);
            } else {
                this.state(JobState.SCHEDULED);
            }
            if (ctx.jobs.active.containsKey(id)) {
                this.qp.close();
                this.unregister(ctx);
                this.popJob();
                this.qp = null;
                this.result.time += jc.performance.ns();
            }
            if (log != null) {
                Log.LogType type;
                String msg = null;
                if (this.result.exception != null) {
                    type = Log.LogType.ERROR;
                    msg = this.result.exception.getMessage();
                } else {
                    type = Log.LogType.OK;
                }
                ctx.log.write(type, msg, perf, "JOB:" + id, ctx);
            }
            if (this.remove) {
                ctx.jobs.tasks.remove(id);
            }
            if (this.notify != null) {
                this.notify.accept(this.result);
            }
            if (this.result.value != null && this.result.value.isEmpty()) {
                ctx.jobs.results.remove(id);
            }
        }
    }

    @Override
    public void addLocks() {
        this.qp.addLocks();
    }

    public String toString() {
        return this.job.simple ? this.job.query : this.job.options.get(JobOptions.BASE_URI);
    }
}

