/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.jobs;

import org.basex.core.Context;
import org.basex.core.jobs.Job;
import org.basex.core.locks.Locks;
import org.basex.query.QueryTracer;
import org.basex.util.Performance;
import org.basex.util.Util;

public final class JobContext {
    private static final QueryTracer TRACER = info -> {
        Util.errln(info, new Object[0]);
        return false;
    };
    static final String PREFIX = "job";
    private static long jobId = -1L;
    public final Locks locks = new Locks();
    public final long time = System.currentTimeMillis();
    public Performance performance;
    public Context context;
    private final Job job;
    private String id;
    private String tp;
    private String desc;

    JobContext(Job job) {
        this.job = job;
    }

    public void id(String string) {
        this.id = string;
    }

    public String id() {
        if (this.id == null) {
            jobId = Math.max(0L, jobId + 1L);
            this.id = PREFIX + jobId;
        }
        return this.id;
    }

    public void type(String type) {
        this.tp = type;
    }

    public void description(String description) {
        this.desc = description;
    }

    public String type() {
        return this.tp != null ? this.tp : Util.className(this.job);
    }

    public QueryTracer tracer() {
        QueryTracer qt;
        if (this.context != null && (qt = (QueryTracer)this.context.getExternal(QueryTracer.class)) != null) {
            return qt;
        }
        return TRACER;
    }

    public String toString() {
        return this.desc != null ? this.desc : this.job.toString();
    }
}

