/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.util.Locale;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.core.users.Perm;
import org.basex.util.options.Option;
import org.basex.util.options.Options;

public final class ShowOptions
extends Command {
    public ShowOptions() {
        this((String)null);
    }

    public ShowOptions(Option<?> option) {
        this(option.name());
    }

    public ShowOptions(String key) {
        super(Perm.NONE, key != null ? key : "");
    }

    @Override
    protected boolean run() throws IOException {
        if (this.args[0].isEmpty()) {
            if (this.context.user().has(Perm.ADMIN)) {
                this.out.println(Text.GLOBAL_OPTIONS + ":");
                for (Option<?> o : this.soptions) {
                    this.out.println(o.name() + ": " + this.soptions.get(o));
                }
            }
            this.out.println(Text.NL + Text.LOCAL_OPTIONS + ":");
            for (Option<?> o : this.options) {
                this.out.println(o.name() + ": " + this.options.get(o));
            }
        } else {
            String name = this.args[0].toUpperCase(Locale.ENGLISH);
            Object value = ShowOptions.get(name, this.context);
            if (value == null) {
                return this.error(this.context.options.error(name), new Object[0]);
            }
            this.out.println(name + ": " + value);
        }
        return true;
    }

    public static Object get(String name, Context ctx) {
        Options opts = ctx.options;
        Option<?> opt = opts.option(name);
        if (opt == null && ctx.user().has(Perm.ADMIN)) {
            opts = ctx.soptions;
            opt = opts.option(name);
        }
        return opt == null ? null : opts.get(opt);
    }

    @Override
    public void addLocks() {
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init(Commands.Cmd.SHOW + " " + Commands.CmdShow.OPTIONS).arg(0);
    }
}

