/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.build.DiskBuilder;
import org.basex.build.Parser;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.AlterDB;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateIndex;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.Open;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.data.DiskData;
import org.basex.data.MetaData;
import org.basex.index.resource.ResourceType;
import org.basex.index.resource.Resources;
import org.basex.io.IOFile;
import org.basex.io.serial.BuilderSerializer;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.DBNode;
import org.basex.util.list.IntList;

public final class OptimizeAll
extends ACreate {
    public OptimizeAll() {
        super(Perm.WRITE, true, new String[0]);
    }

    @Override
    protected boolean run() {
        Data data = this.context.data();
        if (!this.update(data, () -> {
            try {
                OptimizeAll.optimizeAll(data, this.context, this.options, this);
                boolean bl = true;
                return bl;
            }
            finally {
                this.context.closeDB();
            }
        })) {
            return false;
        }
        Open open = new Open(data.meta.name);
        return open.run(this.context) ? this.info(Text.DB_OPTIMIZED_X, data.meta.name, this.jc().performance) : this.error(open.info(), new Object[0]);
    }

    @Override
    public boolean newData(Context ctx) {
        return true;
    }

    @Override
    public boolean stoppable() {
        return false;
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init(Commands.Cmd.OPTIMIZE + " ALL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void optimizeAll(Data data, Context context, MainOptions options, OptimizeAll cmd) throws IOException {
        DiskData ndata;
        if (data.inMemory()) {
            throw new BaseXException(Text.NO_MAINMEM, new Object[0]);
        }
        DiskData odata = (DiskData)data;
        MetaData ometa = odata.meta;
        String name = ometa.name;
        if (context.datas.pins(name) > 1) {
            throw new BaseXException(Text.DB_PINNED_X, name);
        }
        options.set(MainOptions.TEXTINDEX, ometa.textindex);
        options.set(MainOptions.ATTRINDEX, ometa.attrindex);
        options.set(MainOptions.TOKENINDEX, ometa.tokenindex);
        options.set(MainOptions.FTINDEX, ometa.ftindex);
        options.set(MainOptions.TEXTINCLUDE, ometa.textinclude);
        options.set(MainOptions.ATTRINCLUDE, ometa.attrinclude);
        options.set(MainOptions.TOKENINCLUDE, ometa.tokeninclude);
        options.set(MainOptions.FTINCLUDE, ometa.ftinclude);
        options.set(MainOptions.STEMMING, ometa.stemming);
        options.set(MainOptions.CASESENS, ometa.casesens);
        options.set(MainOptions.DIACRITICS, ometa.diacritics);
        options.set(MainOptions.LANGUAGE, ometa.language.toString());
        options.set(MainOptions.STOPWORDS, ometa.stopwords);
        options.set(MainOptions.MAXLEN, ometa.maxlen);
        options.set(MainOptions.MAXCATS, ometa.maxcats);
        StaticOptions sopts = context.soptions;
        String tmpName = sopts.createTempDb(name);
        DBParser parser = new DBParser(odata, options);
        DiskBuilder builder = new DiskBuilder(tmpName, parser, sopts, options);
        if (cmd != null) {
            cmd.pushJob(builder);
        }
        try {
            ndata = builder.build();
        }
        finally {
            if (cmd != null) {
                cmd.popJob();
            }
        }
        Close.close(odata, context);
        MetaData nmeta = ndata.meta;
        nmeta.createtext = ometa.createtext;
        nmeta.createattr = ometa.createattr;
        nmeta.createtoken = ometa.createtoken;
        nmeta.createft = ometa.createft;
        nmeta.original = ometa.original;
        nmeta.inputsize = ometa.inputsize;
        nmeta.time = ometa.time;
        nmeta.dirty = true;
        try {
            CreateIndex.create(ndata, cmd);
        }
        catch (Throwable th) {
            DropDB.drop(tmpName, sopts);
            throw th;
        }
        finally {
            ndata.close();
        }
        for (ResourceType type : Resources.BINARIES) {
            IOFile bin = ometa.dir(type);
            if (!bin.exists()) continue;
            bin.rename(nmeta.dir(type));
        }
        if (!DropDB.drop(name, sopts)) {
            throw new BaseXException(Text.DB_NOT_DROPPED_X, name);
        }
        if (!AlterDB.alter(tmpName, name, sopts)) {
            throw new BaseXException(Text.DB_NOT_RENAMED_X, tmpName);
        }
    }

    private static final class DBParser
    extends Parser {
        private final DiskData data;
        private final int size;
        private int pre;

        DBParser(DiskData data, MainOptions options) {
            super(data.meta.original, options);
            this.data = data;
            this.size = data.meta.size;
        }

        @Override
        public void parse(Builder build) throws IOException {
            BuilderSerializer ser = new BuilderSerializer(build){

                @Override
                protected void startOpen(QNm name) throws IOException {
                    super.startOpen(name);
                    ++pre;
                }

                @Override
                protected void openDoc(byte[] name) throws IOException {
                    super.openDoc(name);
                    ++pre;
                }
            };
            IntList il = this.data.resources.docs();
            int is = il.size();
            for (int i = 0; i < is; ++i) {
                ser.serialize(new DBNode(this.data, il.get(i)));
            }
        }

        @Override
        public double progressInfo() {
            return (double)this.pre / (double)this.size;
        }

        @Override
        public String detailedInfo() {
            return Text.CREATE_STATS_D;
        }
    }
}

