/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.locks.Locks;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.CommandParser;
import org.basex.core.users.Perm;
import org.basex.query.QueryException;
import org.basex.util.Util;

public class Execute
extends Command {
    final List<Command> commands;
    String error;

    public Execute(String input) {
        super(Perm.NONE, false, input);
        this.commands = new ArrayList<Command>();
    }

    public Execute(Command ... commands) {
        super(Perm.NONE, false, new String[0]);
        this.commands = Arrays.asList(commands);
    }

    @Override
    public final boolean newData(Context ctx) {
        return Close.close(ctx);
    }

    @Override
    public final void addLocks() {
        Locks locks = this.jc().locks;
        for (Command cmd : this.commands) {
            Locks cmdLocks = cmd.jc().locks;
            (cmd.updating ? cmdLocks.writes : cmdLocks.reads).addGlobal();
        }
        (this.updating ? locks.writes : locks.reads).addGlobal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean run() {
        if (!this.init(this.context)) {
            return this.error(this.error, new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (Command cmd : this.commands) {
            if (cmd.openDB && this.context.data() == null) {
                return this.error(Text.NO_DB_OPENED, new Object[0]);
            }
            try {
                boolean ok = this.pushJob(cmd).run(this.context, this.out);
                sb.append(cmd.info());
                if (ok) continue;
                this.exception = cmd.exception;
                boolean bl = this.error(sb.toString(), new Object[0]);
                return bl;
            }
            finally {
                this.popJob();
            }
        }
        return this.info(sb.toString().replaceAll("\r?\n?$", ""), new Object[0]);
    }

    @Override
    public final boolean updating(Context ctx) {
        if (!this.init(ctx)) {
            return false;
        }
        for (Command cmd : this.commands) {
            this.updating |= cmd.updating(ctx);
        }
        return this.updating;
    }

    boolean init(Context ctx) {
        return this.args.length == 0 || this.init(this.args[0], this.uri, ctx);
    }

    final boolean init(String input, String base, Context ctx) {
        if (this.commands.isEmpty() && this.error == null) {
            try {
                Collections.addAll(this.commands, CommandParser.get(input, ctx).baseURI(base).parse());
            }
            catch (QueryException ex) {
                this.error = Util.message(ex);
                return false;
            }
        }
        return this.error == null;
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init();
        if (this.args.length == 0) {
            cb.arg(null, this.commands.stream().map(Command::toString).collect(Collectors.joining(";")));
        } else {
            cb.arg(0);
        }
    }
}

