/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.basex.core.Command;
import org.basex.core.Text;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.data.DataText;
import org.basex.data.MetaData;
import org.basex.index.resource.ResourceType;
import org.basex.index.resource.Resources;
import org.basex.io.IOFile;
import org.basex.util.Strings;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class Dir
extends Command {
    public Dir(String path) {
        super(Perm.READ, true, path != null ? path : "");
    }

    @Override
    protected boolean run() throws IOException {
        Object path = MetaData.normPath(this.args[0]);
        if (path == null) {
            return this.error(Text.PATH_INVALID_X, this.args[0]);
        }
        if (!((String)path).isEmpty() && !Strings.endsWith((String)path, '/')) {
            path = (String)path + "/";
        }
        Table table = new Table();
        table.description = Text.ENTRIES_X;
        ((TokenList)table.header.add(Text.INPUT_PATH).add(Text.TYPE).add(DataText.CONTENT_TYPE)).add(Text.SIZE);
        ArrayList<TokenList> contents = table.contents;
        Data data = this.context.data();
        HashSet<String> set = new HashSet<String>();
        Resources resources = data.resources;
        IntList docs = resources.docs((String)path, true);
        long ds = docs.size();
        int d = 0;
        while ((long)d < ds) {
            boolean dir;
            int pre = docs.get(d);
            String name = Token.string(Token.substring(data.text(pre, true), ((String)path).length()));
            int i = name.indexOf(47);
            boolean bl = dir = i >= 0;
            if (dir) {
                name = name.substring(0, i);
            }
            if (set.add(name)) {
                contents.add(this.entry(dir, name, data.size(pre, 0), ResourceType.XML));
            }
            ++d;
        }
        if (!data.inMemory()) {
            for (ResourceType type : Resources.BINARIES) {
                IOFile bin = data.meta.file((String)path, type);
                for (IOFile file : bin.children()) {
                    String name;
                    boolean dir = file.isDir();
                    String string = name = dir ? file.name() : type.dbPath(file.name());
                    if (!set.add(name)) continue;
                    contents.add(this.entry(dir, name, file.length(), type));
                }
            }
        }
        this.out.println(table.sort().finish());
        return true;
    }

    private TokenList entry(boolean dir, String name, long size, ResourceType type) {
        TokenList tl = new TokenList(4L).add(name);
        if (dir) {
            tl.add("dir").add("").add("");
        } else {
            tl.add(type.toString()).add(type.contentType(name).toString()).add(size);
        }
        return tl;
    }

    @Override
    public void addLocks() {
        this.jc().locks.reads.add("internal:context");
    }
}

