/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.index.resource.ResourceType;
import org.basex.io.IOFile;
import org.basex.io.in.BufferInput;

public final class BinaryGet
extends ACreate {
    public BinaryGet(String path) {
        super(Perm.NONE, true, path);
    }

    @Override
    protected boolean run() {
        String path = MetaData.normPath(this.args[0]);
        if (path == null) {
            return this.error(Text.PATH_INVALID_X, this.args[0]);
        }
        Data data = this.context.data();
        if (data.inMemory()) {
            return this.error(Text.NO_MAINMEM, new Object[0]);
        }
        IOFile bin = data.meta.file(path, ResourceType.BINARY);
        if (!bin.exists() || bin.isDir()) {
            return this.error(Text.RES_NOT_FOUND_X, path);
        }
        try (BufferInput bi = BufferInput.get(bin);){
            int b;
            while ((b = bi.read()) != -1) {
                this.out.write(b);
            }
        }
        catch (IOException ex) {
            return this.error(ex.toString(), new Object[0]);
        }
        return this.info(Text.QUERY_EXECUTED_X_X, "", this.jc().performance);
    }

    @Override
    public void addLocks() {
        this.jc().locks.reads.add("internal:context");
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init(Commands.Cmd.BINARY + " " + Commands.CmdBinary.GET).add(0);
    }
}

